/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.AtomListEnumerator;
import chemaxon.enumeration.BondListEnumerator;
import chemaxon.enumeration.LinkAtomEnumerator;
import chemaxon.enumeration.MarkushEnumerator;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.MultiBondEnumerator;
import chemaxon.enumeration.RepeatingUnitEnumerator;
import chemaxon.enumeration.RgroupEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.MolFilter;
import chemaxon.util.RandomGenerator;
import chemaxon.util.ValenceFilter;
import java.util.ArrayList;

public class MarkushEnumeratorFactory {
    public static final String MARKUSH_CODE_SEPARATOR = ", ";
    public static final String PROP_ENUM_CODE = "Markush code";
    public static final String PROP_ENUM_INDEX = "EnumIndex";
    private boolean enumHomology = false;
    public static final MolFilter FILTER_VALENCE = new ValenceFilter();
    public static final int COLORING_NONE = 0;
    public static final int COLORING_SCAFFOLD = 1;
    public static final int COLORING_RGROUPS = 2;
    public static final int COLORING_ALL = 3;
    static final String RANDOMLABEL = "randomlabel";
    private int features = 6201;
    private boolean random = false;
    private MolFilter filter = null;
    private boolean alignScaffold = false;
    private int coloring = 0;
    private boolean enumCodeNeeded = false;
    private RandomGenerator randomGenerator = new RandomGenerator();
    private String structureID = null;
    private boolean keepSelectionMarkers = false;
    private String licenseEnvironment = "";
    private static final int[] FEATURES = new int[]{4097, 1, 4096, 32, 2048, 8, 16};
    private PrototypeHolder[] enumeratorPrototypes = null;

    private void setParams(MolEnumerator me) {
        if (me instanceof MarkushEnumerator) {
            MarkushEnumerator ce = (MarkushEnumerator)me;
            ce.setFactory(this);
            ce.setStructureID(this.structureID);
            ce.setFilter(this.filter);
            ce.setKeepSelectionMarkers(this.keepSelectionMarkers);
        }
        me.setFeatures(this.features);
        me.setRandom(this.random);
        me.setRandomGenerator(this.randomGenerator);
        me.setEnumerateHomology(this.enumHomology);
        me.setAlignScaffold(this.alignScaffold);
        me.setColoring(this.coloring);
        me.setEnumCodeNeeded(this.enumCodeNeeded);
        me.setLicenseEnvironment(this.licenseEnvironment);
    }

    public MarkushEnumeratorFactory() {
        this(6201);
    }

    public MarkushEnumeratorFactory(int features) {
        this.features = features;
        this.initPrototypes();
    }

    private void initPrototypes() {
        ArrayList<PrototypeHolder> list = new ArrayList<PrototypeHolder>();
        for (int i = 0; i < FEATURES.length; ++i) {
            if (!this.isEnumeratedFeature(FEATURES[i])) continue;
            list.add(new PrototypeHolder(FEATURES[i]));
        }
        this.enumeratorPrototypes = new PrototypeHolder[list.size()];
        list.toArray(this.enumeratorPrototypes);
    }

    private synchronized void clearPrototypes() {
        for (PrototypeHolder holder : this.enumeratorPrototypes) {
            holder.ep = null;
        }
    }

    public void setRandomSeed(long seed) {
        this.randomGenerator.setRandomSeed(seed);
    }

    public int getFeatures() {
        return this.features;
    }

    public void setKeepSelectionMarkers(boolean keepSelectionMarkers) {
        this.keepSelectionMarkers = keepSelectionMarkers;
    }

    public void setFilter(MolFilter filter) {
        this.filter = filter;
        this.clearPrototypes();
    }

    public MolFilter getFilter() {
        return this.filter;
    }

    public void setRandom(boolean random) {
        this.random = random;
        this.clearPrototypes();
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setEnumerateHomology(boolean enumerate) {
        this.enumHomology = enumerate;
        this.clearPrototypes();
    }

    public boolean isHomologyEnumerated() {
        return this.enumHomology;
    }

    public void setAlignScaffold(boolean alignScaffold) {
        this.alignScaffold = alignScaffold;
        this.clearPrototypes();
    }

    public boolean getAlignScaffold() {
        return this.alignScaffold;
    }

    public void setColoring(int coloring) {
        this.coloring = coloring;
        this.clearPrototypes();
    }

    public int getColoring() {
        return this.coloring;
    }

    public void setEnumCodeNeeded(boolean enumCodeNeeded) {
        this.enumCodeNeeded = enumCodeNeeded;
        this.clearPrototypes();
    }

    public boolean getEnumCodeNeeded() {
        return this.enumCodeNeeded;
    }

    public void setStructureID(String id) {
        this.structureID = id;
    }

    public String getStructureID() {
        return this.structureID;
    }

    public void setScaffoldColoring(boolean value) {
        this.coloring = value ? (this.coloring |= 1) : (this.coloring &= 0xFFFFFFFE);
    }

    public boolean isScaffoldColoring() {
        return (this.coloring & 1) == 1;
    }

    public void setRgroupColoring(boolean value) {
        this.coloring = value ? (this.coloring |= 2) : (this.coloring &= 0xFFFFFFFD);
    }

    public boolean isRgroupColoring() {
        return (this.coloring & 2) == 2;
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
        this.clearPrototypes();
    }

    public boolean isLicensed() {
        return true;
    }

    public MolEnumerator createEnumerator(Molecule mol) {
        return this.createEnumerator(mol, null);
    }

    public MolEnumerator createEnumerator(Molecule mol, int[] indexes) {
        if (indexes != null) {
            mol = mol.cloneMolecule();
            SelectionUtil.select(mol, indexes);
        }
        MarkushEnumerator enumerator = new MarkushEnumerator();
        this.setParams(enumerator);
        ((MolEnumerator)enumerator).setMol(mol);
        return enumerator;
    }

    public MolEnumerator getFirstEnumeratorClone(Molecule molP) {
        return this.getFirstEnumeratorClone(molP, this.features, "");
    }

    public MolEnumerator getFirstEnumeratorClone(Molecule molP, RgMolecule rgmol) {
        return this.getFirstEnumeratorClone(molP, rgmol, this.features, "");
    }

    public MolEnumerator getFirstEnumeratorClone(Molecule molP, int f, String licenseEnvironment) {
        RgMolecule rgmol = molP instanceof RgMolecule ? (RgMolecule)molP : null;
        return this.getFirstEnumeratorClone(molP, rgmol, f, licenseEnvironment);
    }

    public synchronized MolEnumerator getFirstEnumeratorClone(Molecule molP, RgMolecule rgmol, int f, String licenseEnvironment) {
        for (int i = 0; i < this.enumeratorPrototypes.length; ++i) {
            EnumeratorPrototype prototype;
            MolEnumerator enumerator;
            if (!MarkushEnumeratorFactory.isEnumeratedFeature(this.enumeratorPrototypes[i].code, f) || (enumerator = (prototype = this.enumeratorPrototypes[i].get()).createEnumerator(molP, rgmol)) == null) continue;
            enumerator.setLicenseEnvironment(licenseEnvironment);
            return enumerator;
        }
        return null;
    }

    public boolean isEnumeratedFeature(int code) {
        return MarkushEnumeratorFactory.isEnumeratedFeature(code, this.features);
    }

    public static boolean isEnumeratedFeature(int code, int f) {
        return (code & f) != 0;
    }

    class PrototypeHolder {
        private EnumeratorPrototype ep = null;
        int code;

        PrototypeHolder(int codeP) {
            this.code = codeP;
        }

        EnumeratorPrototype get() {
            if (this.ep == null) {
                this.ep = this.create();
            }
            return this.ep;
        }

        private EnumeratorPrototype create() {
            if (this.code == 4097) {
                return new RepetitionEnumeratorPrototype();
            }
            MolEnumerator me = this.newInstance(this.code);
            return new EnumeratorPrototype(me);
        }

        private MolEnumerator newInstance(int code) {
            switch (code) {
                case 1: {
                    return new LinkAtomEnumerator();
                }
                case 4096: {
                    return new RepeatingUnitEnumerator();
                }
                case 8: {
                    return new RgroupEnumerator();
                }
                case 16: {
                    return new AtomListEnumerator();
                }
                case 32: {
                    return new BondListEnumerator();
                }
                case 2048: {
                    return new MultiBondEnumerator();
                }
            }
            throw new UnsupportedOperationException("Unsupported enumerator code: " + code);
        }
    }

    class RepetitionEnumeratorPrototype
    extends EnumeratorPrototype {
        private LinkAtomEnumerator linkenum;

        RepetitionEnumeratorPrototype() {
            super(new RepeatingUnitEnumerator());
            this.linkenum = null;
            this.linkenum = new LinkAtomEnumerator();
            MarkushEnumeratorFactory.this.setParams(this.linkenum);
        }

        @Override
        protected MolEnumerator createEnumerator(Molecule molP, RgMolecule rgmol) {
            int[] dependencies = new int[molP.getAtomCount()];
            boolean repeatingUnitFound = RepeatingUnitEnumerator.getDependentAtomsFromRepeatingUnits(dependencies, molP);
            this.linkenum.setMol(molP, dependencies);
            if (this.linkenum.hasMoreElements0()) {
                return (MolEnumerator)this.linkenum.clone();
            }
            return repeatingUnitFound ? super.createEnumerator(molP, rgmol) : null;
        }
    }

    class EnumeratorPrototype {
        protected MolEnumerator enumerator = null;

        EnumeratorPrototype(MolEnumerator enumerator) {
            this.enumerator = enumerator;
            MarkushEnumeratorFactory.this.setParams(enumerator);
        }

        protected Class getEnumeratorClass() {
            return this.enumerator.getClass();
        }

        protected MolEnumerator createEnumerator(Molecule molP, RgMolecule rgmol) {
            this.enumerator.setMol(molP, rgmol);
            return this.enumerator.hasMoreElements0() ? (MolEnumerator)this.enumerator.clone() : null;
        }
    }
}

