/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.license.Licensable;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.RandomGenerator;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MolEnumerator
implements Enumeration<Molecule>,
Cloneable,
Licensable {
    protected static final Logger logger = Logger.getLogger(MolEnumerator.class.getName());
    protected Molecule scaffoldSkeleton = null;
    protected String licenseEnvironment = "";
    protected double[] randomPossibilities = null;
    protected double[][] rp = null;
    protected int nextLinkNode = 0;
    protected boolean random = false;
    protected boolean enumHomology = false;
    protected boolean alignScaffold = false;
    protected int coloring = 0;
    protected boolean enumCodeNeeded = false;
    protected RandomGenerator randomGenerator = null;
    protected boolean origNeeded = false;
    protected int numOfEnums = 1;
    protected int[] numOfEnumsFromBranch = null;
    protected int numOfGeneratedEnumerates = 0;

    protected void setFeatures(int features) {
    }

    protected void setRandomGenerator(RandomGenerator randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setEnumerateHomology(boolean enumerate) {
        this.enumHomology = enumerate;
    }

    public boolean isHomologyEnumerated() {
        return this.enumHomology;
    }

    protected void setAlignScaffold(boolean alignScaffold) {
        this.alignScaffold = alignScaffold;
    }

    protected boolean getAlignScaffold() {
        return this.alignScaffold;
    }

    protected void setColoring(int coloring) {
        this.coloring = coloring;
    }

    protected boolean isRgroupColoring() {
        return (this.coloring & 2) == 2;
    }

    protected boolean isScaffoldColoring() {
        return (this.coloring & 1) == 1;
    }

    protected void setEnumCodeNeeded(boolean enumCodeNeeded) {
        this.enumCodeNeeded = enumCodeNeeded;
    }

    protected boolean getEnumCodeNeeded() {
        return this.enumCodeNeeded;
    }

    public void setMol(Molecule molP, RgMolecule rgmol) {
        this.setMol(molP);
    }

    public abstract void setMol(Molecule var1);

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreElements0();
    }

    protected abstract boolean hasMoreElements0();

    @Override
    public Molecule nextElement() {
        return this.nextElement0();
    }

    protected abstract Molecule nextElement0();

    public Object clone() {
        MolEnumerator other = null;
        try {
            other = (MolEnumerator)super.clone();
            other.random = this.random;
            other.enumCodeNeeded = this.enumCodeNeeded;
            other.coloring = this.coloring;
            other.alignScaffold = this.alignScaffold;
            other.licenseEnvironment = this.licenseEnvironment;
            other.numOfEnums = this.numOfEnums;
            if (this.numOfEnumsFromBranch != null) {
                other.numOfEnumsFromBranch = new int[this.numOfEnumsFromBranch.length];
                for (int i = 0; i < this.numOfEnumsFromBranch.length; ++i) {
                    other.numOfEnumsFromBranch[i] = this.numOfEnumsFromBranch[i];
                }
            }
            other.numOfGeneratedEnumerates = this.numOfGeneratedEnumerates;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return other;
    }

    @Override
    public boolean isLicensed() {
        return true;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    protected int getEnumeratorLabel() {
        return -1;
    }

    public void setOrigNeeded(boolean b) {
        this.origNeeded = b;
    }

    public boolean isOrigNeeded() {
        return this.origNeeded;
    }

    void addMarkushCodeToMolecule(Molecule mol, String code) {
        String mID = mol.getProperty("Markush code");
        mID = mID != null ? mID + ", " + code : code;
        mol.setProperty("Markush code", mID);
    }

    public void setNumberOfRandomEnumeratesToGenerate(int n) {
        assert (this.random);
        assert (this.numOfEnums == 1);
        if (n < 1) {
            throw new IllegalArgumentException("The number of enumerates should be at least one");
        }
        this.numOfEnums = n;
    }

    protected int getNumberOfRandomEnumeratesToGenerate() {
        assert (this.random);
        return this.numOfEnums;
    }

    protected int getNumberOfEnumeratesGeneratedSoFar() {
        assert (this.random);
        return this.numOfGeneratedEnumerates;
    }

    protected int getRemainingEnumeratesOnTheBranches() {
        assert (this.random);
        for (int j = 0; j < this.getBranchIndex(); ++j) {
            assert (this.numOfEnumsFromBranch[j] == 0);
        }
        int sum = 0;
        for (int i : this.numOfEnumsFromBranch) {
            assert (i >= 0 && i <= this.numOfEnums);
            sum += i;
        }
        return sum;
    }

    protected int getBranchIndex() {
        assert (false);
        return -1;
    }

    protected int incrementAndGetBranchIndex() {
        assert (false);
        return -1;
    }

    protected int getBranchCount() {
        assert (false);
        return -1;
    }

    protected int getRandomBranchIndex() {
        assert (false);
        return -1;
    }

    protected int getNumOfEnumsFromBranch() {
        assert (this.random);
        return this.numOfEnumsFromBranch[this.getBranchIndex()];
    }

    protected void logState() {
        logger.fine(this.getClass().getSimpleName() + "\n" + Arrays.toString(this.numOfEnumsFromBranch));
    }

    protected void initNumOfEnumsFromBranch() {
        assert (this.random);
        assert (this.numOfEnumsFromBranch == null);
        this.numOfEnumsFromBranch = new int[this.getBranchCount()];
        for (int i = 0; i < this.numOfEnums; ++i) {
            int n = this.getRandomBranchIndex();
            this.numOfEnumsFromBranch[n] = this.numOfEnumsFromBranch[n] + 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            this.logState();
        }
    }

    protected int getIndexOfBranchToEnumerateFrom() {
        int branchIndex;
        assert (this.random);
        while (this.numOfEnumsFromBranch[this.getBranchIndex()] == 0) {
            this.incrementAndGetBranchIndex();
        }
        int n = branchIndex = this.getBranchIndex();
        this.numOfEnumsFromBranch[n] = this.numOfEnumsFromBranch[n] - 1;
        ++this.numOfGeneratedEnumerates;
        return branchIndex;
    }

    protected int switchToTheNextBranch() {
        assert (this.random);
        this.numOfGeneratedEnumerates += this.numOfEnumsFromBranch[this.getBranchIndex()];
        this.numOfEnumsFromBranch[this.getBranchIndex()] = 0;
        int retVal = 0;
        while (retVal == 0 && this.incrementAndGetBranchIndex() < this.getBranchCount()) {
            retVal = this.numOfEnumsFromBranch[this.getBranchIndex()];
        }
        return retVal;
    }
}

