/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.enumeration.SearchEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.sss.search.AtomRearranger;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.HashSet;

public class QueryEnumerator
extends QueryMolEnumerator {
    private static final int FEATURES = 1048;
    private static final long ENUM_MAX = 100L;
    private static final String SELECTION_STATE = "SELECTION_STATE";
    private int[] rollback = null;
    private long enumNo;
    private HashSet<Integer> rgroupsFound;
    private HashSet<Integer> rgroupsNoEnumerate;
    private SearchEnumerator searchEnumerator = null;

    private static void setSelectionState(MolAtom atom, SelectionState state) {
        atom.putProperty(SELECTION_STATE, (Object)state);
        SelectionUtil.setSelected(atom, state == SelectionState.CHOOSE);
    }

    private static SelectionState getSelectionState(MolAtom atom) {
        return (SelectionState)((Object)atom.getProperty(SELECTION_STATE));
    }

    protected QueryEnumerator() {
    }

    protected QueryEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public Object clone() {
        return (QueryEnumerator)super.clone();
    }

    @Override
    public void setMol(Molecule molP) {
        this.searchEnumerator = new SearchEnumerator(1048, this.chooseToEnumerate(molP));
    }

    @Override
    public boolean hasMoreElements() {
        return this.searchEnumerator.hasMoreElements() && this.enumNo > 1L;
    }

    @Override
    public Molecule nextElement() {
        return this.searchEnumerator.nextElement();
    }

    private Molecule chooseToEnumerate(Molecule molP) {
        ExpansionCounter ec = new ExpansionCounter();
        ec.setLicenseEnvironment("FreeMarkushEnumerationForInternalUseLicenseEnvironment");
        ec.anyQueryBond = true;
        this.enumNo = 1L;
        Molecule qmol = molP.cloneMolecule();
        MolAtom[] atoms = qmol instanceof RgMolecule ? ((RgMolecule)qmol).getAtomArray() : qmol.getAtomArray();
        int c = atoms.length;
        this.rgroupsFound = new HashSet();
        this.rgroupsNoEnumerate = new HashSet();
        if (molP instanceof RgMolecule) {
            RgMolecule rgMol = (RgMolecule)molP;
            for (int atomIndex = rgMol.getAtomCount() - 1; atomIndex >= 0; --atomIndex) {
                MolAtom atom = rgMol.getAtom(atomIndex);
                if (atom.getAtno() != 134) continue;
                int groupIndex = rgMol.findRgroupIndex(atom.getRgroup());
                if (this.rgroupsFound.contains(groupIndex)) {
                    this.rgroupsNoEnumerate.add(groupIndex);
                    continue;
                }
                this.rgroupsFound.add(groupIndex);
            }
        }
        int found = 0;
        for (int i = 0; i < c; ++i) {
            if (this.isCandidate(molP, atoms[i])) {
                ++found;
                continue;
            }
            if (atoms[i].getAtno() == 131) {
                QueryEnumerator.setSelectionState(atoms[i], SelectionState.DONT_CHOOSE);
                continue;
            }
            QueryEnumerator.setSelectionState(atoms[i], SelectionState.NOT_SELECTED);
        }
        if (found > 0) {
            int i;
            AtomRearranger ar = new AtomRearranger(qmol);
            int[][] cand = new int[found][3];
            found = 0;
            for (i = 0; i < c; ++i) {
                if (!SelectionUtil.isSelected(atoms[i])) continue;
                cand[found][0] = i;
                if (atoms[i].getAtno() == 128) {
                    cand[found][1] = atoms[i].getList().length;
                    cand[found][2] = (int)((double)cand[found][1] * ar.getAtomTypeProb(128, atoms[i]) * 10000.0);
                } else if (atoms[i].getAtno() == 134) {
                    RgMolecule rgmol = (RgMolecule)qmol;
                    cand[found][1] = rgmol.getRgroupMemberCount(rgmol.findRgroupIndex(atoms[i].getRgroup()));
                    cand[found][2] = this.markushSearch ? 0 : (int)((double)cand[found][1] * ar.getAtomTypeProb(atoms[i].getAtno(), atoms[i]) * 10000.0);
                }
                ++found;
                QueryEnumerator.setSelectionState(atoms[i], SelectionState.NOT_SELECTED);
            }
            for (i = cand.length - 1; i >= 1; --i) {
                for (int j = 0; j < i; ++j) {
                    if (cand[j][2] <= cand[j + 1][2] && (cand[j][2] != cand[j + 1][2] || cand[j][1] <= cand[j + 1][1])) continue;
                    this.change(cand[j], cand[j + 1]);
                }
            }
            for (int index = 0; index < found && this.enumNo < 100L; ++index) {
                QueryEnumerator.setSelectionState(atoms[cand[index][0]], SelectionState.CHOOSE);
                this.markBondsImplicitly(atoms[cand[index][0]]);
                try {
                    this.enumNo = this.getEnumCount(qmol, ec);
                    if (this.enumNo > 100L) {
                        for (int i2 = 1; i2 <= this.rollback[0]; ++i2) {
                            QueryEnumerator.setSelectionState(qmol.getAtom(this.rollback[i2]), SelectionState.NOT_SELECTED);
                        }
                        this.enumNo = this.getEnumCount(qmol, ec);
                    }
                    if (this.enumNo <= 100L) continue;
                    QueryEnumerator.setSelectionState(atoms[cand[index][0]], SelectionState.DONT_CHOOSE);
                    this.enumNo = this.getEnumCount(qmol, ec);
                    continue;
                }
                catch (ExpansionCounter.ArithmeticOverflowException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ExpansionException e) {
                    e.printStackTrace();
                }
            }
        }
        MolBond[] bonds = qmol.getBondArray();
        int b = bonds.length;
        int[] ind_bonds = new int[b + 1];
        int[] len_bonds = new int[b + 1];
        for (int j = 0; j < b; ++j) {
            int count;
            if (this.markushSearch) {
                this.unmarkBond(bonds[j]);
                continue;
            }
            if (!this.isCandidate(bonds[j]) || (count = this.toCount(bonds[j].getType())) <= 1) continue;
            ind_bonds[0] = ind_bonds[0] + 1;
            ind_bonds[ind_bonds[0]] = j;
            len_bonds[ind_bonds[0]] = count;
        }
        for (int i = ind_bonds[0]; i >= 2; --i) {
            for (int j = 1; j < i; ++j) {
                if (len_bonds[j] <= len_bonds[j + 1]) continue;
                this.change(len_bonds, j);
                this.change(ind_bonds, j);
            }
        }
        for (int index = 1; index <= ind_bonds[0] && this.enumNo < 100L; ++index) {
            if (this.choosableBond(bonds[ind_bonds[index]]) && this.enumNo * (long)len_bonds[index] <= 100L) {
                this.markBond(bonds[ind_bonds[index]]);
            } else {
                this.unmarkBond(bonds[ind_bonds[index]]);
            }
            try {
                this.enumNo = this.getEnumCount(qmol, ec);
                continue;
            }
            catch (ExpansionCounter.ArithmeticOverflowException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExpansionException e) {
                e.printStackTrace();
            }
        }
        return qmol;
    }

    private long getEnumCount(Molecule qmol, ExpansionCounter ec) throws ExpansionException {
        ec.setMolecule(qmol);
        return ec.countExpansions();
    }

    private void change(int[] a, int[] b) {
        for (int i = 0; i < b.length; ++i) {
            int c = a[i];
            a[i] = b[i];
            b[i] = c;
        }
    }

    private void change(int[] a, int i) {
        int c = a[i];
        a[i] = a[i + 1];
        a[i + 1] = c;
    }

    private void markBondsImplicitly(MolAtom ma) {
        int l = ma.getBondCount();
        this.rollback = new int[l + 1];
        for (int i = l - 1; i >= 0; --i) {
            MolAtom neigh;
            if (!ma.getBond(i).isQuery() || (neigh = ma.getBond(i).getOtherAtom(ma)).getAtno() > 109 || QueryEnumerator.getSelectionState(neigh) != SelectionState.NOT_SELECTED) continue;
            QueryEnumerator.setSelectionState(neigh, SelectionState.CHOOSE);
            this.rollback[0] = this.rollback[0] + 1;
            this.rollback[this.rollback[0]] = neigh.getParent().indexOf(neigh);
        }
    }

    private boolean isCandidate(Molecule mol, MolAtom atom) {
        int atNo = atom.getAtno();
        if (atNo == 128) {
            int[] list = atom.getList();
            for (int j = list.length - 1; j >= 0; --j) {
                if (list[j] != 6 && list[j] != 1) continue;
                QueryEnumerator.setSelectionState(atom, SelectionState.DONT_CHOOSE);
                return false;
            }
            return true;
        }
        if (atNo == 134 && mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            int groupIndex = rgmol.findRgroupIndex(atom.getRgroup());
            if (this.rgroupsNoEnumerate.contains(groupIndex)) {
                return false;
            }
            int memberCount = rgmol.getRgroupMemberCount(groupIndex);
            if (!">0".equals(rgmol.getRlogicRange(groupIndex))) {
                return false;
            }
            if (rgmol.getRlogic(groupIndex) != rgmol.getRgroupId(groupIndex)) {
                return false;
            }
            if (!this.markushSearch) {
                for (int memberIndex = 0; memberIndex < memberCount; ++memberIndex) {
                    Molecule memberMol = rgmol.getRgroupMember(groupIndex, memberIndex);
                    if (memberMol.getAtomCount() - atom.getBondCount() < 1) {
                        return false;
                    }
                    int atomCount = memberMol.getAtomCount();
                    atNo = memberMol.getAtom(0).getAtno();
                    if (atomCount - atom.getBondCount() == 1 && (atNo > 109 || atNo == 1 || atNo == 6)) {
                        return false;
                    }
                    for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
                        if ((memberMol.getAtom(atomIndex).getAtno() <= 109 || memberMol.getAtom(atomIndex).getAttach() <= 0) && memberMol.getAtom(atomIndex).getAtno() != 134) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean isCandidate(MolBond bond) {
        if (bond.getType() == 0) {
            return false;
        }
        return this.choosableBond(bond) && bond.isQuery();
    }

    private boolean choosableBond(MolBond bond) {
        SelectionState state1 = QueryEnumerator.getSelectionState(bond.getAtom1());
        SelectionState state2 = QueryEnumerator.getSelectionState(bond.getAtom2());
        return state1 != SelectionState.DONT_CHOOSE && state2 != SelectionState.DONT_CHOOSE && (state1 != SelectionState.CHOOSE || state2 != SelectionState.CHOOSE);
    }

    private void markBond(MolBond b) {
        if (this.choosableBond(b)) {
            QueryEnumerator.setSelectionState(b.getAtom1(), SelectionState.CHOOSE);
            QueryEnumerator.setSelectionState(b.getAtom2(), SelectionState.CHOOSE);
        }
    }

    private void unmarkBond(MolBond b) {
        MolAtom a1 = b.getAtom1();
        if (QueryEnumerator.getSelectionState(a1) == SelectionState.NOT_SELECTED) {
            QueryEnumerator.setSelectionState(a1, SelectionState.DONT_CHOOSE);
        } else if (QueryEnumerator.getSelectionState(a1) == SelectionState.CHOOSE) {
            QueryEnumerator.setSelectionState(b.getAtom2(), SelectionState.DONT_CHOOSE);
        }
    }

    private int toCount(int bondType) {
        switch (bondType) {
            case 5: 
            case 6: 
            case 7: {
                return 2;
            }
            case 0: {
                return 5;
            }
        }
        return 1;
    }

    private static enum SelectionState {
        CHOOSE,
        NOT_SELECTED,
        DONT_CHOOSE;

    }
}

