/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.AmbiguousAromaticEnumerator;
import chemaxon.enumeration.QueryBondListEnumerator;
import chemaxon.enumeration.QueryCombinationEnumerator;
import chemaxon.enumeration.QueryEnumerator;
import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.enumeration.TautomerEnumerator;
import chemaxon.enumeration.VagueBondEnumerator;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class QueryEnumeratorFactory {
    private String licenseEnvironment = "";
    private int features = 0;
    private static final int[] FEATURES = new int[]{1024, 2, 4, 64, 512};
    private PrototypeHolder[] enumeratorPrototypes = null;

    private void setParams(QueryMolEnumerator me) {
        if (me instanceof QueryCombinationEnumerator) {
            QueryCombinationEnumerator ce = (QueryCombinationEnumerator)me;
            ce.setFactory(this);
        }
        me.setFeatures(this.features);
        me.setLicenseEnvironment(this.licenseEnvironment);
    }

    private static boolean canRepeat(int feature) {
        switch (feature) {
            case 2: 
            case 4: 
            case 64: 
            case 512: {
                return false;
            }
        }
        return true;
    }

    public QueryEnumeratorFactory(int features) {
        this.features = features;
        this.initPrototypes();
    }

    private void initPrototypes() {
        ArrayList<PrototypeHolder> list = new ArrayList<PrototypeHolder>();
        for (int i = 0; i < FEATURES.length; ++i) {
            if (!this.isEnumeratedFeature(FEATURES[i])) continue;
            list.add(new PrototypeHolder(FEATURES[i]));
        }
        this.enumeratorPrototypes = new PrototypeHolder[list.size()];
        list.toArray(this.enumeratorPrototypes);
    }

    private synchronized void clearPrototypes() {
        for (PrototypeHolder holder : this.enumeratorPrototypes) {
            holder.ep = null;
        }
    }

    public int getFeatures() {
        return this.features;
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
        this.clearPrototypes();
    }

    public boolean isLicensed() {
        return true;
    }

    public QueryMolEnumerator createEnumerator(Molecule mol) {
        QueryCombinationEnumerator enumerator = new QueryCombinationEnumerator();
        this.setParams(enumerator);
        ((QueryMolEnumerator)enumerator).setMol(mol);
        return enumerator;
    }

    public QueryMolEnumerator getFirstEnumeratorClone(Molecule molP) {
        return this.getFirstEnumeratorClone(molP, null, this.features, false, "");
    }

    public synchronized QueryMolEnumerator getFirstEnumeratorClone(Molecule molP, List<QueryMolEnumerator> usedEnums, int f, boolean markushSearch, String licenseEnvironment) {
        block0: for (int i = 0; i < this.enumeratorPrototypes.length; ++i) {
            QueryMolEnumerator enumerator;
            EnumeratorPrototype prototype;
            if (!QueryEnumeratorFactory.isEnumeratedFeature(this.enumeratorPrototypes[i].code, f)) continue;
            if (!QueryEnumeratorFactory.canRepeat(this.enumeratorPrototypes[i].code) && usedEnums != null) {
                for (int j = 0; j < usedEnums.size(); ++j) {
                    if (this.enumeratorPrototypes[i].get().getEnumeratorClass().equals(usedEnums.get(j).getClass())) continue block0;
                }
            }
            if ((prototype = this.enumeratorPrototypes[i].get()) instanceof SearchEnumeratorPrototype) {
                ((SearchEnumeratorPrototype)prototype).markushSearch = markushSearch;
            }
            if ((enumerator = prototype.createEnumerator(molP)) == null) continue;
            enumerator.setLicenseEnvironment(licenseEnvironment);
            enumerator.setMarkushSearch(markushSearch);
            return enumerator;
        }
        return null;
    }

    public boolean isEnumeratedFeature(int code) {
        return QueryEnumeratorFactory.isEnumeratedFeature(code, this.features);
    }

    public static boolean isEnumeratedFeature(int code, int f) {
        return (code & f) != 0;
    }

    class PrototypeHolder {
        private EnumeratorPrototype ep = null;
        int code;

        PrototypeHolder(int codeP) {
            this.code = codeP;
        }

        EnumeratorPrototype get() {
            if (this.ep == null) {
                this.ep = this.create();
            }
            return this.ep;
        }

        private EnumeratorPrototype create() {
            QueryMolEnumerator me = this.newInstance(this.code);
            me.setLicenseEnvironment(QueryEnumeratorFactory.this.licenseEnvironment);
            return QueryEnumeratorFactory.canRepeat(this.code) ? new EnumeratorPrototype(me) : new SearchEnumeratorPrototype(me);
        }

        private QueryMolEnumerator newInstance(int code) {
            switch (code) {
                case 2: {
                    return new TautomerEnumerator();
                }
                case 4: {
                    return new AmbiguousAromaticEnumerator();
                }
                case 1024: {
                    return new QueryBondListEnumerator();
                }
                case 64: {
                    return new VagueBondEnumerator();
                }
                case 512: {
                    return new QueryEnumerator();
                }
            }
            throw new UnsupportedOperationException("Unsupported enumerator code: " + code);
        }
    }

    class SearchEnumeratorPrototype
    extends EnumeratorPrototype {
        protected boolean markushSearch;

        SearchEnumeratorPrototype(QueryMolEnumerator enumerator) {
            super(enumerator);
            this.markushSearch = false;
        }

        @Override
        protected QueryMolEnumerator createEnumerator(Molecule molP) {
            this.enumerator.setMarkushSearch(this.markushSearch);
            this.enumerator.setMol(molP);
            if (this.enumerator.hasMoreElements()) {
                QueryMolEnumerator me = (QueryMolEnumerator)this.enumerator.clone();
                QueryEnumeratorFactory.this.setParams(me);
                me.setMol(molP);
                return me;
            }
            return null;
        }
    }

    class EnumeratorPrototype {
        protected QueryMolEnumerator enumerator = null;

        EnumeratorPrototype(QueryMolEnumerator enumerator) {
            this.enumerator = enumerator;
            QueryEnumeratorFactory.this.setParams(enumerator);
        }

        protected Class getEnumeratorClass() {
            return this.enumerator.getClass();
        }

        protected QueryMolEnumerator createEnumerator(Molecule molP) {
            this.enumerator.setMol(molP);
            return this.enumerator.hasMoreElements() ? (QueryMolEnumerator)this.enumerator.clone() : null;
        }
    }
}

