/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.AromUtil;
import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class RgroupEnumerator
extends MolEnumerator {
    private ExpansionCounter ec = new ExpansionCounter();
    private Molecule mol = null;
    private RgMolecule rgmol = null;
    private int rgroupNode = -1;
    private int rgroupIndex = -1;
    private int rgroupMemberIndex = -1;
    private int rgroupMemberCount = -1;
    private ArrayList helperAtomList = new ArrayList();
    private boolean fromHomology = false;
    public static final String REAGENT_RGROUP_LABEL = "reagent";

    private static int findRgroupNode(Molecule mol, RgMolecule rgmol) {
        if (rgmol == null) {
            return -1;
        }
        int count = mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            int rgroup;
            MolAtom ma = mol.getAtom(i);
            if (!SelectionUtil.isSelected(ma) || ma.getAtno() != 134 || rgmol.findRgroupIndex(rgroup = ma.getRgroup()) == -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setMol(Molecule molP) {
        this.setMol(molP, null);
    }

    @Override
    public void setMol(Molecule molP, RgMolecule rgmol) {
        this.rgmol = rgmol;
        if (rgmol != null) {
            this.mol = molP;
            this.init();
        } else {
            this.mol = null;
            this.rgroupNode = -1;
        }
    }

    @Override
    public Object clone() {
        RgroupEnumerator re = (RgroupEnumerator)super.clone();
        re.mol = this.mol;
        re.rgmol = this.rgmol;
        re.rgroupNode = this.rgroupNode;
        re.rgroupIndex = this.rgroupIndex;
        re.rgroupMemberIndex = this.rgroupMemberIndex;
        re.rgroupMemberCount = this.rgroupMemberCount;
        re.numOfEnums = this.numOfEnums;
        return re;
    }

    private void init() {
        this.rgroupNode = RgroupEnumerator.findRgroupNode(this.mol, this.rgmol);
        if (this.rgroupNode != -1) {
            this.fromHomology = HomologyConstants.isHomologyRAtom(this.mol.getAtom(this.rgroupNode));
            this.rgroupIndex = this.rgmol.findRgroupIndex(this.mol.getAtom(this.rgroupNode).getRgroup());
            this.rgroupMemberCount = this.rgmol.getRgroupMemberCount(this.rgroupIndex);
            this.rgroupMemberIndex = 0;
        }
    }

    @Override
    protected boolean hasMoreElements0() {
        boolean retVal;
        boolean bl = retVal = this.rgroupNode != -1 && this.rgroupMemberIndex < this.rgroupMemberCount;
        if (this.random && this.numOfEnums - this.numOfGeneratedEnumerates <= 0) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    protected Molecule nextElement0() {
        assert (this.random == this.random);
        if (this.hasMoreElements0()) {
            Molecule mol1 = this.generateOutMol(this.random);
            return mol1;
        }
        return null;
    }

    private void dbgBranchSwitching(String context) {
        System.out.print("Switching branch on RG in " + context + ", ");
        System.out.print(Arrays.toString(this.numOfEnumsFromBranch));
        System.out.println(" branch index: " + this.rgroupMemberIndex + " (" + this.numOfEnumsFromBranch.length + ")");
    }

    @Override
    protected int getBranchIndex() {
        return this.rgroupMemberIndex;
    }

    @Override
    protected int getBranchCount() {
        return this.rgroupMemberCount;
    }

    @Override
    protected int getRandomBranchIndex() {
        return this.randomGenerator.generate(this.randomPossibilities);
    }

    @Override
    protected int incrementAndGetBranchIndex() {
        return ++this.rgroupMemberIndex;
    }

    private Molecule generateOutMol(boolean random) throws IllegalArgumentException {
        Molecule outmol = ExpansionUtil.cloneMolecule(this.mol);
        if (this.isRgroupColoring()) {
            MDocument clonedoc = new MDocument(outmol);
            clonedoc.cloneSets(this.mol.getDocument());
        }
        MolAtom atom = outmol.getAtom(this.rgroupNode);
        boolean error = false;
        int select = 0;
        if (random) {
            if (this.randomPossibilities == null) {
                int i;
                this.ec.setEnumerateHomology(this.isHomologyEnumerated());
                Molecule m = ExpansionUtil.addRgroupDefs(this.mol.cloneMolecule(), this.rgmol);
                this.ec.setMolecule(m);
                this.randomPossibilities = new double[this.rgroupMemberCount];
                try {
                    BigInteger[] memberCounts = this.ec.countExpansionsInRgroupMemberNodesLarge(this.rgroupNode);
                    if (memberCounts == null) {
                        AromUtil.finishAromatize(m);
                    }
                    for (i = 0; i < this.rgroupMemberCount; ++i) {
                        this.randomPossibilities[i] = memberCounts[i].doubleValue();
                    }
                }
                catch (ExpansionException e) {
                    for (i = 0; i < this.rgroupMemberCount; ++i) {
                        this.randomPossibilities[i] = 1.0;
                    }
                }
            }
            if (this.numOfEnumsFromBranch == null) {
                this.initNumOfEnumsFromBranch();
            }
            select = this.getIndexOfBranchToEnumerateFrom();
        } else {
            select = this.rgroupMemberIndex++;
        }
        Molecule rgroupOrig = this.rgmol.getRgroupMember(this.rgroupIndex, select);
        Molecule rgroup = rgroupOrig.cloneMolecule();
        rgroup.setValenceCheckEnabled(false);
        AromUtil.aromatize(atom, rgroup);
        AromUtil.markushAromatize(atom, rgroup);
        if (this.isRgroupColoring()) {
            int i;
            int color = atom.getSetSeq();
            for (i = rgroup.getAtomCount() - 1; i >= 0; --i) {
                rgroup.getAtom(i).setSetSeq(color);
            }
            for (i = rgroup.getBondCount() - 1; i >= 0; --i) {
                rgroup.getBond(i).setSetSeq(color);
            }
            for (i = rgroup.getSgroupCount() - 1; i >= 0; --i) {
                Sgroup sg = rgroup.getSgroup(i);
                if (!(sg instanceof SuperatomSgroup)) continue;
                ((SuperatomSgroup)sg).getSuperAtom().setSetSeq(color);
            }
        }
        ExpansionUtil.insertRgroupMember(outmol, atom, rgroup, true);
        if (this.getEnumCodeNeeded()) {
            String rGroupMemberIdentifier = null;
            int sgCount = rgroupOrig.getSgroupCount();
            boolean foundReagentCode = false;
            if (sgCount > 0) {
                for (int i = 0; i < sgCount; ++i) {
                    Sgroup sg = rgroupOrig.getSgroup(i);
                    if (sg.getType() != 10 || !((DataSgroup)sg).getFieldName().equalsIgnoreCase(REAGENT_RGROUP_LABEL)) continue;
                    rGroupMemberIdentifier = ((DataSgroup)sg).getData();
                    foundReagentCode = true;
                    break;
                }
            }
            if (!foundReagentCode) {
                rGroupMemberIdentifier = "" + ((Integer)rgroupOrig.getAtom(0).getProperty("EnumIndex") + 1);
            }
            String mCode = "R" + this.mol.getAtom(this.rgroupNode).getRgroup() + "(" + ((Integer)this.mol.getAtom(this.rgroupNode).getProperty("EnumIndex") + 1) + ")" + ":" + rGroupMemberIdentifier;
            this.addMarkushCodeToMolecule(outmol, mCode);
        }
        return outmol;
    }

    @Override
    protected int getEnumeratorLabel() {
        return this.rgroupIndex;
    }
}

