/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class VagueBondEnumerator
extends QueryMolEnumerator {
    Molecule mol = null;
    Molecule outMol = null;
    boolean first = true;
    int mode = 320;
    private static final int MASK = 448;

    public VagueBondEnumerator() {
    }

    public VagueBondEnumerator(int modeP) {
        this.mode = modeP;
    }

    public VagueBondEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.mol = molP;
        this.init();
    }

    @Override
    public Object clone() {
        VagueBondEnumerator vbe = (VagueBondEnumerator)super.clone();
        vbe.mol = this.mol;
        vbe.mode = this.mode;
        vbe.init();
        return vbe;
    }

    private void init() {
        this.first = true;
        if (this.mol == null) {
            return;
        }
        this.outMol = (Molecule)this.mol.clone();
        BondClassifier bc = null;
        if (this.mode == 64) {
            bc = new BondClassifier();
            bc.classify(this.outMol);
        }
        if (this.mode == 64 || this.mode == 192) {
            this.outMol.aromatize(4);
        }
        block5: for (int i = 0; i < this.outMol.getBondCount(); ++i) {
            MolBond b = this.outMol.getBond(i);
            switch (this.mode) {
                case 64: {
                    int a2;
                    int a1;
                    if (b.getType() == 4 || !bc.isRingBond(a1 = this.outMol.indexOf(b.getAtom1()), a2 = this.outMol.indexOf(b.getAtom2()))) continue block5;
                    this.toOrAromatic(b);
                    continue block5;
                }
                case 192: {
                    if (b.getType() == 4) continue block5;
                    this.toOrAromatic(b);
                    continue block5;
                }
                case 320: {
                    this.toAny(b);
                    continue block5;
                }
            }
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.first;
    }

    @Override
    public Molecule nextElement() {
        Molecule next = this.hasMoreElements() ? this.outMol : null;
        this.first = false;
        return next;
    }

    private void toOrAromatic(MolBond b) {
        int flags = b.getFlags();
        int newType = this.addArom(flags & 0xF);
        int otherFlags = flags & 0xFFFFFFF0;
        b.setFlags(otherFlags | newType);
    }

    private void toAny(MolBond b) {
        int flags = b.getFlags();
        int newType = 0;
        int otherFlags = flags & 0xFFFFFFF0;
        b.setFlags(otherFlags | newType);
    }

    private int addArom(int bondType) {
        int newBt = bondType;
        switch (bondType) {
            case 1: {
                newBt = 6;
                break;
            }
            case 2: {
                newBt = 7;
                break;
            }
            case 3: {
                newBt = 0;
                break;
            }
            case 5: {
                newBt = 0;
                break;
            }
        }
        return newBt;
    }

    @Override
    protected void setFeatures(int f) {
        this.mode = f & 0x1C0;
    }
}

