/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.bracket;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;

public class MixtureUtil {
    private static final int[] mixForTypes = new int[]{9, 13, 8};

    private MixtureUtil() {
        throw new AssertionError((Object)"MixtureUtil is not allowed to be instantiated.");
    }

    public static boolean isMixForSgroup(Sgroup sg) {
        int type = sg.getType();
        return ArrayTools.foundInArray(mixForTypes, type);
    }

    public static int getComponentNum(Sgroup sg) {
        int compNum = -1;
        if (sg.getType() == 13 && sg.isOrderedComponentSgroup() && sg.getParentSgroup() != null && sg.getParentSgroup().getType() == 9) {
            String s = sg.getSubscript();
            String noString = s == null ? null : s.substring(1);
            try {
                compNum = Integer.parseInt(noString);
            }
            catch (NumberFormatException e) {
                compNum = -1;
            }
        } else {
            compNum = -1;
        }
        return compNum;
    }

    public static void getRelevantTypes(IntVector neededTypes) {
        if (neededTypes == null) {
            neededTypes = new IntVector();
        }
        for (int type : mixForTypes) {
            neededTypes.add(type);
        }
    }

    public static boolean hasComponentSgroup(Molecule q) {
        int nSg = q.getSgroupCount();
        for (int i = 0; i < nSg; ++i) {
            Sgroup sg = q.getSgroup(i);
            if (sg.getType() != 13) continue;
            return true;
        }
        return false;
    }
}

