/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.struc.MolAtom;
import chemaxon.util.IntRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HomologyProperties {
    private static Log log = LogFactory.getLog(HomologyProperties.class);
    private IntRange[] bondTypeRanges = null;
    private HashMap<Integer, IntRange> atomTypeRanges = null;
    private HashMap<Integer, AttachmentNumberType> atomTypeAttachment = null;
    private IntRange numberOfCarbonAtoms = null;
    private IntRange numberOfHeteroAtoms = null;
    private IntRange numberOfDeuteriums = null;
    private IntRange numberOfTritiums = null;
    private IntRange numberOfRings = null;
    private IntRange numberOfRingAtoms = null;
    private BranchingType branching = null;
    private SaturationType saturation = null;
    private RingTypeType fuseness = null;
    private boolean erroneousFormat = true;

    public HomologyProperties() {
        this.init();
    }

    private void init() {
        this.atomTypeRanges = new HashMap();
        this.atomTypeAttachment = new HashMap();
        this.bondTypeRanges = new IntRange[4];
    }

    public HomologyProperties(MolAtom atom) {
        this.init();
        this.readAtomProperties(atom);
    }

    public void readAtomProperties(MolAtom atom) {
        Set<String> keys = atom.propertyKeySet();
        for (String key : keys) {
            try {
                Object value = atom.getProperty(key);
                if (!(value instanceof String)) continue;
                if (key.equalsIgnoreCase("BRANCHING")) {
                    this.branching = BranchingType.fromString((String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("SATURATION")) {
                    this.saturation = SaturationType.fromString((String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("RINGTYPE")) {
                    this.fuseness = RingTypeType.fromString((String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("SIZE")) {
                    this.processSizeProperty((String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("DTCOUNT")) {
                    this.processDeuteriumTritium((String)value);
                    continue;
                }
                if (!key.equalsIgnoreCase("TEXTNOTES")) continue;
                this.processTextnote((String)value);
            }
            catch (IllegalArgumentException e) {
                log.trace((Object)e.getMessage());
                this.erroneousFormat = true;
            }
        }
    }

    private void processTextnote(String value) {
        String[] notes;
        int endIndex = value.contains("/") ? value.indexOf("/") : value.length();
        value = value.substring(0, endIndex);
        for (String note : notes = value.split(",")) {
            if (note.length() == 0) continue;
            if (note.length() < 2) {
                throw new IllegalArgumentException("Erroneous text note format: " + value);
            }
            try {
                switch (note.charAt(0)) {
                    case 'E': {
                        this.bondTypeRanges[2] = new IntRange(note.substring(1));
                        break;
                    }
                    case 'Y': {
                        this.bondTypeRanges[3] = new IntRange(note.substring(1));
                        break;
                    }
                    case 'C': {
                        if (this.numberOfCarbonAtoms == null) {
                            this.numberOfCarbonAtoms = new IntRange(note.substring(1));
                            break;
                        }
                        this.numberOfCarbonAtoms.intersectionWith(new IntRange(note.substring(1)));
                        break;
                    }
                    case 'X': {
                        this.numberOfHeteroAtoms = new IntRange(note.substring(1));
                        break;
                    }
                    case '>': {
                        this.processAttachment(note);
                        break;
                    }
                    case 'R': {
                        if (note.charAt(1) == 'A') {
                            this.numberOfRingAtoms = new IntRange(note.substring(2));
                            break;
                        }
                    }
                    case 'N': {
                        if (note.charAt(1) == 'R') {
                            this.numberOfRings = new IntRange(note.substring(2));
                            break;
                        }
                    }
                    default: {
                        this.processAtomRange(note);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Erroneous text note format: " + value);
            }
        }
    }

    private void processAtomRange(String value) {
        int symbolEndIndex = 1;
        int atNo = MolAtom.numOf(value.substring(0, 2));
        if (atNo == 0) {
            --symbolEndIndex;
            atNo = MolAtom.numOf(value.substring(0, 1));
        }
        if (atNo == 0) {
            throw new IllegalArgumentException("Erroneous text note format: " + value);
        }
        this.atomTypeRanges.put(atNo, new IntRange(value.substring(symbolEndIndex + 1)));
    }

    private void processAttachment(String value) {
        if (value.startsWith(">>")) {
            this.atomTypeAttachment.put(MolAtom.numOf(value.substring(2)), AttachmentNumberType.MORE);
        } else if (value.startsWith(">")) {
            this.atomTypeAttachment.put(MolAtom.numOf(value.substring(1)), AttachmentNumberType.ONE);
        }
    }

    private void processDeuteriumTritium(String value) {
        value = value.toLowerCase();
        int dIndex = value.indexOf(100);
        int tIndex = value.indexOf(116);
        try {
            if (dIndex > -1) {
                if (tIndex < dIndex) {
                    this.numberOfDeuteriums = new IntRange(value.substring(dIndex + 1));
                } else {
                    if (tIndex == dIndex + 1) {
                        this.numberOfDeuteriums = new IntRange(value.substring(dIndex + 2));
                        this.numberOfTritiums = new IntRange(value.substring(dIndex + 2));
                        return;
                    }
                    this.numberOfDeuteriums = new IntRange(value.substring(dIndex + 1, tIndex));
                }
            }
            if (tIndex > -1) {
                this.numberOfTritiums = dIndex < tIndex ? new IntRange(value.substring(tIndex + 1)) : (dIndex == tIndex + 1 ? new IntRange(value.substring(tIndex + 2)) : new IntRange(value.substring(tIndex + 1, dIndex)));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Erroneous deuterium count format: " + value, e);
        }
    }

    private void processSizeProperty(String value) {
        SizeType[] types = SizeType.fromConcatenatedString(value);
        if (types.length == 0) {
            return;
        }
        IntRange range = types[0].getRange();
        for (int i = 1; i < types.length; ++i) {
            range.unionWith(types[i].getRange());
        }
        if (this.numberOfCarbonAtoms == null) {
            this.numberOfCarbonAtoms = range;
        } else {
            this.numberOfCarbonAtoms.intersectionWith(range);
        }
    }

    public final IntRange getBondTypeRange(int bondType) {
        if (bondType > 3 || bondType < 1) {
            return null;
        }
        return this.bondTypeRanges[bondType];
    }

    public final Set<Integer> getAtomTypesWithConstraint() {
        return this.atomTypeRanges.keySet();
    }

    public final IntRange getAtomTypeConstraint(Integer atomType) {
        return this.atomTypeRanges.get(atomType);
    }

    public final Set<Integer> getAtomTypesWithAttachment() {
        return this.atomTypeAttachment.keySet();
    }

    public final AttachmentNumberType getAtomTypeAttachment(Integer atomType) {
        return this.atomTypeAttachment.get(atomType);
    }

    public final IntRange getNumberOfHeteroAtoms() {
        return this.numberOfHeteroAtoms;
    }

    public final IntRange getNumberOfCarbonAtoms() {
        return this.numberOfCarbonAtoms;
    }

    public final IntRange getNumberOfDeuteriums() {
        return this.numberOfDeuteriums;
    }

    public final IntRange getNumberOfTritiums() {
        return this.numberOfTritiums;
    }

    public final IntRange getNumberOfRings() {
        return this.numberOfRings;
    }

    public final IntRange getNumberOfRingAtoms() {
        return this.numberOfRingAtoms;
    }

    public final BranchingType getBranching() {
        return this.branching;
    }

    public final SaturationType getSaturation() {
        return this.saturation;
    }

    public final RingTypeType getFuseness() {
        return this.fuseness;
    }

    public boolean hasPropertyErrorWithoutException() {
        return this.erroneousFormat;
    }

    public static enum AttachmentNumberType {
        ONE(">", new IntRange("1-")),
        MORE(">>", new IntRange("2-"));

        final String stringRepresentation;
        IntRange range;

        private AttachmentNumberType(String repr, IntRange rangeInp) {
            this.stringRepresentation = repr;
            this.range = rangeInp;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public IntRange getRange() {
            return this.range;
        }
    }

    public static enum SizeType {
        LOW("LO", new IntRange("1-6")),
        MIDDLE("MID", new IntRange("7-10")),
        HIGH("HI", new IntRange("11-"));

        private final String stringRepresentation;
        private final IntRange range;

        private SizeType(String repr, IntRange rangeInp) {
            this.stringRepresentation = repr;
            this.range = rangeInp;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        private IntRange getRange() {
            return new IntRange(this.range.toString());
        }

        public static SizeType fromString(String value) {
            for (SizeType t : SizeType.values()) {
                if (!t.stringRepresentation.equalsIgnoreCase(value)) continue;
                return t;
            }
            return null;
        }

        public static String toConcatenatedString(boolean low, boolean mid, boolean hi) {
            int numOfOnes = (low ? 1 : 0) + (mid ? 1 : 0) + (hi ? 1 : 0);
            if (numOfOnes == 3 || numOfOnes == 0) {
                return null;
            }
            int remainingOnes = numOfOnes;
            StringBuffer sb = new StringBuffer();
            boolean[] values = new boolean[]{low, mid, hi};
            for (int i = 0; i < values.length; ++i) {
                if (!values[i]) continue;
                sb.append(SizeType.values()[i].toString());
                if (--remainingOnes <= 0) continue;
                sb.append(" ");
            }
            return sb.toString();
        }

        public static SizeType[] fromConcatenatedString(String str) {
            String[] elements = str.split(" ");
            ArrayList<SizeType> list = new ArrayList<SizeType>();
            for (String s : elements) {
                SizeType t = SizeType.fromString(s);
                if (t == null) continue;
                list.add(t);
            }
            return list.toArray(new SizeType[0]);
        }
    }

    public static enum RingTypeType {
        FUSED("FU"),
        MONOCYCLIC("MON");

        private final String stringRepresentation;

        private RingTypeType(String repr) {
            this.stringRepresentation = repr;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public static RingTypeType fromString(String value) {
            if (value.equalsIgnoreCase(RingTypeType.FUSED.stringRepresentation)) {
                return FUSED;
            }
            if (value.equalsIgnoreCase(RingTypeType.MONOCYCLIC.stringRepresentation)) {
                return MONOCYCLIC;
            }
            return null;
        }
    }

    public static enum SaturationType {
        SATURATED("SAT"),
        UNSATURATED("UNS");

        private final String stringRepresentation;

        private SaturationType(String repr) {
            this.stringRepresentation = repr;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public static SaturationType fromString(String value) {
            if (value.equalsIgnoreCase(SaturationType.SATURATED.stringRepresentation)) {
                return SATURATED;
            }
            if (value.equalsIgnoreCase(SaturationType.UNSATURATED.stringRepresentation)) {
                return UNSATURATED;
            }
            return null;
        }
    }

    public static enum BranchingType {
        STRAIGHT("STR"),
        BRANCHED("BRA");

        private final String stringRepresentation;

        private BranchingType(String repr) {
            this.stringRepresentation = repr;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public static BranchingType fromString(String value) {
            if (value.equalsIgnoreCase(BranchingType.STRAIGHT.stringRepresentation)) {
                return STRAIGHT;
            }
            if (value.equalsIgnoreCase(BranchingType.BRANCHED.stringRepresentation)) {
                return BRANCHED;
            }
            return null;
        }
    }
}

