/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyProperties;
import chemaxon.enumeration.homology.HomologyPropertyRingClassifier;
import chemaxon.enumeration.homology.HomologyPropertyStructureClassifier;
import chemaxon.enumeration.homology.HomologyPropertyTypes;
import chemaxon.struc.MolAtom;
import chemaxon.util.IntRange;
import java.util.Set;

public class HomologyPropertyChecker {
    public static boolean isRingPropOK(HomologyProperties homologyProperties, HomologyPropertyRingClassifier homologyRingClassifier, int ringIndex) {
        if (homologyProperties.getFuseness() == HomologyProperties.RingTypeType.FUSED && !homologyRingClassifier.getFused(ringIndex)) {
            return false;
        }
        if (homologyProperties.getFuseness() == HomologyProperties.RingTypeType.MONOCYCLIC && homologyRingClassifier.getFused(ringIndex)) {
            return false;
        }
        if (homologyProperties.getSaturation() == HomologyProperties.SaturationType.SATURATED && homologyRingClassifier.getUnsaturated(ringIndex)) {
            return false;
        }
        if (homologyProperties.getSaturation() == HomologyProperties.SaturationType.UNSATURATED && homologyRingClassifier.getSaturated(ringIndex)) {
            return false;
        }
        if (homologyProperties.getNumberOfRingAtoms() != null && !homologyProperties.getNumberOfRingAtoms().contains(homologyRingClassifier.getNumberOfRingAtoms(ringIndex))) {
            return false;
        }
        return homologyProperties.getNumberOfRings() == null || homologyProperties.getNumberOfRings().contains(homologyRingClassifier.getNumberOfRings(ringIndex));
    }

    public static boolean isSizeOK(HomologyProperties homologyProperties, HomologyPropertyStructureClassifier structureClassifier, int critInd) {
        int carbonCount = structureClassifier.getQuantityOfAtomType(critInd, 6);
        if (homologyProperties.getNumberOfCarbonAtoms() == null) {
            return true;
        }
        return homologyProperties.getNumberOfCarbonAtoms().contains(carbonCount);
    }

    public static boolean isBranchingOK(HomologyProperties homologyProperties, HomologyPropertyStructureClassifier structureClassifier, int critInd) {
        if (homologyProperties.getBranching() == null) {
            return true;
        }
        int[] matchables = structureClassifier.getMatchableAtoms(critInd);
        boolean branchedFound = false;
        for (int m : matchables) {
            int neighNum = structureClassifier.getHgMappableNeighbours(m).length;
            if (neighNum <= 2) continue;
            if (homologyProperties.getBranching() == HomologyProperties.BranchingType.STRAIGHT) {
                return false;
            }
            branchedFound = true;
        }
        return homologyProperties.getBranching() != HomologyProperties.BranchingType.BRANCHED || branchedFound;
    }

    public static boolean isDTCountOK(HomologyProperties homologyProperties, HomologyPropertyStructureClassifier structureClassifier, int critInd, boolean canReduce) {
        IntRange dRange = homologyProperties.getNumberOfDeuteriums();
        IntRange tRange = homologyProperties.getNumberOfTritiums();
        if (dRange == null && tRange == null) {
            return true;
        }
        int[] matchables = structureClassifier.getMatchableAtoms(critInd);
        int numOfH = structureClassifier.getQuantityOfAtomType(critInd, 1);
        if (dRange != null && dRange.min() > numOfH) {
            return false;
        }
        if (tRange != null && tRange.min() > numOfH) {
            return false;
        }
        int dCount = 0;
        int tCount = 0;
        for (int m : matchables) {
            int[] neigh;
            for (int n : neigh = structureClassifier.getNeighbours(m)) {
                if (structureClassifier.getAtNoOfAtom(n) != 1) continue;
                if (structureClassifier.getIsotopeOfAtom(n) == 2) {
                    ++dCount;
                }
                if (structureClassifier.getIsotopeOfAtom(n) != 3) continue;
                ++tCount;
            }
        }
        if (!canReduce) {
            if (dRange != null && !dRange.contains(dCount)) {
                return false;
            }
            if (tRange != null && !tRange.contains(tCount)) {
                return false;
            }
        } else {
            if (dRange != null && dRange.min() > dCount) {
                return false;
            }
            if (tRange != null && tRange.min() > tCount) {
                return false;
            }
        }
        return true;
    }

    public static boolean isTextNoteOK(HomologyProperties homologyProperties, HomologyPropertyStructureClassifier structureClassifier, int strIndex) {
        if (!HomologyPropertyChecker.checkAtomNumbers(homologyProperties, structureClassifier, strIndex)) {
            return false;
        }
        if (!HomologyPropertyChecker.checkBondNumbers(homologyProperties, structureClassifier, strIndex)) {
            return false;
        }
        return HomologyPropertyChecker.checkAttachments(homologyProperties, structureClassifier, strIndex, false);
    }

    private static boolean checkAttachments(HomologyProperties homologyProperties, HomologyPropertyStructureClassifier structureClassifier, int strIndex, boolean onSingleAtom) {
        if (homologyProperties.getAtomTypesWithAttachment().size() == 0) {
            return true;
        }
        int[] attachAtoms = structureClassifier.getAttachAtoms(strIndex);
        int[] attachNumForAtoms = new int[109];
        if (!onSingleAtom) {
            for (int a : attachAtoms) {
                int n = structureClassifier.getAtNoOfAtom(a);
                attachNumForAtoms[n] = attachNumForAtoms[n] + 1;
            }
        } else {
            IntVector atomIndex = new IntVector();
            IntVector attachNum = new IntVector();
            for (int a : attachAtoms) {
                if (!atomIndex.contains(a)) {
                    atomIndex.add(1);
                    continue;
                }
                int position = atomIndex.indexOf(a);
                atomIndex.set(position, atomIndex.get(position) + 1);
            }
            int n = atomIndex.size();
            for (int i = 0; i < n; ++i) {
                int atNo = structureClassifier.getAtNoOfAtom(atomIndex.get(i));
                if (attachNumForAtoms[atNo] >= attachNum.get(i)) continue;
                attachNumForAtoms[atNo] = attachNum.get(i);
            }
        }
        Set<Integer> typesToCheck = homologyProperties.getAtomTypesWithAttachment();
        for (int t : typesToCheck) {
            IntRange desiredRange = homologyProperties.getAtomTypeAttachment(t).getRange();
            if (desiredRange.contains(attachNumForAtoms[t])) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBondNumbers(HomologyProperties homologyProperties, HomologyPropertyStructureClassifier structureClassifier, int strIndex) {
        IntRange doubleBondRange = homologyProperties.getBondTypeRange(2);
        IntRange tripleBondRange = homologyProperties.getBondTypeRange(3);
        if (doubleBondRange != null && !doubleBondRange.contains(structureClassifier.getQuantityOfBonds(strIndex, 2))) {
            return false;
        }
        return tripleBondRange == null || tripleBondRange.contains(structureClassifier.getQuantityOfBonds(strIndex, 3));
    }

    private static boolean checkAtomNumbers(HomologyProperties homologyProperties, HomologyPropertyStructureClassifier structureClassifier, int strIndex) {
        Set<Integer> types = homologyProperties.getAtomTypesWithConstraint();
        for (Integer t : types) {
            if (homologyProperties.getAtomTypeConstraint(t).contains(structureClassifier.getQuantityOfAtomType(strIndex, t))) continue;
            return false;
        }
        if (homologyProperties.getNumberOfCarbonAtoms() != null && !homologyProperties.getNumberOfCarbonAtoms().contains(structureClassifier.getQuantityOfAtomType(strIndex, 6))) {
            return false;
        }
        if (homologyProperties.getNumberOfHeteroAtoms() != null) {
            int heteroNum = 0;
            for (int i = 2; i < 109; ++i) {
                if (i == 6 || types.contains(i)) continue;
                heteroNum += structureClassifier.getQuantityOfAtomType(strIndex, i);
            }
            if (!homologyProperties.getNumberOfHeteroAtoms().contains(heteroNum)) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasRingnumberError(IntRange numberOfRingAtoms, MolAtom hgAtom) {
        if (numberOfRingAtoms != null) {
            if (numberOfRingAtoms.min() > 0) {
                return !HomologyConstants.isCyclicHomology(hgAtom.getAliasstr());
            }
            if (numberOfRingAtoms.max() == 0) {
                return HomologyConstants.isCyclicHomology(hgAtom.getAliasstr());
            }
        }
        return false;
    }

    public static boolean hasNonApplicableProperties(HomologyProperties homologyProperties, MolAtom hgAtom) {
        if (homologyProperties.getBranching() != null && !HomologyPropertyTypes.Branching.isApplicableOnAtom(hgAtom)) {
            return true;
        }
        if (homologyProperties.getFuseness() != null && !HomologyPropertyTypes.RingType.isApplicableOnAtom(hgAtom)) {
            return true;
        }
        if (homologyProperties.getSaturation() != null && !HomologyPropertyTypes.Saturation.isApplicableOnAtom(hgAtom)) {
            return true;
        }
        IntRange ringRange = homologyProperties.getNumberOfRingAtoms();
        if (HomologyPropertyChecker.hasRingnumberError(ringRange, hgAtom)) {
            return true;
        }
        ringRange = homologyProperties.getNumberOfRings();
        return HomologyPropertyChecker.hasRingnumberError(ringRange, hgAtom);
    }
}

