/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.SSSR;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.homology.HomologyPropertyRingClassifier;
import chemaxon.enumeration.homology.HomologyPropertyStructureClassifier;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomologyRingClassifier
implements HomologyPropertyRingClassifier,
HomologyPropertyStructureClassifier {
    private int[] ringIndex;
    private int[][] rings = null;
    private int[] ringTypes;
    private static final int MONOCYC_OFF = 0;
    private static final int FUSED_OFF = 1;
    private static final int ALIPH_OFF = 2;
    private static final int AROM_OFF = 3;
    private static final int CARBO_OFF = 4;
    private static final int HETERO_OFF = 5;
    private static final int SAT_OFF = 6;
    private static final int UNSAT_OFF = 7;
    private static final int HETAROM_OFF = 8;
    private int[][] ringAtomType = null;
    private static final int DEFAULT_RING_TYPE = 85;
    private int[][] sssr = null;
    private int[][] sssrBonds = null;
    private int[][] sysSssrInd;
    private static final Logger logger = Logger.getLogger(HomologyRingClassifier.class.getName());
    public static final int CONNECTION_FUSED = 2;
    int ringNum = 0;
    Molecule mol = null;

    public HomologyRingClassifier() {
    }

    public HomologyRingClassifier(Molecule m) {
        this.setMolecule(m);
    }

    public void setMolecule(Molecule m) {
        this.mol = m;
        this.rings = null;
        this.ringTypes = null;
        this.ringNum = 0;
        this.ringIndex = ArrayTools.initArrayAndFill(this.ringIndex, this.mol.getAtomCount(), -1);
        this.sysSssrInd = null;
    }

    private void findFusedRings() {
        if (this.rings != null) {
            return;
        }
        if (this.mol == null) {
            return;
        }
        this.getSssr();
        int[][] sssrConnections = this.getRingConnections();
        this.ringNum = 0;
        this.sysSssrInd = this.getSystemsOfSSSR(sssrConnections);
        this.rings = new int[this.ringNum][];
        this.ringTypes = new int[this.ringNum];
        this.ringTypes = ArrayTools.initArrayAndFill(this.ringTypes, this.ringNum, 85);
        for (int[] row : this.ringAtomType = new int[this.ringNum][110]) {
            Arrays.fill(row, 0);
        }
        this.ringIndex = ArrayTools.initArrayAndFill(this.ringIndex, this.mol.getAtomCount(), -1);
        boolean[] isInThisSys = null;
        for (int r = 0; r < this.ringNum; ++r) {
            IntVector ringAtoms = new IntVector();
            this.setFused(r, this.sysSssrInd[r].length > 1);
            isInThisSys = ArrayTools.initBooleanArrayAndFill(isInThisSys, this.mol.getAtomCount(), false);
            for (int subR = 0; subR < this.sysSssrInd[r].length; ++subR) {
                int sssrInd = this.sysSssrInd[r][subR];
                for (int a = 0; a < this.sssr[sssrInd].length; ++a) {
                    int atomInd = this.sssr[sssrInd][a];
                    if (isInThisSys[atomInd]) continue;
                    ringAtoms.add(atomInd);
                    this.ringIndex[atomInd] = r;
                    isInThisSys[atomInd] = true;
                }
            }
            this.rings[r] = ringAtoms.toArray();
            this.specifyRingType(r);
        }
    }

    private void specifyRingType(int sysInd) {
        for (int i = 0; i < this.rings[sysInd].length; ++i) {
            MolAtom atom = this.mol.getAtom(this.rings[sysInd][i]);
            switch (this.getHeteroType(atom)) {
                case 1: {
                    this.setHetero(sysInd, true, false);
                    break;
                }
                case 2: {
                    this.setHetero(sysInd, true, true);
                }
            }
            if (atom.getAtno() >= 109) continue;
            int[] nArray = this.ringAtomType[sysInd];
            int n = atom.getAtno();
            nArray[n] = nArray[n] + 1;
        }
        for (int sssrInd : this.sysSssrInd[sysInd]) {
            block15: for (int i = 0; i < this.sssrBonds[sssrInd].length; ++i) {
                MolBond bond = this.mol.getBond(this.sssrBonds[sssrInd][i]);
                int bondTyp = bond.getType();
                MolAtom atom1 = bond.getAtom1();
                MolAtom atom2 = bond.getAtom2();
                boolean possiblyHetero = false;
                if (this.getHeteroType(atom1) != 0 || this.getHeteroType(atom2) != 0) {
                    possiblyHetero = true;
                }
                switch (bondTyp) {
                    case 1: {
                        continue block15;
                    }
                    case 4: {
                        this.setAromatic(sysInd, true, false, possiblyHetero);
                    }
                    case 2: 
                    case 3: {
                        this.setUnSaturated(sysInd, true, false);
                        continue block15;
                    }
                    case 5: {
                        this.setUnSaturated(sysInd, true, true);
                        continue block15;
                    }
                    case 6: {
                        this.setAromatic(sysInd, true, true, possiblyHetero);
                        continue block15;
                    }
                    case 7: {
                        this.setAromatic(sysInd, true, true, possiblyHetero);
                        this.setUnSaturated(sysInd, true, false);
                        continue block15;
                    }
                    case 0: {
                        this.setAromatic(sysInd, true, true, possiblyHetero);
                        this.setUnSaturated(sysInd, true, true);
                    }
                }
            }
        }
    }

    private int getHeteroType(MolAtom atom) {
        int atNo = atom.getAtno();
        if (atNo != 6 && atNo != 1 && atNo <= 109) {
            return 1;
        }
        if (atNo == 131) {
            return 2;
        }
        if (atNo == 132) {
            return 2;
        }
        return 0;
    }

    private void setUnSaturated(int sysInd, boolean b, boolean ambig) {
        this.ringTypes[sysInd] = b ? this.ringTypes[sysInd] | 0x80 : this.ringTypes[sysInd] & 0xFFFFFF7F;
        this.ringTypes[sysInd] = ambig ? this.ringTypes[sysInd] : this.ringTypes[sysInd] & 0xFFFFFFBF;
    }

    private void setAromatic(int sysInd, boolean b, boolean ambig, boolean possiblyHetero) {
        this.ringTypes[sysInd] = b ? this.ringTypes[sysInd] | 8 : this.ringTypes[sysInd] & 0xFFFFFFF7;
        this.ringTypes[sysInd] = ambig ? this.ringTypes[sysInd] : this.ringTypes[sysInd] & 0xFFFFFFFB;
        this.ringTypes[sysInd] = possiblyHetero ? this.ringTypes[sysInd] | 0x100 : this.ringTypes[sysInd];
    }

    private void setHetero(int sysInd, boolean b, boolean ambig) {
        this.ringTypes[sysInd] = b ? this.ringTypes[sysInd] | 0x20 : this.ringTypes[sysInd] & 0xFFFFFFDF;
        this.ringTypes[sysInd] = ambig ? this.ringTypes[sysInd] : this.ringTypes[sysInd] & 0xFFFFFFEF;
    }

    private void setFused(int r, boolean b) {
        if (b) {
            int n = r;
            this.ringTypes[n] = this.ringTypes[n] | 2;
            int n2 = r;
            this.ringTypes[n2] = this.ringTypes[n2] & 0xFFFFFFFE;
        } else {
            int n = r;
            this.ringTypes[n] = this.ringTypes[n] | 1;
            int n3 = r;
            this.ringTypes[n3] = this.ringTypes[n3] & 0xFFFFFFFD;
        }
    }

    public boolean getMonocyclic(int r) {
        return (this.ringTypes[r] & 1) > 0;
    }

    @Override
    public boolean getFused(int r) {
        return (this.ringTypes[r] & 2) > 0;
    }

    public boolean getAliphatic(int r) {
        return (this.ringTypes[r] & 4) > 0;
    }

    public boolean getAromatic(int r) {
        return (this.ringTypes[r] & 8) > 0;
    }

    public boolean getHeteroAromatic(int r) {
        return (this.ringTypes[r] & 0x100) > 0;
    }

    public boolean getCarboHydro(int r) {
        return (this.ringTypes[r] & 0x10) > 0;
    }

    public boolean getHetero(int r) {
        return (this.ringTypes[r] & 0x20) > 0;
    }

    public int getAtomNumber(int r, int atNo) {
        return this.ringAtomType[r][atNo];
    }

    @Override
    public boolean getSaturated(int r) {
        return (this.ringTypes[r] & 0x40) > 0;
    }

    @Override
    public boolean getUnsaturated(int r) {
        return (this.ringTypes[r] & 0x80) > 0;
    }

    private int[][] getSystemsOfSSSR(int[][] sssrConnections) {
        Object sysSssrInd = new int[1][];
        boolean[] usedRing = null;
        usedRing = ArrayTools.initBooleanArrayAndFill(usedRing, this.sssr.length, false);
        for (int i = 0; i < this.sssr.length; ++i) {
            if (usedRing[i]) continue;
            IntVector ringSys = new IntVector();
            IntVector toProcessV = new IntVector();
            toProcessV.add(i);
            while (toProcessV.size() > 0) {
                int currRing = toProcessV.removeLast();
                if (usedRing[currRing]) continue;
                usedRing[currRing] = true;
                ringSys.add(currRing);
                for (int j = i + 1; j < this.sssr.length; ++j) {
                    if (sssrConnections[currRing][j] != 2) continue;
                    toProcessV.add(j);
                }
            }
            sysSssrInd = ArrayTools.extendArray(sysSssrInd, ++this.ringNum);
            sysSssrInd[this.ringNum - 1] = ringSys.toArray();
        }
        return sysSssrInd;
    }

    private int[][] getRingConnections() {
        int[][] sssrConnections = new int[this.sssr.length][this.sssr.length];
        for (int i = 0; i < this.sssr.length; ++i) {
            for (int j = 0; j < this.sssr[i].length; ++j) {
                for (int m = i + 1; m < this.sssr.length; ++m) {
                    for (int n = 0; n < this.sssr[m].length; ++n) {
                        if (this.sssr[i][j] != this.sssr[m][n] || sssrConnections[i][m] == 2) continue;
                        int[] nArray = sssrConnections[i];
                        int n2 = m;
                        nArray[n2] = nArray[n2] + 1;
                        int[] nArray2 = sssrConnections[m];
                        int n3 = i;
                        nArray2[n3] = nArray2[n3] + 1;
                    }
                }
            }
        }
        return sssrConnections;
    }

    private void getSssr() {
        SSSR sssrModule = new SSSR();
        sssrModule.setGraph(this.mol.smol());
        sssrModule.startRingSearch(false);
        this.sssr = sssrModule.getRings();
        this.sssrBonds = sssrModule.getBondIndexes();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("sssr: " + HomologyRingClassifier.dumpIntIntArray(this.sssr));
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("sssrBonds: " + HomologyRingClassifier.dumpIntIntArray(this.sssrBonds));
        }
    }

    private static String dumpIntIntArray(int[][] sssr2) {
        StringBuffer sb = new StringBuffer();
        for (int[] v : sssr2) {
            sb.append("\n");
            sb.append(Arrays.toString(v));
        }
        return null;
    }

    public int[][] getRings() {
        if (this.rings == null) {
            this.findFusedRings();
        }
        return this.rings;
    }

    public int[] getRingTypes() {
        if (this.rings == null) {
            this.findFusedRings();
        }
        return this.ringTypes;
    }

    public int getRingIndex(int atomInd) {
        if (this.rings == null) {
            this.findFusedRings();
        }
        return this.ringIndex[atomInd];
    }

    public int[] getRing(int ringIndex2) {
        if (this.rings == null) {
            this.findFusedRings();
        }
        return this.rings[ringIndex2];
    }

    @Override
    public int[] getHgMappableNeighbours(int m) {
        IntVector neighV = new IntVector();
        MolAtom atom = this.mol.getAtom(m);
        int n = atom.getBondCount();
        for (int i = 0; i < n; ++i) {
            int neighInd = this.mol.indexOf(atom.getLigand(i));
            if (this.ringIndex[neighInd] < 0 && this.mol.getAtom(neighInd).getAtno() != 1) continue;
            neighV.add(neighInd);
        }
        return neighV.toArray();
    }

    @Override
    public int[] getNeighbours(int m) {
        IntVector neighV = new IntVector();
        MolAtom atom = this.mol.getAtom(m);
        int n = atom.getBondCount();
        for (int i = 0; i < n; ++i) {
            int neighInd = this.mol.indexOf(atom.getLigand(i));
            neighV.add(neighInd);
        }
        return neighV.toArray();
    }

    @Override
    public int[] getMatchableAtoms(int critInd) {
        return this.rings[critInd];
    }

    @Override
    public int getQuantityOfAtomType(int critInd, int type) {
        if (type == 1) {
            int num = 0;
            for (int a : this.rings[critInd]) {
                for (int n : this.getHgMappableNeighbours(a)) {
                    if (this.mol.getAtom(n).getAtno() != 1) continue;
                    ++num;
                }
            }
            return num;
        }
        return this.ringAtomType[critInd][type];
    }

    @Override
    public int getAtNoOfAtom(int m) {
        return this.mol.getAtom(m).getAtno();
    }

    @Override
    public int getIsotopeOfAtom(int m) {
        return this.mol.getAtom(m).getMassno();
    }

    @Override
    public int getNumberOfRingAtoms(int ringIndex) {
        return this.rings[ringIndex].length;
    }

    @Override
    public int getNumberOfRings(int ringIndex) {
        return this.sysSssrInd[ringIndex].length;
    }

    @Override
    public int getQuantityOfBonds(int strIndex, int type) {
        int[] sssrIndexes;
        IntVector bondIndexes = new IntVector();
        for (int sssrInd : sssrIndexes = this.sysSssrInd[strIndex]) {
            for (int b : this.sssrBonds[sssrInd]) {
                if (this.mol.getBond(b).getType() != type || bondIndexes.contains(b)) continue;
                bondIndexes.add(b);
            }
        }
        return bondIndexes.size() + HomologyConversionUtil.getAdditionalBondsFromAromatic(strIndex, type, this);
    }

    @Override
    public int[] getAttachAtoms(int strIndex) {
        IntVector atoms = new IntVector();
        for (int a : this.rings[strIndex]) {
            int n = this.getNeighbours(a).length;
            for (int i = this.getHgMappableNeighbours(a).length; i < n; ++i) {
                atoms.add(a);
            }
        }
        return atoms.toArray();
    }
}

