/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.supergraph;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.Aromata;
import chemaxon.enumeration.AromUtil;
import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.MarkushEnumeratorFactory;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SearchEnumerator;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.formats.MolExporter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MarkushAromata {
    private static MarkushEnumeratorFactory factory = new MarkushEnumeratorFactory(6201);
    private Aromata aromata = null;
    private static final Logger logger = Logger.getLogger(MarkushAromata.class.getName());
    public static final long MAX_ENUMERATION_COUNT = 100L;
    public static final int AROM_ORIG = 0;
    public static final int AROM_ANY = 1;
    public static final int AROM_SAME = 2;
    public static final int AROM_IMPLIES_AROM = 3;
    public static final int NONAROM_IMPLIES_NONAROM = 4;
    private static final String ENUMERATE = "ENUMERATE";
    private final ExpansionCounter expansionCounter = new ExpansionCounter();
    private long maxCount = 100L;
    private long currentCount = 0L;

    public MarkushAromata() {
        this.aromata = new Aromata();
        this.aromata.setAmbiguousGeneralAromatization(false);
        this.aromata.setQueryAromatization(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generalAromatize(Molecule mol) {
        boolean hascg = mol.isGUIContracted();
        if (hascg) {
            mol.setGUIContracted(false);
        }
        try {
            this.aromata.setMol(mol);
            this.aromata.generalAromatize();
        }
        finally {
            if (hascg) {
                mol.setGUIContracted(true);
            }
        }
    }

    public int[][] aromatize(Molecule mol) {
        return this.aromatize(mol, 100L);
    }

    public int[][] aromatize(Molecule mol, long enumerationCount) {
        if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            this.generalAromatize(rgmol.getRoot());
            for (int i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
                for (int j = rgmol.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                    this.generalAromatize(rgmol.getRgroupMember(i, j));
                }
            }
        } else {
            this.generalAromatize(mol);
        }
        this.maxCount = enumerationCount;
        MoleculeGraph union = mol.getGraphUnion();
        ArrayList<int[]> ambiguousList = new ArrayList<int[]>();
        int atomCount = union.getAtomCount();
        int[][] SSSR2 = AromUtil.getSSSR(union);
        boolean[] allRingAtomIdxes = new boolean[atomCount];
        Aromata.setAllRingAtomIdxes(allRingAtomIdxes, SSSR2);
        for (int i = 0; i < SSSR2.length; ++i) {
            int[] r = SSSR2[i];
            if (logger.isLoggable(Level.FINEST)) {
                try {
                    logger.finest("Processing:\n" + MolExporter.exportToFormat(mol, "mrv"));
                }
                catch (IOException e) {
                    logger.finest("Error during MRV export: " + e);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing ring: " + StringUtil.arrayToString(r, 1, " "));
            }
            if (MarkushAromata.isAromatic(union, r)) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("ring is aromatic");
                continue;
            }
            BitSet s = new BitSet(atomCount);
            for (int j = 0; j < r.length; ++j) {
                s.set(r[j]);
            }
            int k = ambiguousList.size();
            int[] edonation = new int[atomCount];
            int dlArom = Aromata.isDaylightAromatic(s, union, allRingAtomIdxes, edonation, ENUMERATE);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Aromata.isDaylightAromatic(): " + MarkushAromata.getAromString(dlArom));
            }
            if (this.maxCount > 0L && (dlArom == -3 || dlArom == -4)) {
                if (logger.isLoggable(Level.FINE)) {
                    MarkushAromata.logEnumIndexes(mol);
                }
                this.currentCount = 1L;
                Molecule m = mol.cloneMolecule();
                int[] r0 = new int[r.length];
                System.arraycopy(r, 0, r0, 0, r.length);
                int[] atomIndexesToEnumerate = this.buildBaseStructure(m, union, r0);
                if (atomIndexesToEnumerate.length > 0) {
                    AromUtil.markAtoms(m, r0);
                    dlArom = this.isDaylightAromaticByEnumeration(atomIndexesToEnumerate, m);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("isDaylightAromaticByEnumeration(): " + MarkushAromata.getAromString(dlArom));
                    }
                } else if (!MarkushAromata.isOverlappingRing(r, SSSR2)) {
                    dlArom = -1;
                    logger.fine("Isolated ring considered aliphatic.");
                } else {
                    AromUtil.markAtoms(m, r0);
                    dlArom = -3;
                    logger.fine("Unknown.");
                }
            }
            if (dlArom == -2) {
                AromUtil.unmarkMol(union, ENUMERATE);
                MarkushAromata.setAromatic(union, r);
                logger.fine("Aromatic.");
                continue;
            }
            if (dlArom == -3 || dlArom == -4) {
                AromUtil.unmarkMol(union, ENUMERATE);
                AromUtil.markAtoms(union, r, k);
                ambiguousList.add(r);
                logger.fine("Unknown.");
                continue;
            }
            AromUtil.unmarkMol(union, ENUMERATE);
        }
        AromUtil.unmarkMol(union);
        int[][] ambiguous = new int[ambiguousList.size()][];
        ambiguousList.toArray((T[])ambiguous);
        if (mol instanceof RgMolecule) {
            AromUtil.markAmbigAromPathsInRgroupMembers((RgMolecule)mol);
        }
        return ambiguous;
    }

    private int isDaylightAromaticByEnumeration(int[] indexes, Molecule mol) {
        if (logger.isLoggable(Level.FINEST)) {
            Molecule m = mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : mol;
            try {
                logger.finest("Processing:\n" + MolExporter.exportToFormat(m, "mrv"));
            }
            catch (IOException e) {
                logger.finest("Error during MRV export: " + e);
            }
        }
        this.expansionCounter.setMolecule(mol, indexes);
        --this.currentCount;
        try {
            long count = this.expansionCounter.countExpansions();
            if (count == 1L && !SearchEnumerator.isEnumerable(mol, indexes, 6201)) {
                throw new SupergraphException("Molecule is not enumerable.");
            }
            this.currentCount += count;
        }
        catch (ExpansionException e) {
            logger.fine("Catching ExpansionException, returning DL_UNKNOWN");
            logger.throwing("MarkushAromata", "isDaylightAromaticByEnumeration", e);
            return -3;
        }
        catch (SupergraphException e) {
            logger.fine("Catching SupergraphException, returning DL_UNKNOWN");
            logger.throwing("MarkushAromata", "isDaylightAromaticByEnumeration", e);
            return -3;
        }
        catch (ExpansionCounter.ArithmeticOverflowException e) {
            logger.fine("Catching ExpansionCounter.ArithmeticOverflowException, returning DL_UNKNOWN");
            logger.throwing("MarkushAromata", "isDaylightAromaticByEnumeration", e);
            return -3;
        }
        if (this.currentCount > this.maxCount) {
            return -3;
        }
        int result = 0;
        ArrayList<int[]> indexList = new ArrayList<int[]>();
        ArrayList<Molecule> molList = new ArrayList<Molecule>();
        MolEnumerator enumerator = factory.createEnumerator(mol, indexes);
        while (enumerator.hasMoreElements()) {
            int[] eIndexes;
            int aromaticityOfEnumerate;
            int[] eRing;
            Molecule m;
            Molecule eMol = enumerator.nextElement();
            if (logger.isLoggable(Level.FINEST)) {
                m = eMol instanceof RgMolecule ? ((RgMolecule)eMol).getRoot() : eMol;
                try {
                    logger.finest("Enumerate before arom:\n" + MolExporter.exportToFormat(m, "mrv"));
                }
                catch (IOException e) {
                    logger.finest("Error during MRV export: " + e);
                }
            }
            this.generalAromatize(eMol);
            if (logger.isLoggable(Level.FINEST)) {
                m = eMol instanceof RgMolecule ? ((RgMolecule)eMol).getRoot() : eMol;
                try {
                    logger.finest("Enumerate after arom:\n" + MolExporter.exportToFormat(m, "mrv"));
                }
                catch (IOException e) {
                    logger.finest("Error during MRV export: " + e);
                }
            }
            if (MarkushAromata.isAromatic(eMol, eRing = AromUtil.getMarkedRing(eMol))) {
                aromaticityOfEnumerate = -2;
                logger.finer("Ring in enumerate: aromatic.");
                result = MarkushAromata.updateAromaticity(result, aromaticityOfEnumerate);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Result: " + MarkushAromata.getAromString(result));
                }
                if (result != -3) continue;
                logger.finer("Returning: unknown.");
                return -3;
            }
            int atomCount = eMol.getAtomCount();
            int[][] SSSR2 = eMol.getSSSR();
            boolean[] allRingAtomIdxes = new boolean[atomCount];
            Aromata.setAllRingAtomIdxes(allRingAtomIdxes, SSSR2);
            BitSet s = new BitSet(atomCount);
            for (int j = 0; j < eRing.length; ++j) {
                s.set(eRing[j]);
            }
            int[] edonation = new int[atomCount];
            aromaticityOfEnumerate = Aromata.isDaylightAromatic(s, eMol, allRingAtomIdxes, edonation, ENUMERATE);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Ring in enumerate: " + MarkushAromata.getAromString(aromaticityOfEnumerate));
            }
            if ((eIndexes = MarkushAromata.getEnumIndexes(eMol)).length > 0) {
                AromUtil.unmarkAtoms(eMol, eIndexes, ENUMERATE);
                molList.add(eMol);
                indexList.add(eIndexes);
                logger.finer("Enumerate further: " + eMol);
                continue;
            }
            if (aromaticityOfEnumerate == -3 && !MarkushAromata.isOverlappingRing(eRing, SSSR2)) {
                aromaticityOfEnumerate = -1;
            }
            result = MarkushAromata.updateAromaticity(result, aromaticityOfEnumerate);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Result: " + MarkushAromata.getAromString(result));
            }
            if (result != -3) continue;
            logger.finer("Returning: unknown.");
            return -3;
        }
        for (int i = molList.size() - 1; i >= 0; --i) {
            Molecule eMol = (Molecule)molList.get(i);
            int[] eIndexes = (int[])indexList.get(i);
            logger.finer("Calling isDaylightAromaticByEnumeration() for " + eMol);
            int dlArom = this.isDaylightAromaticByEnumeration(eIndexes, eMol);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("isDaylightAromaticByEnumeration() RESULT for " + eMol + ": " + MarkushAromata.getAromString(dlArom));
            }
            result = MarkushAromata.updateAromaticity(result, dlArom);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Result: " + MarkushAromata.getAromString(result));
            }
            if (result != -3) continue;
            logger.finer("Returning unknown.");
            return -3;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning: " + MarkushAromata.getAromString(result));
        }
        return result;
    }

    private static boolean isOverlappingRing(int[] eRing, int[][] SSSR2) {
        for (int ringAtom : eRing) {
            boolean alreadyFound = false;
            for (int[] otherRing : SSSR2) {
                if (!ArrayTools.foundInArray(otherRing, ringAtom)) continue;
                if (alreadyFound) {
                    return true;
                }
                alreadyFound = true;
            }
        }
        return false;
    }

    private static int updateAromaticity(int result, int dlArom) {
        if (dlArom == -3 || dlArom == -4) {
            return -3;
        }
        if (result == 0) {
            return dlArom;
        }
        if (result != dlArom) {
            return -3;
        }
        return result;
    }

    private int[] buildBaseStructure(Molecule mol, MoleculeGraph union, int[] r) {
        if (union.getFragCount(2) == 1) {
            return r;
        }
        SelectionMolecule structure = new SelectionMolecule();
        union.findFrag(r[0], 2, structure);
        for (int i = 0; i < r.length; ++i) {
            r[i] = structure.indexOf(union.getAtom(r[i]));
        }
        structure = (SelectionMolecule)structure.clone();
        if (mol instanceof RgMolecule) {
            Molecule root = new Molecule();
            root.fuse(structure);
            ((RgMolecule)mol).setRoot(root);
        } else {
            mol.clear();
            mol.fuse(structure);
        }
        AromUtil.unmarkMol(mol);
        int[] indexes = MarkushAromata.getEnumIndexes(mol);
        AromUtil.unmarkAtoms(mol, indexes, ENUMERATE);
        return indexes;
    }

    private static int[] getEnumIndexes(Molecule mol) {
        int count = mol.getAtomCount();
        IntVector v = new IntVector(count);
        for (int i = 0; i < count; ++i) {
            MolAtom a = mol.getAtom(i);
            if (!AromUtil.isMarkedAtom(a, ENUMERATE)) continue;
            v.addElement(i);
        }
        return v.toArray();
    }

    private static boolean isAromatic(MoleculeGraph union, int[] r) {
        int j = r.length - 1;
        int i = 0;
        while (i < r.length) {
            MolBond bond = union.getAtom(r[j]).getBondTo(union.getAtom(r[i]));
            if (bond.getType() != 4) {
                return false;
            }
            j = i++;
        }
        return true;
    }

    private static void setAromatic(MoleculeGraph union, int[] r) {
        int j = r.length - 1;
        int i = 0;
        while (i < r.length) {
            MolBond bond = union.getAtom(r[j]).getBondTo(union.getAtom(r[i]));
            bond.setType(4);
            j = i++;
        }
    }

    private static String getAromString(int dlArom) {
        switch (dlArom) {
            case 0: {
                return "Initial";
            }
            case -2: {
                return "Aromatic";
            }
            case -1: {
                return "Aliphatic";
            }
            case -3: {
                return "Unknown";
            }
            case -4: {
                return "Ambiguous";
            }
        }
        return null;
    }

    private static void logEnumIndexes(Molecule mol) {
        StringBuilder b = new StringBuilder();
        int count = mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            if (!mol.getAtom(i).containsPropertyKey(ENUMERATE)) continue;
            b.append(" " + (i + 1));
        }
        logger.fine("Enum indexes: " + b.toString());
    }
}

