/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.supergraph.util;

import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.util.MarkushBetweenConnsClassifier;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.BackTrack;
import chemaxon.util.RgMoleculeBondClassifier;
import chemaxon.util.RgMoleculeRingClassifier;
import chemaxon.util.RingMembership;

public class SupergraphBondClassifier
implements RingClassifier {
    Supergraph sg = null;
    MoleculeGraph origUnion;
    RgMoleculeRingClassifier markushBC = null;
    MarkushBetweenConnsClassifier mbcc = null;

    @Override
    public void classify(MoleculeGraph s) {
        this.sg = (Supergraph)s;
        this.origUnion = this.sg.getMolecule().getGraphUnion();
        this.mbcc = null;
        this.markushBC = new RgMoleculeBondClassifier();
        this.markushBC.classify(this.sg.getMolecule());
    }

    @Override
    public boolean isRingAtom(int i) {
        int[] walk;
        int oi = this.sg.getHomologyConvertedIndex(i);
        return this.markushBC.getRingmembershipOfAtom(oi, walk = this.sg.getGraphUnionWalk(i)) == RingMembership.IN_RING;
    }

    @Override
    public boolean isRingBond(int i, int j) {
        int[][] origatoms = new int[][]{this.sg.getGraphUnionWalk(i), this.sg.getGraphUnionWalk(j)};
        BackTrack bt = new BackTrack(origatoms);
        while (bt.hasMoreElements()) {
            int[] oi = (int[])bt.nextElement();
            if (!this.isConnectedInUnion(origatoms[0][oi[0]], origatoms[1][oi[1]])) continue;
            int atom1 = origatoms[0][oi[0]];
            int atom2 = origatoms[1][oi[1]];
            int[] atom1Walk = new int[oi[0] + 1];
            System.arraycopy(origatoms[0], 0, atom1Walk, 0, oi[0] + 1);
            return this.markushBC.getRingmembershipOfBond(atom1, atom2, atom1Walk) == RingMembership.IN_RING;
        }
        return false;
    }

    private boolean isConnectedInUnion(int i, int i1) {
        MolAtom ma1 = this.origUnion.getAtom(i);
        MolAtom ma2 = this.origUnion.getAtom(i1);
        return ma1.isBoundTo(ma2);
    }
}

