/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;

@Fixes(value={StructureCheckerErrorType.BOND_ANGLE, StructureCheckerErrorType.BOND_LENGTH, StructureCheckerErrorType.OVERLAPPING_ATOMS, StructureCheckerErrorType.OVERLAPPING_BONDS, StructureCheckerErrorType.THREE_DIM})
@FixerInfo(name="Clean", description="Recalculates all atom coordinates for two dimensional layout.", actionStringToken="clean")
public class CleanFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        if (result.getErrorType() == StructureCheckerErrorType.THREE_DIM) {
            return result.getMolecule().clean(2, null);
        }
        return result.getMolecule().clean(result.getMolecule().getDim(), null);
    }
}

