/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;

@Fixes(value={StructureCheckerErrorType.COVALENT_COUNTER_ION})
@FixerInfo(name="Convert to Ionic Form", description="Converts covalent counerion to ionic form.", actionStringToken="converttoionicform")
public class CovalentCounterionFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolAtom atom : result.getAtoms()) {
            if (atom.getAtno() == 7 || atom.getAtno() == 8 || atom.getAtno() == 16) {
                atom.setCharge(-1);
                continue;
            }
            atom.setCharge(atom.getBondCount());
        }
        for (MolBond bond : result.getBonds()) {
            result.getMolecule().removeBond(bond);
        }
        return true;
    }
}

