/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.MetalloceneCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Fixes(value={StructureCheckerErrorType.METALLOCENE_AMBIGUOUS, StructureCheckerErrorType.METALLOCENE})
@FixerInfo(name="Fix Multiple Metallocenes", description="Converts multiple metallocenes to coordinative multicenter representations by identif\u00eding corresponding parts by distances.", actionStringToken="converttometalloceneform")
public class DistanceBasedMetalloceneFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        if (!(result instanceof MetalloceneCheckerResult)) {
            return false;
        }
        MetalloceneCheckerResult res = (MetalloceneCheckerResult)result;
        Molecule mol = res.getMolecule();
        List<MolBond> removableBonds = res.getBonds();
        List<List<MolAtom>> fiveLongRings = res.getFiveLongRings();
        List<MolAtom> metalAtoms = res.getMetalAtoms();
        HashMap metalRingMap = new HashMap();
        for (MolAtom metalAtom : metalAtoms) {
            ArrayList<List<MolAtom>> neighbourRings = new ArrayList<List<MolAtom>>();
            List<MolAtom> nearestRing = null;
            List<MolAtom> secondNearestRing = null;
            for (List<MolAtom> currentRing : fiveLongRings) {
                boolean foundNeighbour = false;
                for (int i = 0; i < currentRing.size() && !foundNeighbour; ++i) {
                    MolAtom molAtom = currentRing.get(i);
                    if (molAtom.getBondTo(metalAtom) == null) continue;
                    neighbourRings.add(currentRing);
                    foundNeighbour = true;
                }
                if (nearestRing == null) {
                    nearestRing = currentRing;
                    continue;
                }
                if (DistanceBasedMetalloceneFixer.distance(metalAtom, currentRing) <= DistanceBasedMetalloceneFixer.distance(metalAtom, nearestRing)) {
                    secondNearestRing = nearestRing;
                    nearestRing = currentRing;
                    continue;
                }
                if (secondNearestRing != null) continue;
                secondNearestRing = currentRing;
            }
            ArrayList<List<MolAtom>> rings = null;
            if (neighbourRings.size() == 2) {
                rings = neighbourRings;
            } else if (neighbourRings.size() == 1) {
                if (!neighbourRings.contains(nearestRing)) {
                    neighbourRings.add(nearestRing);
                } else {
                    neighbourRings.add(secondNearestRing);
                }
                rings = neighbourRings;
            } else {
                rings = new ArrayList();
                rings.add(nearestRing);
                rings.add(secondNearestRing);
            }
            metalRingMap.put(metalAtom, rings);
        }
        for (MolAtom molAtom : metalRingMap.keySet()) {
            for (List ring : (List)metalRingMap.get(molAtom)) {
                MulticenterSgroup group = new MulticenterSgroup(mol);
                for (MolAtom ringAtom : ring) {
                    ringAtom.setCharge(0);
                    group.add(ringAtom);
                    for (int i = 0; i < ringAtom.getBondCount(); ++i) {
                        ringAtom.getBond(i).setType(4);
                    }
                }
                group.addCentralAtom();
                mol.addSgroup(group, true);
                mol.add(new MolBond(molAtom, group.getCentralAtom(), 9));
            }
            molAtom.setCharge(0);
        }
        for (MolBond molBond : removableBonds) {
            mol.removeBond(molBond);
        }
        return true;
    }

    private static double distance(MolAtom metalAtom, List<MolAtom> list) {
        double distance = Double.MAX_VALUE;
        for (MolAtom molAtom : list) {
            double newDistance = DistanceBasedMetalloceneFixer.distance(metalAtom, molAtom);
            if (!(newDistance < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    private static double distance(MolAtom a1, MolAtom a2) {
        double dx = a1.getX() - a2.getX();
        double dy = a1.getY() - a2.getY();
        double dz = a1.getZ() - a2.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

