/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;
import java.util.List;

@Fixes(value={StructureCheckerErrorType.METALLOCENE})
@FixerInfo(name="Fix Metallocene", description="Converts metallocenes to coordinative multicenter representation.", actionStringToken="fixmetallocene")
public class MetalloceneFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Molecule mol = result.getMolecule();
        List<MolAtom> atoms = result.getAtoms();
        MolAtom ferrumAtom = atoms.remove(0);
        while (!atoms.isEmpty()) {
            MolAtom atom = atoms.remove(0);
            ArrayList<MolAtom> groupAtoms = new ArrayList<MolAtom>();
            groupAtoms.add(atom);
            while (!atoms.isEmpty() && groupAtoms.size() < 5) {
                if (atoms.size() == 1) {
                    groupAtoms.add(atoms.remove(0));
                    continue;
                }
                if ((atom = this.getNeighbourAtom(atoms, atom)) == null) {
                    return false;
                }
                groupAtoms.add(atom);
            }
            for (int i = 0; i < groupAtoms.size(); ++i) {
                ((MolAtom)groupAtoms.get(i)).getBondTo((MolAtom)groupAtoms.get((i + 1) % groupAtoms.size())).setType(4);
            }
            MulticenterSgroup multicenterSgroup = new MulticenterSgroup(mol);
            for (MolAtom molAtom : groupAtoms) {
                multicenterSgroup.add(molAtom);
            }
            multicenterSgroup.addCentralAtom();
            mol.addSgroup(multicenterSgroup, true);
            mol.add(new MolBond(ferrumAtom, multicenterSgroup.getCentralAtom(), 9));
        }
        List<MolBond> bonds = result.getBonds();
        for (MolBond molBond : bonds) {
            mol.removeBond(molBond);
        }
        return true;
    }

    private MolAtom getNeighbourAtom(List<MolAtom> atoms, MolAtom atom) {
        for (int i = 0; i < atoms.size(); ++i) {
            MolAtom molAtom = atoms.get(i);
            if (molAtom.getBondTo(atom) == null) continue;
            atoms.remove(molAtom);
            return molAtom;
        }
        return null;
    }
}

