/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

@FixerInfo(name="Clean Partially", description="Recalculates some of the atom coordinates for two dimensional layout.", actionStringToken="partialclean")
public class PartialCleanFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Molecule mol = result.getMolecule();
        List<MolAtom> atoms = result.getAtoms();
        List<MolBond> bonds = result.getBonds();
        for (MolBond molBond : bonds) {
            MolAtom atom1 = molBond.getAtom1();
            MolAtom atom2 = molBond.getAtom2();
            if (!atoms.contains(atom1)) {
                atoms.add(atom1);
            }
            if (atoms.contains(atom2)) continue;
            atoms.add(atom2);
        }
        ArrayList<Integer> fixedAtomIndeces = new ArrayList<Integer>();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            if (atoms.contains(mol.getAtom(i)) || fixedAtomIndeces.contains(i)) continue;
            fixedAtomIndeces.add(i);
        }
        int[] fixed = new int[fixedAtomIndeces.size()];
        for (int i = 0; i < fixedAtomIndeces.size(); ++i) {
            fixed[i] = (Integer)fixedAtomIndeces.get(i);
        }
        return mol.partialClean(2, fixed, null);
    }
}

