/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.AromaticityCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;

@Fixes(value={StructureCheckerErrorType.AROMATICITY})
@FixerInfo(name="Rearomatize", description="Rearomatizes rings.", actionStringToken="rearomatize")
public class RearomatizeFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        result.getMolecule().dearomatize();
        if (result instanceof AromaticityCheckerResult) {
            result.getMolecule().aromatize(((AromaticityCheckerResult)result).getAromataType());
        } else {
            result.getMolecule().aromatize();
        }
        return true;
    }
}

