/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;

@Fixes(value={StructureCheckerErrorType.ALIAS, StructureCheckerErrorType.ALIAS_ATOM, StructureCheckerErrorType.ALIAS_GROUP, StructureCheckerErrorType.ALIAS_NONE, StructureCheckerErrorType.ATTACHED_DATA, StructureCheckerErrorType.ATOM_VALUE, StructureCheckerErrorType.PSEUDO, StructureCheckerErrorType.PSEUDO_NO_GROUP, StructureCheckerErrorType.MULTI_CENTER, StructureCheckerErrorType.STAR, StructureCheckerErrorType.EXPLICIT_LONE_PAIR, StructureCheckerErrorType.ATOM_TYPE, StructureCheckerErrorType.SOLVENT})
@FixerInfo(name="Delete Atom", description="Deletes atom.", actionStringToken="removeatom")
public class RemoveAtomFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Molecule molecule = result.getMolecule();
        for (MolAtom molAtom : result.getAtoms()) {
            if (molAtom.getAtno() == 137) {
                for (int i = 0; i < molecule.getSgroupCount(); ++i) {
                    Sgroup sgroup = molecule.getSgroup(i);
                    if (!(sgroup instanceof MulticenterSgroup) || ((MulticenterSgroup)sgroup).getCentralAtom() != molAtom) continue;
                    molecule.ungroupSgroup(sgroup);
                }
            }
            molecule.removeAtom(molAtom, 16);
        }
        return true;
    }
}

