/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.AtomQueryPropertyCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import java.util.List;

@Fixes(value={StructureCheckerErrorType.ATOM_QUERY_PROPERTY})
@FixerInfo(name="Remove Atom Query Property", description="Removes atom query property.", actionStringToken="removeatomqueryproperty")
public class RemoveAtomQueryPropertyFixer
extends AbstractStructureFixer {
    private void fix(List<MolAtom> atoms, List<String> properties) {
        for (MolAtom atom : atoms) {
            for (int i = 0; i < properties.size(); ++i) {
                atom.setQProp(properties.get(i), null);
            }
        }
    }

    @Override
    public boolean fix(StructureCheckerResult result) {
        if (result instanceof AtomQueryPropertyCheckerResult) {
            AtomQueryPropertyCheckerResult r = (AtomQueryPropertyCheckerResult)result;
            this.fix(r.getAtoms(), r.getProperties());
            return true;
        }
        return false;
    }
}

