/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;

@Fixes(value={StructureCheckerErrorType.ATTACHED_DATA})
@FixerInfo(name="Remove Attached Data", description="Removes attached data.", actionStringToken="removeattacheddata")
public class RemoveAttachedDataFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Sgroup[] sgroups = result.getMolecule().getSgroupArray();
        for (int i = 0; i < sgroups.length; ++i) {
            if (!(sgroups[i] instanceof DataSgroup)) continue;
            result.getMolecule().ungroupSgroup(sgroups[i]);
        }
        return true;
    }
}

