/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;

@Fixes(value={StructureCheckerErrorType.THREE_DIM})
@FixerInfo(name="Remove Z-Coordinate", description="Sets the z-coordinate to zero.", actionStringToken="removezcoordinate")
public class RemoveZCoordinateFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolAtom atom : result.getAtoms()) {
            atom.setZ(0.0);
        }
        return true;
    }
}

