/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.RgroupCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.util.RgroupInfo;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

@Fixes(value={StructureCheckerErrorType.RGROUP_ATTACHMENT_ERROR})
@FixerInfo(name="Fix R-group Attachments", description="Adds missing attachments to R-group members in unambiguous cases.", actionStringToken="fixrgroupattachment")
public class RgroupAttachmentFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        boolean fixed = false;
        if (result instanceof RgroupCheckerResult) {
            RgroupCheckerResult res = (RgroupCheckerResult)result;
            fixed = true;
            for (RgroupInfo group : res.getRgroups()) {
                boolean fixableRgroup = true;
                List<Integer> attachments = null;
                for (MolAtom atom : group.getAtoms()) {
                    if (attachments == null) {
                        attachments = RgroupInfo.collectAttachments(atom);
                        continue;
                    }
                    if (RgroupInfo.compare(attachments, RgroupInfo.collectAttachments(atom)) == 0) continue;
                    fixableRgroup = false;
                    fixed = false;
                }
                if (!fixableRgroup || attachments == null) continue;
                for (Molecule member : group.getMembers()) {
                    List<Integer> memberAttachments = RgroupInfo.collectAttachments(member);
                    boolean fixableMember = true;
                    boolean fixedMember = false;
                    if (RgroupInfo.compare(attachments, memberAttachments) != 0 && attachments.size() == memberAttachments.size()) {
                        int i;
                        List<MolAtom> ligands = RgroupInfo.collectAttachmentAtoms(member);
                        for (i = 0; i < ligands.size(); ++i) {
                            if (this.freeAttachments(ligands.get(i).getLigand(0)) >= attachments.get(i)) continue;
                            fixableMember = false;
                            break;
                        }
                        if (fixableMember) {
                            for (i = 0; i < ligands.size(); ++i) {
                                MolAtom ligand = ligands.get(i);
                                if (ligand.getValence() == attachments.get(i).intValue()) continue;
                                MolAtom location = ligand.getLigand(0);
                                member.removeAtom(ligand);
                                MolImportUtil.addCleanedRgroupAttachmentPoint(location, i + 1, attachments.get(i));
                            }
                            fixedMember = true;
                        }
                    }
                    if (this.fixMember(group, member.cloneMoleculeWithDocument())) {
                        this.fixMember(group, member);
                        fixedMember = true;
                    } else {
                        fixedMember = false;
                    }
                    if (fixedMember) continue;
                    fixed = false;
                }
            }
        }
        return fixed;
    }

    private int freeAttachments(MolAtom atom) {
        int result = atom.getImplicitHcount();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolAtom ligand = atom.getLigand(i);
            if (ligand.getAtno() != 138) continue;
            result += ligand.getValence();
        }
        return result;
    }

    private List<Integer> allFreeAttachments(Molecule member) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (MolAtom atom : member.getAtomArray()) {
            result.add(atom.getImplicitHcount());
        }
        return result;
    }

    private int getMatchingCount(int bondType, List<Integer> valences) {
        int count = 0;
        for (int valence : valences) {
            if (valence < bondType) continue;
            ++count;
        }
        return count;
    }

    private void addAttachmentPoint(int bondType, Molecule member, int order) {
        for (MolAtom atom : member.getAtomArray()) {
            if (atom.getImplicitHcount() < bondType) continue;
            MolImportUtil.addCleanedRgroupAttachmentPoint(atom, order, bondType);
            break;
        }
    }

    private boolean fixMember(RgroupInfo group, Molecule member) {
        RgroupInfo.LigandInfo[] bondCountsByType = group.getBondInfos();
        List<Integer> valences = this.allFreeAttachments(member);
        for (MolAtom atom : member.getAtomArray()) {
            if (atom.getAtno() != 138) continue;
            for (int i = 0; i < atom.getBondCount(); ++i) {
                MolBond bond = atom.getBond(i);
                if (bond.getType() < 1 || bond.getType() > 3) continue;
                bondCountsByType[bond.getType() - 1].removeValue(atom.getRgroupAttachmentPointOrder());
            }
        }
        for (int i = 3; i >= 1; --i) {
            while (bondCountsByType[i - 1].size() > 0) {
                if (this.getMatchingCount(i, valences) == 1) {
                    this.addAttachmentPoint(i, member, bondCountsByType[i - 1].get(0));
                    bondCountsByType[i - 1].remove(0);
                    valences.remove((Object)i);
                    continue;
                }
                return false;
            }
        }
        return true;
    }
}

