/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.StructureFixer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class StructureFixerDescriptor
implements Cloneable {
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String ACTIONSTRING_TOKEN = "actionStringToken";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String name = "Unnamed";
    private String description = "No description";
    private String[] actionStringTokens = new String[0];

    public StructureFixerDescriptor(Class<? extends StructureFixer> fixerClass) throws IllegalArgumentException {
        if (fixerClass == null) {
            throw new IllegalArgumentException("Fixer class must not be null");
        }
        if (fixerClass.isAnnotationPresent(FixerInfo.class)) {
            FixerInfo info = fixerClass.getAnnotation(FixerInfo.class);
            this.name = info.name();
            this.description = info.description();
            this.actionStringTokens = info.actionStringToken().split(",");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.getName();
        this.name = name;
        this.propertyChangeSupport.firePropertyChange(NAME, oldValue, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldValue = this.getDescription();
        this.description = description;
        this.propertyChangeSupport.firePropertyChange(DESCRIPTION, oldValue, description);
    }

    public String[] getActionStringTokens() {
        return this.actionStringTokens;
    }

    public void setActionStringTokens(String[] actionStringTokens) {
        String[] oldActionStrings = this.getActionStringTokens();
        this.actionStringTokens = actionStringTokens;
        this.propertyChangeSupport.firePropertyChange(ACTIONSTRING_TOKEN, oldActionStrings, actionStringTokens);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        if (this.actionStringTokens != null) {
            for (String token : this.actionStringTokens) {
                result = 31 * result + token.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureFixerDescriptor other = (StructureFixerDescriptor)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.actionStringTokens == null) {
            if (other.actionStringTokens != null) {
                return false;
            }
        } else {
            if (this.actionStringTokens.length != other.actionStringTokens.length) {
                return false;
            }
            for (int i = 0; i < this.actionStringTokens.length; ++i) {
                if (this.actionStringTokens[i].equals(other.actionStringTokens[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "StructureFixerDescriptor [getName()=" + this.getName() + ", getActionStringTokens()=" + this.getActionStringTokens() + ", getDescription()=" + this.getDescription() + ", hashCode()=" + this.hashCode() + "]";
    }

    public StructureFixerDescriptor clone() throws CloneNotSupportedException {
        StructureFixerDescriptor clone = (StructureFixerDescriptor)super.clone();
        clone.propertyChangeSupport = new PropertyChangeSupport(clone);
        return clone;
    }
}

