/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.fixers.StructureFixer;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StructureFixerFactory {
    private static final String FIXERFACTORYCONFIG_XML = "fixerfactoryconfig.xml";
    private static final String DEFAULT_CONFIGURATION_PATH = "/chemaxon/fixers/resource/defaultfixerfactoryconfig.xml";
    private static final String DEFAULT_CONFIGURATION_SCHEMA = "/chemaxon/fixers/resource/fixerconfiguration.xsd";
    private static final Properties EXTERNAL_OVERRIDE_PROPERTIES = new Properties();
    private static final Map<String, Class<StructureFixer>> DEFAULT_MAP = StructureFixerFactory.getFixerIdFixerClassMap(StructureFixerFactory.class.getResourceAsStream("/chemaxon/fixers/resource/defaultfixerfactoryconfig.xml"), StructureFixerFactory.getExternalStream(), EXTERNAL_OVERRIDE_PROPERTIES);
    private Map<String, Class<StructureFixer>> fixerIdFixerClassMap;
    private boolean initialized = false;
    private final List<StructureFixer> fixers = new ArrayList<StructureFixer>();
    private final Map<String, StructureFixer> fixerIdFixerMap = new HashMap<String, StructureFixer>();

    public StructureFixerFactory() {
        this.fixerIdFixerClassMap = DEFAULT_MAP;
    }

    public StructureFixerFactory(String path) {
        try {
            this.fixerIdFixerClassMap = StructureFixerFactory.getFixerIdFixerClassMap(new FileInputStream(path), null, EXTERNAL_OVERRIDE_PROPERTIES);
        }
        catch (FileNotFoundException e) {
            if (this.fixerIdFixerClassMap != null) {
                this.fixerIdFixerClassMap.clear();
            }
            this.fixerIdFixerClassMap = Collections.emptyMap();
        }
    }

    public StructureFixer getFixer(String fixerId) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.fixerIdFixerMap.get(fixerId);
    }

    public List<StructureFixer> getFixers() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.fixers;
    }

    private void initialize() {
        this.initialized = true;
        for (String id : this.fixerIdFixerClassMap.keySet()) {
            Class<StructureFixer> fixerClass = this.fixerIdFixerClassMap.get(id);
            for (Constructor<?> constructor : fixerClass.getConstructors()) {
                StructureFixer fixer;
                if (constructor.getParameterTypes().length != 0) continue;
                try {
                    fixer = (StructureFixer)constructor.newInstance(null);
                }
                catch (IllegalArgumentException e) {
                    fixer = null;
                }
                catch (InstantiationException e) {
                    fixer = null;
                }
                catch (IllegalAccessException e) {
                    fixer = null;
                }
                catch (InvocationTargetException e) {
                    fixer = null;
                }
                if (fixer == null) continue;
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(id + ".name")) {
                    fixer.getDescriptor().setName(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(id + ".name"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(id + ".description")) {
                    fixer.getDescriptor().setDescription(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(id + ".description"));
                }
                this.fixers.add(fixer);
                this.fixerIdFixerMap.put(id, fixer);
            }
        }
    }

    private static Map<String, Class<StructureFixer>> getFixerIdFixerClassMap(InputStream internalFixerConfigStream, InputStream externalFixerConfigStream, Properties externalOverrideProperties) {
        HashMap<String, Class<StructureFixer>> map = new HashMap<String, Class<StructureFixer>>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            URL schemaURL = StructureFixerFactory.class.getResource(DEFAULT_CONFIGURATION_SCHEMA);
            if (schemaURL != null) {
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
                try {
                    factory.setSchema(schema);
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
            }
            SAXParser parser = factory.newSAXParser();
            if (internalFixerConfigStream != null) {
                parser.parse(internalFixerConfigStream, (DefaultHandler)new FixerFactoryHandler(map));
            }
            if (externalFixerConfigStream != null) {
                parser.parse(externalFixerConfigStream, (DefaultHandler)new FixerFactoryHandler(map, externalOverrideProperties, true));
            }
        }
        catch (IOException exception) {
            StructureFixerFactory.clearData(map);
        }
        catch (SAXException e) {
            StructureFixerFactory.clearData(map);
        }
        catch (ParserConfigurationException e) {
            StructureFixerFactory.clearData(map);
        }
        return map;
    }

    private static void clearData(Map<String, Class<StructureFixer>> map) {
        map.clear();
    }

    private static InputStream getExternalStream() {
        try {
            return new FileInputStream(DotfileUtil.getDotFile(FIXERFACTORYCONFIG_XML));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private static class FixerFactoryHandler
    extends DefaultHandler {
        private final Map<String, Class<StructureFixer>> map;
        private final boolean isExternal;
        private final Properties properties;

        public FixerFactoryHandler(Map<String, Class<StructureFixer>> map) {
            this(map, false);
        }

        public FixerFactoryHandler(Map<String, Class<StructureFixer>> map, boolean isExternal) {
            this(map, null, isExternal);
        }

        public FixerFactoryHandler(Map<String, Class<StructureFixer>> map, Properties properties, boolean isExternal) {
            this.map = map;
            this.properties = properties;
            this.isExternal = isExternal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("bundle".equals(qName) && this.properties != null) {
                InputStream inStream = null;
                try {
                    inStream = this.isExternal ? DotfileUtil.open(attributes.getValue("base")) : this.getClass().getResourceAsStream(attributes.getValue("base"));
                    this.properties.load(inStream);
                }
                catch (IOException e) {
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            inStream = null;
                        }
                    }
                }
            } else if ("fixer".equals(qName)) {
                try {
                    File file;
                    ClassLoader loader = this.getClass().getClassLoader();
                    String path = attributes.getValue("jar");
                    if (path != null && !"".equals(path) && (file = new File(path)).canRead() && file.isFile()) {
                        try {
                            loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                    this.map.put(attributes.getValue("id"), Class.forName(attributes.getValue("class"), false, loader));
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }
}

