/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.SubstructureChecker;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.result.SubstructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.ModuleNotAvailableException;
import chemaxon.util.reaction.ReactionPerformer;
import chemaxon.util.reaction.ReactionPerformerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

@Fixes(value={StructureCheckerErrorType.SUBSTRUCTURE})
@FixerInfo(name="Transform", description="Modifies substructures.", actionStringToken="transform")
public class SubstructureFixer
extends AbstractStructureFixer {
    private static final Logger LOGGER = Logger.getLogger(SubstructureChecker.class.getName());

    @Override
    public boolean fix(StructureCheckerResult result) {
        if (result instanceof SubstructureCheckerResult) {
            ReactionPerformer transformer;
            Molecule reaction;
            String smarts = ((SubstructureCheckerResult)result).getReactionSmarts();
            try {
                reaction = MolImporter.importMol(smarts, "smarts");
            }
            catch (MolFormatException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Cannot import SMARTS: " + smarts, e);
                }
                return false;
            }
            try {
                transformer = ReactionPerformerFactory.createTransformer(reaction);
            }
            catch (ModuleNotAvailableException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Substructure fixer cannot be initialized. JChem module is not available.", e);
                }
                return false;
            }
            transformer.performReaction(result.getMolecule());
            return true;
        }
        return false;
    }
}

