/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.SgroupCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.Sgroup;

@Fixes(value={StructureCheckerErrorType.ABBREVIATED_GROUP, StructureCheckerErrorType.ABBREVIATED_GROUP_WITH_ONLY_CONTRACTED, StructureCheckerErrorType.ABBREVIATED_GROUP_WITH_ONLY_EXPANDED})
@FixerInfo(name="Ungroup", description="Ungroups abbreviated groups.", actionStringToken="ungroup")
public class UngroupFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        if (result instanceof SgroupCheckerResult) {
            boolean succed = true;
            for (Sgroup group : ((SgroupCheckerResult)result).getSgroups()) {
                succed &= result.getMolecule().ungroupSgroup(group);
            }
            return succed;
        }
        return result.getMolecule().ungroupSgroups();
    }
}

