/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.formats.recognizer.AbbrevGroupRecognizer;
import chemaxon.formats.recognizer.CubeRecognizer;
import chemaxon.formats.recognizer.JTFRecognizer;
import chemaxon.formats.recognizer.NameRecognizer;
import chemaxon.formats.recognizer.PDBRecognizer;
import chemaxon.formats.recognizer.PeptideRecognizer;
import chemaxon.formats.recognizer.SMILESRecognizer;
import chemaxon.marvin.io.Encoding;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.struc.MProp;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MMoleculeProp;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MFileFormatUtil {
    public static final int MULTISET = 1;
    public static final int MOLMOVIE = 2;
    public static final int NOMOLMOVIE = 4;
    private static String[] molfileExtensions;
    private static String[] otherExtensions;
    private static String[] importableFormats;
    private static String[] molfileFormatExtensionArray;
    private static Map<String, MFileFormat> formatMap;
    private static List<MFileFormat> formatList;

    private static void processRegistry(String regname) {
        String pkg = MFileFormatUtil.getPackage(regname);
        try {
            InputStream is = BasicEnvironment.getResourceAsStream(MFileFormatUtil.class, "/" + regname);
            if (is == null) {
                System.err.println("Cannot find " + regname);
                return;
            }
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                String tl;
                int x;
                if (line.startsWith("#") || (x = (tl = line.trim()).indexOf("=")) == -1) continue;
                String value = tl.substring(x + 1);
                if (value.endsWith(".properties")) {
                    if (MFileFormatUtil.getPackage(value = value.substring(0, value.length() - 11)) == null) {
                        value = pkg + "/" + value + ".properties";
                    }
                    MFileFormatUtil.processRegistry(value);
                    continue;
                }
                int dot = value.lastIndexOf(46);
                try {
                    Class<?> cl = Class.forName(value.substring(0, dot));
                    Field field = cl.getField(value.substring(dot + 1));
                    MFileFormat mff = (MFileFormat)field.get(null);
                    MFileFormatUtil.registerFormat0(mff);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                catch (NoSuchFieldException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }
            br.close();
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    private static String getPackage(String name) {
        int dot = name.lastIndexOf(47);
        return dot >= 0 ? name.substring(0, dot) : null;
    }

    public static boolean isURLOrFileName(String s) {
        String ss;
        int i;
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return false;
        }
        int mend = s.indexOf("M  END");
        if (mend > 2 && (s.charAt(mend - 1) == '\\' || s.charAt(mend - 2) == '\\' || s.charAt(mend - 3) == '\\')) {
            return false;
        }
        String ts = s.trim();
        if (ts.startsWith("<?xml") || ts.startsWith("<cml")) {
            return false;
        }
        if (MFileFormatUtil.getKnownExtension(s) != null) {
            return true;
        }
        int qmark = s.indexOf(63);
        if (qmark > 1 && (i = (ss = s.substring(0, qmark).toLowerCase()).lastIndexOf(46)) != -1) {
            char c;
            ++i;
            while (i < qmark && (c = ss.charAt(i)) >= 'a' && c <= 'z') {
                ++i;
            }
            if (i == qmark) {
                return true;
            }
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if ("()[]".indexOf(c) < 0) continue;
            return false;
        }
        return MFileFormatUtil.recognizeOneLineFormat(s) == null;
    }

    public static boolean isSubFormatOf(String f, String other) {
        if (other == null) {
            return f == null;
        }
        if (f == null) {
            return false;
        }
        if (f.equals(other)) {
            return true;
        }
        int k = f.indexOf(58);
        if (k >= 0) {
            f = f.substring(0, k);
        }
        if (f.equals(other)) {
            return true;
        }
        if (other.equals("mdl")) {
            return f.equals("mol") || f.equals("sdf") || f.equals("rdf") || f.equals("rxn");
        }
        if (other.equals("csmdl")) {
            return f.equals("csmol") || f.equals("cssdf") || f.equals("csrdf") || f.equals("cxrxn");
        }
        return false;
    }

    private static boolean canBeFormatName(String s) {
        if (s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (c < 'a' || c > 'z') {
            return false;
        }
        for (int j = 1; j < s.length(); ++j) {
            c = s.charAt(j);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String recognizeOneLineFormat(String s) {
        boolean isSmarts = SMILESRecognizer.canBeSMARTS(s);
        if (isSmarts && !SMILESRecognizer.canBeSMILES(s)) {
            return "cxsmarts";
        }
        if (isSmarts && SMILESRecognizer.isCxSMILESLine(s)) {
            return "cxsmiles";
        }
        if (SMILESRecognizer.canBeSMILES(s)) {
            return "smiles";
        }
        if (AbbrevGroupRecognizer.testLine(s) != 0) {
            return "abbrevgroup";
        }
        if (PeptideRecognizer.canBe3LetterPeptide(s)) {
            return "peptide:3";
        }
        if (PeptideRecognizer.canBe1LetterPeptide(s)) {
            return "peptide:1";
        }
        if (NameRecognizer.isName(s)) {
            return "name";
        }
        return null;
    }

    @Deprecated
    public static boolean canBeAbbrevgroup(String line) {
        return AbbrevGroupRecognizer.testLine(line) != 0;
    }

    @Deprecated
    public static boolean canBeJTF(String line) {
        return JTFRecognizer.canBeJTFHeader(line);
    }

    @Deprecated
    public static boolean canBePDBRecord(String recName) {
        return PDBRecognizer.testRecord(recName) != 0;
    }

    @Deprecated
    public static boolean isCubeLine(String line, int count) {
        return CubeRecognizer.isCubeLine(line, count);
    }

    public static String[] getJTFFields(String line) {
        String[] fields = new String[]{};
        int nfields = 0;
        String delims = " :;,\t";
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        int st = 0;
        boolean inside = false;
        boolean lastWasDelim = true;
        char lastQuotation = '\u0000';
        for (int x = 0; x < line.length(); ++x) {
            char ch = line.charAt(x);
            if (!(inside || ch != '\"' && ch != '\'')) {
                inside = true;
                st = x + 1;
                lastQuotation = ch;
            } else if (ch == lastQuotation) {
                inside = false;
                fields = MFileFormatUtil.addToStringArray(fields, nfields++, line.substring(st, x));
            }
            if (!inside && " :;,\t".indexOf(ch) != -1) {
                if (lastWasDelim) {
                    fields = MFileFormatUtil.addToStringArray(fields, nfields++, null);
                }
                lastWasDelim = true;
                continue;
            }
            lastWasDelim = false;
        }
        if (inside) {
            return null;
        }
        if (fields.length != nfields) {
            String[] tmp = new String[nfields];
            System.arraycopy(fields, 0, tmp, 0, nfields);
            fields = tmp;
        }
        return fields;
    }

    public static String[] splitFileAndOptions(String arg) {
        String[] result = new String[2];
        String opts = null;
        int i = -1;
        if (arg.endsWith("}") || arg.endsWith(")") && !SMILESRecognizer.canBeSMARTS(arg) && !NameRecognizer.isName(arg) && !PeptideRecognizer.canBe1LetterPeptide(arg) && !PeptideRecognizer.canBe3LetterPeptide(arg)) {
            i = MFileFormatUtil.findOpeningBracket(arg);
        }
        if (i >= 0) {
            opts = arg.substring(i + 1, arg.length() - 1);
            arg = arg.substring(0, i);
        }
        result[0] = arg;
        result[1] = opts;
        return result;
    }

    private static int findOpeningBracket(String arg) {
        int i = arg.length() - 1;
        char closech = arg.charAt(i);
        char opench = closech == '}' ? (char)'{' : (closech == ')' ? (char)'(' : '\u0000');
        int closes = 0;
        for (int j = i; j >= 0; --j) {
            char c = arg.charAt(j);
            if (c == closech) {
                ++closes;
            } else if (c == opench) {
                --closes;
            }
            if (closes != 0) continue;
            return j;
        }
        return -1;
    }

    public static String[] splitFormatAndOptions(String opts) {
        return MFileFormatUtil.splitFormatAndOptions(opts, importableFormats);
    }

    private static String[] splitFormatAndOptions(String opts, String[] fmts) {
        String[] result = new String[2];
        result[1] = opts;
        if (opts != null) {
            int i = opts.indexOf(58);
            if (i == 0) {
                result[1] = opts.substring(1);
            } else if (i > 0) {
                String s = opts.substring(0, i);
                if (!MFileFormatUtil.canBeFormatName(s)) {
                    return result;
                }
                result[0] = s;
                result[1] = opts.substring(i + 1);
            } else if (fmts != null) {
                for (int j = 0; j < fmts.length; ++j) {
                    if (!fmts[j].equals(opts)) continue;
                    result[0] = opts;
                    result[1] = "";
                    break;
                }
            }
        }
        return result;
    }

    public static int preprocessFormatAndOptions(String[] fmtopts) {
        String s = fmtopts[1];
        int result = 0;
        if (s != null) {
            char c;
            int i = 0;
            if (s.startsWith("MULTISET")) {
                result |= 1;
                i = 8;
            } else if (s.startsWith("NOMOLMOVIE")) {
                result |= 4;
                i = 10;
            } else if (s.startsWith("MOLMOVIE")) {
                result |= 2;
                i = 8;
            }
            while (i < s.length() && ((c = s.charAt(i)) <= ' ' || c == ',' || c == ';')) {
                ++i;
            }
            fmtopts[1] = s.substring(i);
        }
        return result;
    }

    public static String[] getEncodingFromOptions(String fmtopts) {
        int j;
        if (fmtopts == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = fmtopts.indexOf("enc{");
        if (i >= 0 && (j = fmtopts.indexOf("}", i + 1)) >= 0) {
            sb.append(fmtopts.substring(0, i));
            String enc = fmtopts.substring(i + 4, j);
            enc = Encoding.canonicalName(enc);
            sb.append(fmtopts.substring(j + 1));
            return new String[]{enc, sb.toString()};
        }
        return new String[]{null, fmtopts};
    }

    public static void testEncoding(String enc) throws IllegalArgumentException {
        if (enc == null) {
            return;
        }
        String test = "TEST";
        try {
            test.getBytes(enc);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Encoding \"" + enc + "\" is not supported");
        }
    }

    public static String getUnguessableFormat(String fname) {
        if (fname != null) {
            if ((fname = fname.toLowerCase()).endsWith(".smiles")) {
                return "cxsmiles";
            }
            if (fname.endsWith(".smarts")) {
                return "cxsmarts";
            }
            if (fname.endsWith(".smi")) {
                return "cxsmiles";
            }
            if (fname.endsWith(".sma")) {
                return "cxsmarts";
            }
            if (fname.endsWith(".cxsmiles")) {
                return "cxsmiles";
            }
            if (fname.endsWith(".cxsmarts")) {
                return "cxsmarts";
            }
            if (fname.endsWith(".cxsmi")) {
                return "cxsmiles";
            }
            if (fname.endsWith(".cxsma")) {
                return "cxsmarts";
            }
            if (fname.endsWith(".vmn")) {
                return "vmn";
            }
        }
        return null;
    }

    public static String getFileExtensionLC(File f) {
        return MFileFormatUtil.getFileExtensionLC(f.getName());
    }

    public static String getFileExtensionLC(String fname) {
        int opti = fname.lastIndexOf(46);
        String ext = opti != -1 ? fname.substring(opti + 1) : null;
        return ext;
    }

    public static String getMostLikelyMolFormat(String fname) {
        if (fname != null) {
            for (int i = 0; i < molfileFormatExtensionArray.length; i += 2) {
                if (!fname.endsWith(molfileFormatExtensionArray[i + 1])) continue;
                return molfileFormatExtensionArray[i];
            }
        }
        return null;
    }

    public static String getKnownExtension(String fname) {
        String s;
        int i;
        fname = fname.toLowerCase();
        for (i = 0; i < molfileExtensions.length; ++i) {
            s = molfileExtensions[i];
            if (!fname.endsWith(s)) continue;
            return s;
        }
        for (i = 0; i < otherExtensions.length; ++i) {
            s = otherExtensions[i];
            if (!fname.endsWith(".".concat(s))) continue;
            return s;
        }
        return null;
    }

    public static String[] getMolfileExtensions() {
        String[] v = new String[molfileExtensions.length];
        System.arraycopy(molfileExtensions, 0, v, 0, v.length);
        return v;
    }

    public static String[] getMolfileFormats() {
        String[] v = new String[importableFormats.length];
        System.arraycopy(importableFormats, 0, v, 0, v.length);
        return v;
    }

    public static boolean isOutputCleanable(String fmt) throws SecurityException {
        try {
            MolExportModule me = MFileFormatUtil.createExportModule(fmt);
            return me == null || me.isCleanable();
        }
        catch (MolExportException ex) {
            return true;
        }
    }

    private static String[] addToStringArray(String[] arr, int len, String s) {
        if ((arr == null || arr.length == 0) && len == 0) {
            arr = new String[8];
        } else if (arr != null && len == arr.length) {
            String[] t = new String[2 * arr.length];
            System.arraycopy(arr, 0, t, 0, len);
            arr = t;
        }
        if (arr != null) {
            arr[len] = s;
        }
        return arr;
    }

    @Deprecated
    public static String guessPeptideFormat(String header) {
        return PeptideRecognizer.guessPeptideFormat(header);
    }

    public static void registerFormat(MFileFormat mff) {
        mff.flags |= 0x8000L;
        MFileFormatUtil.registerFormat0(mff);
        MFileFormatUtil.initFormats();
    }

    private static void registerFormat0(MFileFormat mff) {
        int i;
        String[] names = mff.getNames();
        boolean overdef = false;
        for (i = 0; i < names.length; ++i) {
            MFileFormat oldmff;
            if (!overdef && (oldmff = formatMap.get(names[i])) != null) {
                long oldf = oldmff.getFlags();
                long f = mff.getFlags();
                if ((f & oldf) == oldf) {
                    overdef = true;
                }
            }
            formatMap.put(names[i], mff);
        }
        if (overdef) {
            block1: for (i = formatList.size() - 1; i >= 0; --i) {
                MFileFormat mffi = formatList.get(i);
                for (int j = 0; j < names.length; ++j) {
                    if (!mffi.matches(names[j], 0L, 0L)) continue;
                    formatList.remove(i);
                    continue block1;
                }
            }
        }
        formatList.add(mff);
    }

    private static void initFormats() {
        ArrayList<String> l = new ArrayList<String>();
        ArrayList<String> l_in = new ArrayList<String>();
        ArrayList<String> l_other = new ArrayList<String>();
        for (MFileFormat mff : formatList) {
            String fmt = mff.getName();
            String[] exts = mff.getExtensions();
            for (int i = 0; i < exts.length; ++i) {
                l.add(fmt);
                l.add(".".concat(exts[i]));
            }
            if ((mff.getFlags() & 2L) != 0L) {
                l_in.add(fmt);
                continue;
            }
            l_other.add(fmt);
        }
        int n = l.size() / 2;
        molfileExtensions = new String[2 * n];
        molfileFormatExtensionArray = new String[4 * n];
        for (int i = 0; i < n; ++i) {
            int k = 2 * i;
            String fmt = (String)l.get(k);
            String ext = (String)l.get(k + 1);
            MFileFormatUtil.molfileFormatExtensionArray[k] = fmt;
            MFileFormatUtil.molfileFormatExtensionArray[k + 1] = ext;
            MFileFormatUtil.molfileExtensions[i] = ext;
            ext = ext + ".gz";
            MFileFormatUtil.molfileFormatExtensionArray[k += 2 * n] = "gzip:" + fmt;
            MFileFormatUtil.molfileFormatExtensionArray[k + 1] = ext;
            MFileFormatUtil.molfileExtensions[n + i] = ext;
        }
        StringTokenizer st = new StringTokenizer("xml txt html htm cgi");
        while (st.hasMoreTokens()) {
            l_other.add(st.nextToken());
        }
        otherExtensions = new String[l_other.size()];
        l_other.toArray(otherExtensions);
        importableFormats = new String[l_in.size()];
        l_in.toArray(importableFormats);
    }

    public static MFileFormat getFormat(String fmt) {
        return formatMap.get(fmt);
    }

    public static MFileFormat[] findFormats(String fmt, long flags, long mask) {
        ArrayList<MFileFormat> list = new ArrayList<MFileFormat>();
        for (MFileFormat mff : formatList) {
            if (!mff.matches(fmt, flags, mask)) continue;
            list.add(mff);
        }
        MFileFormat[] arr = new MFileFormat[list.size()];
        list.toArray(arr);
        return arr;
    }

    public static MRecordReader createRecordReader(InputStream is, String opts) throws MolFormatException, IOException {
        return MFileFormatUtil.createRecordReader(is, opts, null, null);
    }

    public static MRecordReader createRecordReader(InputStream is, String opts, String enc, String path) throws MolFormatException, IOException {
        MolInputStream mis;
        if (is instanceof MolInputStream) {
            mis = (MolInputStream)is;
        } else {
            String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(opts);
            mis = new MolInputStream(is, fmtopts[0], enc, path);
        }
        String fmt = mis.getFormat();
        if (fmt == null) {
            return null;
        }
        int colon = fmt.indexOf(58);
        if (colon > 0) {
            fmt = fmt.substring(0, colon);
        }
        MFileFormat[] formats = MFileFormatUtil.findFormats(fmt, 0L, 0L);
        MRecordReader rr = null;
        for (int i = 0; i < formats.length && rr == null; ++i) {
            rr = formats[i].createRecordReader(mis, opts);
        }
        return rr;
    }

    public static MolExportModule createExportModule(String fmt) throws MolExportException {
        MFileFormat[] formats = MFileFormatUtil.findFormats(fmt, 1L, 1L);
        if (formats.length == 0) {
            int colon = fmt.indexOf(58);
            if (colon >= 0) {
                fmt = fmt.substring(0, colon);
            }
            formats = MFileFormatUtil.findFormats(fmt, 1L, 1L);
        }
        if (formats.length == 0) {
            return null;
        }
        return formats[0].createExportModule();
    }

    public static String[] convertToSmilingFormat(Molecule m) throws MolExportException {
        return MFileFormatUtil.convertToSmilingFormat(new MMoleculeProp(m));
    }

    public static String[] convertToSmilingFormat(MProp p) throws MolExportException {
        String[] fmts = new String[]{"smiles", "smarts", "cxsmiles", "cxsmarts"};
        MolExportException exception = null;
        for (int i = 0; i < fmts.length; ++i) {
            try {
                String[] r = new String[]{p.convertToString(fmts[i]), fmts[i]};
                return r;
            }
            catch (IllegalArgumentException ex) {
                if (exception != null) continue;
                exception = new MolExportException(ex);
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    static {
        formatMap = new HashMap<String, MFileFormat>();
        formatList = new ArrayList<MFileFormat>();
        MFileFormatUtil.processRegistry("chemaxon/formats/registry.properties");
        MFileFormatUtil.initFormats();
    }
}

