/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.formats.MolFormatException;
import chemaxon.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class MolChiralFlagSetter {
    private static final String[] molTags = new String[]{"$MFMT", "$MOL"};
    private static final String COUNTS = "  0  0  0  0  0";

    public static byte[] setChiralFlagInMDLFile(byte[] molfile, String format2, boolean value) throws MolFormatException {
        String struc = null;
        try {
            struc = new String(molfile, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String result = MolChiralFlagSetter.setChiralFlagInMDLFile(struc, format2, value);
        try {
            return result.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String setChiralFlagInMDLFile(String molfile, String format2, boolean value) throws MolFormatException {
        if (format2.startsWith("mol") || format2.startsWith("csmol")) {
            return MolChiralFlagSetter.setChiralFlagInMolfile(molfile, value);
        }
        if (format2.startsWith("rdf") || format2.startsWith("csrdf")) {
            return MolChiralFlagSetter.setChiralFlagInRDF(molfile, value);
        }
        throw new MolFormatException("Cannot change chiral flag in format:" + format2);
    }

    private static String setChiralFlagInRDF(String rdfile, boolean value) throws MolFormatException {
        StringBuffer mf = new StringBuffer(rdfile);
        for (int x = 0; x < molTags.length; ++x) {
            String tag = molTags[x];
            int idx = 0;
            while ((idx = rdfile.indexOf(tag, idx)) != -1) {
                idx = MolChiralFlagSetter.skip(rdfile, idx, 1, '\n');
                int end = rdfile.indexOf("\nM  END", idx) + 7;
                String molfile = mf.substring(idx, end);
                molfile = MolChiralFlagSetter.setChiralFlagInMolfile(molfile, value);
                mf.replace(idx, end, molfile);
            }
        }
        return mf.toString();
    }

    private static String setChiralFlagInMolfile(String molfile, boolean value) throws MolFormatException {
        boolean v30;
        int eol;
        StringBuffer mf = new StringBuffer(molfile);
        int idx = MolChiralFlagSetter.skip(molfile, 0, 3, '\n');
        String line = molfile.substring(idx, (eol = MolChiralFlagSetter.skip(molfile, idx, 1, '\n')) - 1);
        boolean bl = v30 = line.indexOf("V3000") != -1;
        if (v30) {
            idx = MolChiralFlagSetter.skip(molfile, idx, 2, '\n');
            idx = MolChiralFlagSetter.skipWhiteSpace(molfile, idx, 7);
            mf.setCharAt(idx, value ? (char)'1' : '0');
        } else {
            int length = line.length();
            if (length < 15) {
                String toAdd = COUNTS.substring(length, 15);
                mf.insert(eol - 1, toAdd);
            }
            mf.setCharAt(idx + 12, ' ');
            mf.setCharAt(idx + 13, ' ');
            mf.setCharAt(idx + 14, value ? (char)'1' : '0');
        }
        idx = molfile.indexOf("\n", idx);
        return mf.toString();
    }

    private static int skipWhiteSpace(String molfile, int pos, int count) throws MolFormatException {
        int newPos = StringUtil.skipDelimiters(molfile, " \t", pos, count);
        if (newPos == -1) {
            throw new MolFormatException("Cannot locate chiral flag in molfile:\n" + molfile + "\n");
        }
        return newPos;
    }

    private static int skip(String str, int pos, int count, char ch) throws MolFormatException {
        for (int x = 0; x < count; ++x) {
            if ((pos = str.indexOf(ch, pos) + 1) != 0) continue;
            throw new MolFormatException("Cannot locate chiral flag in molfile:\n" + str + "\n");
        }
        return pos;
    }
}

