/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.core.spi.Clean3DIface;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.formats.recognizer.NucleicAcidRecognizer;
import chemaxon.formats.recognizer.PeptideRecognizer;
import chemaxon.marvin.io.Encoding;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolFragLoader;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.util.ErrorProcessor;
import chemaxon.util.IntRange;
import chemaxon.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class MolConverter {
    private static boolean isExitAllowed = true;
    private static final String NL = System.getProperty("line.separator");
    private static RuntimeException OptionsNotSupported = new UnsupportedOperationException("Use MolConverter.Builder instead of Molconverter.Options! Options is not supported anymore.");
    private RgMolecule molBuf = new RgMolecule();
    private MolInputStream molInputStream = null;
    private MolImporter molimp = null;
    private MolExporter exporter = null;
    private RandomAccessFile oraf = null;
    private boolean ownsTheOutputStream = false;
    private int cleanDim = 2;
    private int[] cleanFixedAtoms = null;
    private Builder theOptions;
    private int inFileIndex;
    private int inMolIndex;
    private long inBytesRead;
    private int verbose = 0;
    private boolean ignoreError = false;
    private boolean removeSmallFrags = false;
    private boolean removeH = false;
    private boolean molFieldsToRecords = false;
    private boolean hasMoreMols;
    private String[] condNames = null;
    private static final int LESS = -2;
    private static final int LESS_OR_EQUAL = -1;
    private static final int EQUAL = 0;
    private static final int GREATER_OR_EQUAL = 1;
    private static final int GREATER = 2;
    private int[] condOPs = null;
    private String[] condValues = null;
    private Properties fuseFragsTable = null;
    private IntRange molIndexRange = null;
    private int nextMolIndex = -1;
    private ArrayList<Molecule> unionList = null;
    private int threadCount = -1;
    private static final String HELP_BASIC = "Molecule File Converter, version " + VersionInfo.MARVIN_VERSION + ", (C) 1999-2012 ChemAxon Ltd.\n" + "Licenses of additionally used third party programs can be found in license.html\n" + "Online version: http://www.chemaxon.com/marvin/license.html \n" + "Usage: molconvert [options] outformat[:export-opts] [files...]\n" + "Converts the specified files to another format.\n" + "  Output molecule formats: %{MOLECULE_FORMATS}.\n" + "  Graphics formats: %{GRAPHICS_FORMATS}.\n" + "  Archiving formats: %{ARCHIVE_FORMATS}.\n" + "Options:\n" + "-h  this help  -Ho output formats help  -Hg  graphics help  -Hi  import options\n" + "               -H3D   3D coordinate calculation options help\n" + "-v  verbose    -vv  very verbose, stack trace on error\n" + "-o <file>      write output to file     -m     produce multiple output files\n" + "-s <string>    read SMILES, SMARTS, peptide or IUPAC name (recognize format)\n" + "-s <string>{format:[options]}  read the string in specified format\n" + "--smiles <string>   read SMILES        --smarts <string>   read SMARTS\n" + "--peptide <string>  read a 1- or 3-letter-abbreviated peptide sequence name\n" + "-e INCHARSET  or -e [INCHARSET]..[OUTCHARSET]  Set the input and/or output\n" + "       character sets. Examples: UTF-8, ASCII, Cp1250 (Windows Eastern\n" + "       European), Cp1252 (Windows Latin 1), ms932 (Windows Japanese).\n" + "   To query the recognized encoding, use molconvert query-encoding [files...]\n" + "-g  continue with next molecule on error\n" + "-Y  remove explicit H's                -F  remove small fragments, keep largest\n" + "-I  <range>                process input molecules with molecule index\n" + "                           (1-based) falling into the specified range\n" + "                           (e.g. 5-8,15 refers to molecules 5,6,7,8,15)\n" + "-U                         fuse input molecules and output the union\n" + "-R  <file>[:<range>]       fuse fragments to input molecule(s) from file\n" + "                           with specified mol index range\n" + "                           range syntax: \"-5,10-20,25,26,38-\"\n" + "                           (e.g. -R frags.mrv:20-) \n" + "-R<i>  <file>[:<range>]    fuse R<i> definition members\n" + "                           to input molecule(s) from file\n" + "                           in specified index range\n" + "                           (e.g. -R1 rdef1.mrv:5-8,19) \n" + "-R<i>:<n>  <file>[:<range>]   fuse R<i> definition members\n" + "                           to input molecule(s) from file\n" + "                           in specified index range, filter molecules\n" + "                           having <n> (e.g. 1 or 2) attachment points\n" + "                           (e.g. -R1:2 rdef1.mrv:-3,8-10) \n" + "-c \"<f1><OP><value>&<f2><OP><value>&...\"  filtering by the values of fields\n" + "   in the case of SDfile import. <OP> may be: =,<,>,<=,>=\n" + "--mol-fields-to-records  convert molecule type fields to separate records\n" + "-0  skip coordinate calculation for SMILES input\n" + "-2[:opts][:F<i1>,<i2>,...,<iN>]  2D coordinate calculation\n" + "                                 (useful if the input is SMILES)\n" + " 2D opts:  e  make cis/trans either bonds\n" + " F<i1>,<i2>,...,<iN>  partial clean with atoms i1, i2, ... iN are fixed\n" + "                      where i1, i2, ..., iN are 1-based atom indexes\n" + "-3[:opts]  3D coordinate calculation\n" + " 3D opts:  S{fine}     Find low energy conformer Leave failed fragments intact\n" + "           S{fast}     Fast clean, if failed, perform fine clean,\n" + "                       accept any generated structure (default)\n" + "           S{nofaulty} Same as S{fast}, but leave failed fragments intact.\n" + "Examples:\n" + "  molconvert -2:e mol foo.smiles -o foo.mol   (SMILES to Molfile)\n" + "  molconvert smiles:a bar.mol -o bar.smiles   (Molfile to aromatized SMILES)\n" + "  molconvert cml:A foo.mol -o foo.cml         (Molfile to CML with arrays)\n" + "  molconvert sdf *.mol - -o molecules.sdf     (Molfiles + STDIN to SDfile)\n" + "  molconvert query-encoding *.sdf             (queries detected encodings)\n" + "  molconvert sdf -U -I -4,9,11 fragments.sdf  (fuse input mols in index range)\n" + "  molconvert mrv in.mrv -R2:1 rdef.mrv        (fuse R2 definition from file)\n" + "  molconvert \"jpeg:w100,Q95,#ffff00\" nice.mol -o nice.jpg  (creates 100x100\n" + "                          JPEG image on yellow background, with 95% quality)\n";
    private static final String HELP_MOL_FORMATS = "Output molecule file formats:\n  cml    CML                     mrv         ChemAxon Marvin Document\n  mol    MDL Mol, RG or Rxnfile  csmol       ChemAxon Compressed Molfile\n  rgf    MDL RGfile (.mol)       csrgf       ChemAxon Compressed RGfile (.csmol)\n  rxn    MDL Rxnfile             csrxn       ChemAxon Compressed Rxnfile\n  sdf    MDL SDfile              cssdf       ChemAxon Compressed SDfile\n  rdf    MDL RDfile              csrdf       ChemAxon Compressed RDfile\n  smiles SMILES                  cxsmiles    ChemAxon Extended SMILES\n  smarts SMARTS                  cxsmarts    ChemAxon Extended SMARTS\n                                 abbrevgroup ChemAxon SMILES Abbreviated Groups\n  inchi  IUPAC InChI             inchikey    IUPAC InChIKey\n  name   IUPAC Name              peptide:1   1-letter Peptide Sequence\n  cube   Gaussian Cube           peptide:3   3-letter Peptide Sequence\n  gjf    Gaussian Output         mol2        Tripos Mol2\n  pdb    Protein Data Bank       sybyl       Tripos SYBYL molfile (.mol)\n  xyz    MSC XYZ\nMiscellaneous formats:\n  gzip  GZIP compressed file  base64      Base64 encoding\nExport options for various formats:\n  XXX:a or XXX:+a or XXX:a_gen  general aromatization,\n  XXX:a_bas  basic aromatization, XXX:a_loose  loose aromatization\n  XXX:-a or XXX:-a_gen  general dearomatization\n  XXX:-a_huckel huckel dearomatization\n  XXX:-a_huckel_ex huckel dearomatization with exception on failure\n  XXX:+numbering  assign atom numberings corresponding to the (IUPAC) name\n  XXX:H   add explicit H atoms, XXX:-H  remove them    (XXX=any format)\n  MDL:V3  use Extended Molfile Format (MDL=mol,rxn,sdf,rdf)\n  MDL:b#  scale molecule in such a way that C-C bond lengths will be\n          # instead of the default 0.825 (MDL=mol,rgf,sdf,csmol,csrgf,cssdf)\n  pdb:-c     do not store connections\n  cml:A      use arrays in CML\n  smiles:0   do not write stereo information in SMILES\n  smiles:q   check atom equivalences using graph invariants at double bonds\n               Note: Use this option if you want unique SMILES export\n  smiles:s   write query smarts (don't write explicit H in bracket) \n  gzip:X:Y   convert to format X with options Y, then GZIP it\n  base64:X:Y convert to format X with options Y, then base64-encode it";
    private static final String HELP_GRAPHICS = "Image file formats: jpeg, msbmp, png, ppm. Options are separated by commas.\n  Common options:\n    a, +a, -a, a_day, H, -H etc.            (see molconvert -Ho)\n    w<WIDTH>, h<HEIGHT>, scale<VALUE>,      (size in pixels, magnification)\n    atsiz<VALUE>, bondw<VALUE>              (atom size, bond width)\n    #<[aa]rrggbb>,                          (background color)\n    H_off, H_hetero, H_heteroterm, H_all,   (implicit Hydrogen drawing)\n    mono, cpk, shapely, group, atomset,     (color scheme)\n    wireframe, wireknobs, ballstick, spacefill   (rendering style)\n    noantialias                             (antialiasing off)\n  Defaults: w200,h200,atsiz0.4,bondw0.18,cpk\n        2D: #ffffffff,wireframe      3D: #ff000000,ballstick\n2D vector graphics formats:                 3D graphics formats:\n  svg    Scalable Vector Graphics             pov    POV-Ray input file\n         (needs the Apache Batik library)\nExport options for various formats:\n  jpeg:Q... JPEG quality (0-100),  default: 90\n  png:b...  Bits/pixel (24 or 32), default: 24\n  png:Z...  PNG compression (0-9), default: 9";
    private static final String HELP_IMPORT = "Import options can be specified between braces, in one of the following forms:\n  filename{options}, filename{MULTISET,options},\n  filename{format:}                 - to skip automatic format recognition\n  filename{format:options}, filename{format:MULTISET,options}\nMULTISET is a global option to merge many imported molecules into one that\n  contains sets.\nImport options for MDL formats (mol, sdf, rdf, rxn, rgf, csmol, ...):\n    Xsg    expands all S-groups          Usg  ungroups all S-groups\n    nomolp reads molecule type data fields ($DTYPE $MFMT and $RFMT) as text\nImport options for XYZ and PDB (without CONECT records):\n    f#   set bond length cut-off (default: #=1.12)\n    b    try to guess bond orders\n    C#   maximum number of connections for element C is #\nImport options for SMILES :\n    f<field>  import field after smiles string\nExamples:\n  molconvert smiles \"foo.xyz{f1.4,C4,Cl1}\"\n     - imports the XYZ file with bond-length cut-off = 1.4, max. number\n       of Carbon connections = 4 and max. Chlorine connections = 1\n  molconvert smiles \"foo.xyz{xyz:}\"\n     - imports file as XYZ, do not try to recognize the file format\n  molconvert smiles \"foo.xyz.gz{gzip:xyz:f1.4C4}\"\n     - imports file as Gzipped XYZ, with the specified options\n  molconvert mol \"foo.xyz.gz{gzip:xyz:MULTISET,f1.4C4}\"\n     - merge molecules into one multi-set molecule and export in mol format\n  molconvert sdf \"foo.smi{fname,fID}\"\n     - imports smiles file with name and ID";
    private static final String ERROR_BATIK_MISSING = "No SVG export: Apache Batik library is missing from CLASSPATH\nIt can be downloaded from http://xml.apache.org/batik/";

    public MolConverter(Builder mcbld) throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
        this.init(this.interpretOptions(mcbld));
    }

    public MolConverter(InputStream in, OutputStream out, String fmtopts, boolean useSysEOL) throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
        Builder mcbld = new Builder();
        mcbld.addInput(in, "");
        mcbld.setOutput(out, fmtopts);
        mcbld.setOutputFlags(useSysEOL ? 1 : 0);
        this.init(mcbld);
    }

    public MolConverter(InputStream in, String ofname, String fmtopts, boolean useSysEOL) throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
        this.ownsTheOutputStream = true;
        this.oraf = new RandomAccessFile(ofname, "rw");
        FileOutputStream fos = new FileOutputStream(this.oraf.getFD());
        Builder mcbld = new Builder();
        mcbld.addInput(in, "");
        mcbld.setOutput(fos, fmtopts);
        mcbld.setOutputFlags(useSysEOL ? 1 : 0);
        this.init(mcbld);
    }

    private MolConverter(Builder mcbld, boolean removeSmallFrags, boolean removeH, boolean molFieldsToRecords, Properties fuseFragsTable, IntRange molIndexRange, boolean union, String[] condNames, int[] condOPs, String[] condValues, int[] cleanFixedAtoms, int threadCount, boolean ignoreError, int verbose) throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
        this.removeSmallFrags = removeSmallFrags;
        this.removeH = removeH;
        this.molFieldsToRecords = molFieldsToRecords;
        this.fuseFragsTable = fuseFragsTable;
        this.molIndexRange = molIndexRange;
        this.unionList = union ? new ArrayList() : null;
        this.condNames = condNames;
        this.condOPs = condOPs;
        this.condValues = condValues;
        this.cleanFixedAtoms = cleanFixedAtoms;
        this.threadCount = threadCount;
        this.ignoreError = ignoreError;
        this.verbose = verbose;
        this.init(this.interpretOptions(mcbld));
    }

    private void init(Builder mcbld) throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
        this.inFileIndex = -1;
        this.inMolIndex = -1;
        this.inBytesRead = 0L;
        this.hasMoreMols = false;
        if (this.molIndexRange != null) {
            this.nextMolIndex = this.molIndexRange.hasNext() ? this.molIndexRange.next() - 1 : -1;
        }
        int exporterCleanDim = 0;
        String exporterCleanOpts = null;
        if (mcbld.forceCleaning && this.condNames == null && this.cleanFixedAtoms == null && this.fuseFragsTable == null && !this.molFieldsToRecords) {
            exporterCleanDim = mcbld.cleanDim;
            exporterCleanOpts = mcbld.cleanOpts;
        }
        this.theOptions = mcbld;
        this.exporter = mcbld.outputFilename != null ? new MolExporter(mcbld.outputFilename, mcbld.formatAndOptions, mcbld.outputFlags, mcbld.incFields, mcbld.outputEncoding) : new MolExporter(mcbld.outputStream, mcbld.formatAndOptions, (mcbld.outputFlags & 1) != 0, mcbld.incFields, mcbld.outputEncoding);
        if (this.threadCount != -1) {
            this.exporter.setThreadCount(this.threadCount);
        }
        this.exporter.setClean(exporterCleanDim, exporterCleanOpts);
        if (this.ignoreError) {
            this.exporter.setErrorProcessor(new ConverterErrorProcessor());
        }
        if (exporterCleanDim != 0) {
            mcbld.cleanDim = 0;
            mcbld.cleanOpts = null;
            mcbld.forceCleaning = false;
        }
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        this.exporter.setErrorProcessor(ignoreError ? new ConverterErrorProcessor() : null);
    }

    public void setThreadCount(int threadCount) throws IllegalStateException {
        this.threadCount = threadCount;
        this.exporter.setThreadCount(threadCount);
    }

    private String currentFileName() {
        if (this.inFileIndex >= 0 && this.inFileIndex < this.theOptions.inFiles.size()) {
            Object o = this.theOptions.inFiles.get(this.inFileIndex);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof File) {
                return ((File)o).getPath();
            }
            return "file " + (this.inFileIndex + 1);
        }
        return "";
    }

    public boolean convert() throws IOException {
        if (this.hasMoreMols) {
            ++this.inMolIndex;
            this.hasMoreMols = this.convert0();
            if (!this.hasMoreMols) {
                this.writeUnion();
                if (this.verbose > 0 && this.inFileIndex >= 0) {
                    if (this.verbose > 1) {
                        System.err.print("... ");
                    }
                    System.err.println("Converted " + this.inMolIndex + " molecule(s)" + " from " + this.currentFileName() + "{" + this.molInputStream.getFormat() + "}");
                }
                this.inMolIndex = -1;
                this.molimp.close();
                this.exporter.flush();
            }
        }
        while (!this.hasMoreMols && this.inFileIndex < this.theOptions.inFiles.size() - 1) {
            block22: {
                ++this.inFileIndex;
                Object inObj = this.theOptions.inFiles.get(this.inFileIndex);
                String opts = (String)this.theOptions.inOptions.get(this.inFileIndex);
                String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(opts);
                InputStream in = null;
                String fname = null;
                if (inObj instanceof InputStream) {
                    in = (InputStream)inObj;
                } else if (inObj instanceof File) {
                    File f = (File)inObj;
                    if (fmtopts[0] == null) {
                        String s = f.getName();
                        fmtopts[0] = MFileFormatUtil.getUnguessableFormat(s);
                    }
                    in = new FileInputStream(f);
                    fname = f.getPath();
                } else if (inObj instanceof String) {
                    String s = (String)inObj;
                    if (fmtopts[0] == null) {
                        fmtopts[0] = MFileFormatUtil.getUnguessableFormat(s);
                    }
                    in = new FileInputStream(s);
                    fname = s;
                } else {
                    throw new IOException("internal error:bad object type in files vector: " + inObj.getClass().getName());
                }
                String[] encopts = MFileFormatUtil.getEncodingFromOptions(opts);
                String enc = encopts[0];
                if (enc == null) {
                    enc = this.theOptions.inputEncoding;
                }
                opts = encopts[1];
                this.molInputStream = in instanceof MolInputStream ? (MolInputStream)in : new MolInputStream(in, fmtopts[0], enc, fname);
                if (this.verbose > 1) {
                    String fnameInMsg = "";
                    if (fname != null && fname.length() != 0) {
                        fnameInMsg = ": " + fname;
                    }
                    System.err.println("Reading file " + (this.inFileIndex + 1) + fnameInMsg + " (" + this.molInputStream.getFormat() + " format) ... ");
                }
                this.molimp = null;
                try {
                    this.molimp = new MolImporter(this.molInputStream, opts, enc);
                }
                catch (IOException ex) {
                    if (this.ignoreError) break block22;
                    throw ex;
                }
            }
            if (this.threadCount != -1) {
                this.molimp.setThreadCount(this.threadCount);
            }
            ++this.inMolIndex;
            this.hasMoreMols = this.convert0();
            if (this.hasMoreMols) continue;
            this.writeUnion();
            if (this.verbose > 0) {
                if (this.verbose > 1) {
                    System.err.print("... ");
                }
                System.err.println("Converted " + this.inMolIndex + " molecule(s)" + " from " + this.currentFileName());
            }
            this.inMolIndex = -1;
            this.molimp.close();
            this.exporter.flush();
        }
        if (!this.hasMoreMols) {
            this.exporter.close(2);
        }
        return this.hasMoreMols;
    }

    private void writeUnion() throws MolExportException, IOException {
        if (this.unionList == null || this.unionList.isEmpty()) {
            return;
        }
        MoleculeGraph[] frags = new Molecule[this.unionList.size()];
        this.unionList.toArray(frags);
        this.unionList = null;
        Molecule mol = (Molecule)frags[0].newInstance();
        int dim = frags[0].getDim();
        if (dim != 0 && this.exporter.isCleanable()) {
            CleanUtil.arrangeMolecules(frags, 2, -1);
        }
        for (MoleculeGraph frag : frags) {
            mol.fuse(frag);
        }
        this.write(mol);
    }

    private Molecule findLargestFragment(Molecule m) {
        MoleculeGraph[] frags = m.findFrags(m.getClass());
        int max = -1;
        if (frags.length == 0) {
            return m;
        }
        Molecule largest = null;
        for (int i = 0; i < frags.length; ++i) {
            int nc = frags[i].getAtomCount();
            if (nc <= max) continue;
            max = nc;
            largest = (Molecule)frags[i];
        }
        MPropertyContainer mprops = m.properties();
        String[] pkeys = mprops.getKeys();
        if (largest != null) {
            for (int i = 0; i < pkeys.length; ++i) {
                largest.properties().set(pkeys[i], mprops.get(pkeys[i]));
            }
            largest.setName(m.getName());
            largest.setComment(m.getComment());
        }
        return largest;
    }

    private boolean convert0() throws MolExportException, IOException {
        if (this.molimp != null) {
            if (this.molIndexRange != null && this.nextMolIndex == -1) {
                return false;
            }
            long fp0 = this.molInputStream.getFilePointer();
            MDocument doc = this.readDoc();
            long fp = this.molInputStream.getFilePointer();
            this.inBytesRead += fp - fp0;
            if (this.molIndexRange != null) {
                assert (this.inMolIndex <= this.nextMolIndex);
                if (this.inMolIndex < this.nextMolIndex) {
                    return true;
                }
                if (this.inMolIndex == this.nextMolIndex) {
                    int n = this.nextMolIndex = this.molIndexRange.hasNext() ? this.molIndexRange.next() - 1 : -1;
                }
            }
            if (doc != null) {
                MoleculeGraph mol = null;
                for (int i = 0; i < doc.getObjectCount(); ++i) {
                    boolean cleanNeeded;
                    int colon;
                    Molecule m;
                    MObject mo = doc.getObject(i);
                    if (!(mo instanceof MChemicalStruct)) continue;
                    Molecule m0 = m = (Molecule)((MChemicalStruct)mo).getMoleculeGraph();
                    String infmt = m.getInputFormat();
                    int n = colon = infmt != null ? infmt.indexOf(58) : -1;
                    if (infmt != null && colon >= 0) {
                        infmt = infmt.substring(0, colon);
                    }
                    String outfmt = this.exporter.getFormat();
                    boolean bl = cleanNeeded = m.getDim() == 0 && this.cleanDim > 0 && infmt != null && (infmt.equals("smiles") || infmt.equals("smarts") || infmt.equals("cxsmiles") || infmt.equals("cxsmarts") || infmt.equals("name")) && this.exporter.isCleanable() && !outfmt.equals("mrv") && !outfmt.equals("cml");
                    if (this.condNames != null && !this.condOK(m)) continue;
                    if (this.removeSmallFrags) {
                        m = this.findLargestFragment(m);
                    }
                    if (this.removeH) {
                        m.implicitizeHydrogens(33);
                    }
                    if (this.theOptions.forceCleaning || cleanNeeded) {
                        if (this.cleanFixedAtoms == null) {
                            m.clean(this.theOptions.cleanDim, this.theOptions.cleanOpts);
                        } else {
                            m.partialClean(this.theOptions.cleanDim, this.cleanFixedAtoms, this.theOptions.cleanOpts);
                        }
                    }
                    if (m0 != doc.getMainMoleculeGraph()) continue;
                    mol = m;
                }
                if (mol != null) {
                    if (this.fuseFragsTable != null) {
                        RgMolecule rgmol = null;
                        if (mol instanceof RgMolecule) {
                            rgmol = (RgMolecule)mol;
                        } else {
                            rgmol = new RgMolecule();
                            rgmol.setDim(mol.getDim());
                            rgmol.setRoot((Molecule)mol);
                        }
                        MolConverter.fuseFragments(rgmol, this.fuseFragsTable);
                        mol = rgmol;
                    }
                    this.hasMoreMols = this.molFieldsToRecords ? this.writeMolWithFieldsAsRecords((Molecule)mol) : this.write((Molecule)mol);
                }
                return this.hasMoreMols;
            }
        }
        return false;
    }

    private static void fuseFragments(RgMolecule mol, Properties fuseFragsTable) throws IOException {
        Enumeration<?> keys = fuseFragsTable.propertyNames();
        while (keys.hasMoreElements()) {
            String rangeString;
            String value;
            String key = (String)keys.nextElement();
            String file = value = fuseFragsTable.getProperty(key);
            IntRange range = null;
            int k = value.lastIndexOf(58);
            if (k != -1 && IntRange.isValidRangeString(rangeString = value.substring(k + 1))) {
                file = value.substring(0, k);
                range = new IntRange(rangeString);
            }
            if (key.equals("R")) {
                MolConverter.loadFragments(mol, file, range);
                continue;
            }
            int attach = -1;
            k = key.indexOf(58);
            if (k != -1) {
                attach = Integer.parseInt(key.substring(k + 1));
                key = key.substring(0, k);
            }
            int rgroupID = Integer.parseInt(key.substring(1));
            MolConverter.loadRgroupMembers(mol, file, range, rgroupID, attach);
        }
    }

    private static void loadFragments(RgMolecule mol, String file, IntRange range) throws IOException {
        MolImporter importer = new MolImporter(file);
        MolFragLoader loader = new MolFragLoader(importer);
        loader.setRange(range);
        loader.loadFrags(mol, true);
        importer.close();
    }

    private static void loadRgroupMembers(RgMolecule mol, String file, IntRange range, int rgroupID, int attach) throws IOException {
        MolImporter importer = new MolImporter(file);
        MolFragLoader loader = new MolFragLoader(importer);
        loader.setRange(range);
        if (attach != -1) {
            loader.setFilter(new MolFragLoader.RgroupAttachmentCountFilter(attach));
        }
        loader.loadRgroupMembers(mol, rgroupID);
        loader.arrangeRgroupMembers(mol);
        importer.close();
    }

    private boolean writeMolWithFieldsAsRecords(Molecule mol) throws MolExportException, IOException {
        ArrayList<Molecule> xmols = null;
        MPropertyContainer p = mol.properties();
        for (MProp prop : p.getPropList()) {
            if (!(prop instanceof MMoleculeProp) || mol.isSelfReference(prop)) continue;
            MMoleculeProp molp = (MMoleculeProp)prop;
            if (xmols == null) {
                xmols = new ArrayList<Molecule>();
            }
            xmols.add(molp.getMolecule());
            p.remove(molp);
        }
        if (!this.write(mol)) {
            return false;
        }
        if (xmols != null) {
            for (Molecule m : xmols) {
                if (this.write(m)) continue;
                return false;
            }
        }
        return true;
    }

    private MDocument readDoc() throws IOException {
        try {
            return this.molimp.readDoc(this.molBuf.getDocument(), this.molBuf);
        }
        catch (Exception e) {
            if (this.ignoreError) {
                this.printError(e, this.verbose);
                Molecule empty = new Molecule();
                String format2 = this.molimp.getFormat();
                if (format2.equals("name") || format2.startsWith("name:")) {
                    empty.setName(this.molimp.getGrabbedMoleculeString().trim());
                }
                return new MDocument(empty);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return null;
        }
    }

    private boolean write(Molecule mol) throws MolExportException, IOException {
        block7: {
            if (this.unionList == null) {
                try {
                    if (!this.exporter.write(mol)) {
                        this.exporter.close();
                        return false;
                    }
                    break block7;
                }
                catch (IllegalArgumentException e) {
                    if (this.ignoreError && e.getCause() instanceof MolExportException) {
                        this.printError(e.getCause(), this.verbose);
                        this.exporter.write(new Molecule());
                        break block7;
                    }
                    throw e;
                }
                catch (MolExportException e) {
                    if (this.ignoreError) {
                        this.printError(e, this.verbose);
                        this.exporter.write(new Molecule());
                        break block7;
                    }
                    throw e;
                }
            }
            this.unionList.add(mol);
        }
        return true;
    }

    public long otell() throws IOException {
        if (this.oraf == null) {
            throw new IOException("MolConverter cannot determine output file position");
        }
        return this.oraf.getFilePointer();
    }

    public void close() throws IOException {
        this.close(1);
    }

    public void close(int opts) throws IOException {
        this.exporter.close(this.ownsTheOutputStream ? 1 : opts);
        if (this.oraf != null) {
            this.oraf.close();
        }
    }

    private void printError(Throwable ex, int verbosity) {
        MolFormatException mex;
        int n;
        Object o = this.theOptions.inFiles.get(this.inFileIndex);
        String s = "";
        if (o instanceof String) {
            s = s + (String)o + ":";
        } else if (o instanceof File) {
            s = s + ((File)o).getPath() + ":";
        }
        int lc = 0;
        if (ex instanceof MolFormatException && (n = (mex = (MolFormatException)ex).getLineNumberInFile()) != 0) {
            lc = n;
        }
        if (lc != 0) {
            s = s + lc + ":";
        }
        if (ex instanceof MolExportException) {
            s = s + " cannot convert molecule";
            int molIndex = ((MolExportException)ex).getMolIndex();
            if (molIndex == -1) {
                molIndex = this.inMolIndex;
            }
            if (molIndex != -1) {
                s = s + " " + (molIndex + 1);
            }
            s = s + " to " + this.exporter.getFormat();
        } else {
            s = this.inMolIndex > 0 && (this.inMolIndex + 1 < lc || lc == 0) ? s + " error in molecule " + (this.inMolIndex + 1) : s + " error";
        }
        if (verbosity > 1) {
            System.err.println(s);
            Throwable t = ex;
            if (verbosity == 2) {
                while (t.getCause() != null) {
                    t = t.getCause();
                }
            }
            t.printStackTrace();
        } else {
            if (s.length() != 0) {
                s = s + ": ";
            }
            Throwable t = ex;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            System.err.println(s + t.getMessage());
        }
    }

    private boolean condOK(Molecule m) {
        for (int i = 0; i < this.condNames.length; ++i) {
            String condName = this.condNames[i].toLowerCase();
            String propValue = m.getProperty(condName);
            if (propValue != null && this.checkCond(propValue, this.condOPs[i], this.condValues[i])) continue;
            return false;
        }
        return true;
    }

    private boolean checkCond(String a, int op, String b) {
        try {
            float fa = Float.parseFloat(a);
            float fb = Float.parseFloat(b);
            switch (op) {
                case 0: {
                    return fa == fb;
                }
                case 2: {
                    return fa > fb;
                }
                case -2: {
                    return fa < fb;
                }
                case 1: {
                    return fa >= fb;
                }
                case -1: {
                    return fa <= fb;
                }
            }
        }
        catch (Throwable t) {
            int res = a.compareTo(b);
            switch (op) {
                case 0: {
                    return res == 0;
                }
                case 2: {
                    return res > 0;
                }
                case -2: {
                    return res < 0;
                }
                case 1: {
                    return res >= 0;
                }
                case -1: {
                    return res <= 0;
                }
            }
        }
        return false;
    }

    private static void readInputStringFromCommandLine(String arg, Builder mcbld, String format2) {
        String[] stringArray;
        if (format2 != null && !format2.equals("--peptide") && !format2.equals("--na")) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = arg;
            stringArray = stringArray2;
            stringArray2[1] = null;
        } else {
            stringArray = MFileFormatUtil.splitFileAndOptions(arg);
        }
        String[] smiopts = stringArray;
        byte[] data = smiopts[0].getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        String s = smiopts[1];
        if (s == null) {
            s = format2 == null ? ((s = MFileFormatUtil.recognizeOneLineFormat(smiopts[0])) != null ? s + ":" : "cxsmiles:") : format2 + (format2.indexOf(":") < 0 ? "" : ":");
        } else {
            String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(s);
            if (fmtopts[0] == null) {
                s = format2 == null ? ((s = MFileFormatUtil.recognizeOneLineFormat(smiopts[0])) != null ? s + ":" + fmtopts[1] : "cxsmiles:" + fmtopts[1]) : format2 + (format2.indexOf(":") < 0 ? "" : ":") + fmtopts[1];
            }
        }
        mcbld.addInput(is, s);
    }

    private static void writeHelpTo(OutputStream out, String strhelp) throws IOException {
        String[] macros = new String[]{"%{MOLECULE_FORMATS}", "%{GRAPHICS_FORMATS}", "%{ARCHIVE_FORMATS}"};
        int linestarti = 0;
        while (linestarti >= 0 && linestarti < strhelp.length()) {
            int lineendi = strhelp.indexOf(10, linestarti);
            if (lineendi < 0) {
                lineendi = strhelp.length();
            }
            String line = strhelp.substring(linestarti, lineendi);
            for (int i = 0; i < macros.length; ++i) {
                int j = line.indexOf(macros[i]);
                while (j >= 0) {
                    int[] jref = new int[]{j};
                    String val = MolConverter.processMacro(macros[i], jref);
                    if (val == null) {
                        throw new RuntimeException(macros[i] + ": unknown macro");
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(line.substring(0, j));
                    sb.append(val);
                    int remaining = line.length() - j - macros[i].length();
                    if (jref[0] + remaining > 80) {
                        sb.append(NL + "    ");
                    }
                    sb.append(line.substring(j + macros[i].length()));
                    j = line.indexOf(macros[i], j + val.length());
                    line = sb.toString();
                }
            }
            linestarti = lineendi + 1;
            out.write(line.getBytes());
            out.write(NL.getBytes());
        }
        out.flush();
    }

    private static final String processMacro(String macro, int[] iref) {
        String val = MolConverter.getFormatList(macro, iref);
        return val;
    }

    private static final String getFormatList(String macro, int[] iref) {
        long mask;
        long f;
        if (macro.equals("%{MOLECULE_FORMATS}")) {
            f = 1L;
            mask = 385L;
        } else if (macro.equals("%{GRAPHICS_FORMATS}")) {
            f = 256L;
            mask = 272L;
        } else if (macro.equals("%{ARCHIVE_FORMATS}")) {
            f = 128L;
            mask = 128L;
        } else {
            return null;
        }
        return MolConverter.getFormatList(f, mask, iref, 80, NL, 4);
    }

    private static final String getFormatList(long f, long mask, int[] i, int cols, String nl, int startcol) {
        int j;
        MFileFormat[] mff = MFileFormatUtil.findFormats(null, f, mask);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (j = 0; j < mff.length; ++j) {
            String[] names = mff[j].getNames();
            for (int k = 0; k < names.length; ++k) {
                if (list.contains(names[k])) continue;
                list.add(names[k]);
            }
        }
        for (j = 0; j < list.size(); ++j) {
            String s = (String)list.get(j);
            if (j < list.size() - 1) {
                s = s + ",";
            }
            if (i[0] + s.length() + 1 < cols) {
                if (j != 0) {
                    sb.append(' ');
                    i[0] = i[0] + 1;
                }
            } else {
                sb.append(nl);
                for (int l = 0; l < startcol; ++l) {
                    sb.append(' ');
                }
                i[0] = startcol;
            }
            sb.append(s);
            i[0] = i[0] + s.length();
        }
        return sb.toString();
    }

    private long sumInputFileLengths() {
        long n = 0L;
        for (int i = 0; i < this.theOptions.inFiles.size(); ++i) {
            Object o = this.theOptions.inFiles.get(i);
            File f = null;
            if (o instanceof String) {
                f = new File((String)o);
            }
            if (f != null) {
                long l = f.length();
                n += l;
                continue;
            }
            return -1L;
        }
        return n;
    }

    private static void printEncoding(String encoding, String name) {
        int maxnamelen = 12;
        int w = "default[]".length() + maxnamelen;
        String enc = encoding;
        if (enc.length() < w) {
            enc = (encoding + "                    ").substring(0, w);
        }
        System.out.println(enc + " " + name);
    }

    private static void queryEncoding(List<Object> inFiles, String encopt) {
        for (Object o : inFiles) {
            PositionedInputStream mis = null;
            String name = "-";
            try {
                if (o instanceof InputStream) {
                    mis = new MolInputStream((InputStream)o, null, encopt);
                } else if (o instanceof String) {
                    name = (String)o;
                    mis = new MolInputStream((InputStream)new FileInputStream(name), null, encopt);
                }
                if (mis == null) continue;
                Encoding enc = mis.getEncoding();
                String encname = enc != null ? enc.name() : "default[" + Encoding.DEFAULT.name() + "]";
                MolConverter.printEncoding(encname, name);
            }
            catch (IOException ex) {
                MolConverter.printEncoding("ERROR", name);
            }
        }
    }

    public static MolConverter createMolConverter(InputStream instream, OutputStream outstream, String[] args, int[] verbosityLevel) throws IOException {
        InputStream defaultIn = System.in;
        OutputStream defaultOut = System.out;
        OutputStream defaultErr = System.err;
        if (instream != null) {
            defaultIn = instream;
        }
        if (outstream != null) {
            defaultOut = outstream;
            defaultErr = outstream;
        }
        int verbose = 0;
        boolean ignoreError = false;
        boolean removeSmallFrags = false;
        boolean removeH = false;
        boolean molFieldsToRecords = false;
        String outfname = null;
        String outfmt = null;
        boolean forceCleaning = false;
        int cleanDim = 2;
        String cleanOpts = "";
        int[] cleanFixedAtoms = null;
        Builder mcbld = new Builder();
        String[] condNames = null;
        int[] condOPs = null;
        String[] condValues = null;
        String[] incFields = null;
        Properties fuseFragsTable = null;
        IntRange molIndexRange = null;
        boolean union = false;
        int threadCount = -1;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String s = args[i];
                if (s.equals("-")) {
                    if (instream != null) {
                        throw new IllegalArgumentException("Invalid option: '-' (standard input) is allowed only in case of command line usage");
                    }
                    mcbld.addInput(System.in, "");
                    continue;
                }
                if (s.startsWith("-{") && s.endsWith("}") || s.startsWith("-(") && s.endsWith(")")) {
                    if (instream != null) {
                        throw new IllegalArgumentException("Invalid option: '-' (standard input) is allowed only in case of command line usage");
                    }
                    mcbld.addInput(System.in, s.substring(2, s.length() - 1));
                    continue;
                }
                if (s.equals("--mol-fields-to-records")) {
                    molFieldsToRecords = true;
                    continue;
                }
                if (s.equals("--smiles") || s.equals("--smarts")) {
                    if (instream != null) {
                        throw new IllegalArgumentException("Invalid option: " + s + " is allowed only " + "in case of command line usage");
                    }
                    String fmt = null;
                    if (s.equals("--smiles")) {
                        fmt = "cxsmiles";
                    } else if (s.equals("--smarts")) {
                        fmt = "cxsmarts";
                    }
                    MolConverter.readInputStringFromCommandLine(args[++i], mcbld, fmt);
                    continue;
                }
                if (s.equals("--peptide")) {
                    if (instream != null) {
                        throw new IllegalArgumentException("Invalid option: " + s + " is allowed only " + "in case of command line usage");
                    }
                    String fmt = PeptideRecognizer.canBe1LetterPeptide(args[i + 1]) ? "peptide:1" : "peptide:3";
                    MolConverter.readInputStringFromCommandLine(args[++i], mcbld, fmt);
                    continue;
                }
                if (s.equals("--concurrent")) {
                    threadCount = Integer.parseInt(args[++i]);
                    continue;
                }
                if (s.indexOf("--na") == 0) {
                    if (instream == null) {
                        String fmt;
                        if (outfmt == null) {
                            outfmt = "mrv";
                        }
                        if (NucleicAcidRecognizer.canBeDNASequence(args[i + 1])) {
                            fmt = "dna";
                        } else if (NucleicAcidRecognizer.canBeRNASequence(args[i + 1])) {
                            fmt = "rna";
                        } else {
                            throw new MolFormatException("Sequence " + args[i + 1] + " was not recognised either DNA or RNA");
                        }
                        MolConverter.readInputStringFromCommandLine(args[++i], mcbld, fmt);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid option: " + s + " is allowed only " + "in case of command line usage");
                }
                if (s.charAt(0) == '-') {
                    block30: for (int j = 1; j < s.length(); ++j) {
                        char c = s.charAt(j);
                        switch (c) {
                            case 'h': {
                                MolConverter.writeHelpTo(defaultOut, HELP_BASIC);
                                return null;
                            }
                            case 'H': {
                                char c2 = c = ++j < s.length() ? s.charAt(j) : (char)'\u0000';
                                if (c == 'o') {
                                    MolConverter.writeHelpTo(defaultOut, HELP_MOL_FORMATS);
                                } else if (c == 'g') {
                                    MolConverter.writeHelpTo(defaultOut, HELP_GRAPHICS);
                                } else if (c == 'i') {
                                    MolConverter.writeHelpTo(defaultOut, HELP_IMPORT);
                                } else if (c == '3' && s.length() > j + 1 && s.charAt(j + 1) == 'D') {
                                    ++j;
                                    Clean3DIface mm = null;
                                    try {
                                        mm = (Clean3DIface)MarvinModule.load("chemaxon.calculations.clean.Clean3D", null);
                                    }
                                    catch (SecurityException sex) {
                                        throw sex;
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    if (mm != null) {
                                        MolConverter.writeHelpTo(defaultErr, mm.getHelpMessage());
                                    }
                                } else {
                                    MolConverter.writeHelpTo(defaultErr, "No such help topic");
                                    if (outstream == null) {
                                        MolConverter.exit(1);
                                    }
                                }
                                return null;
                            }
                            case 'v': {
                                ++verbose;
                                continue block30;
                            }
                            case 'g': {
                                ignoreError = true;
                                continue block30;
                            }
                            case 'F': {
                                removeSmallFrags = true;
                                continue block30;
                            }
                            case 'Y': {
                                removeH = true;
                                continue block30;
                            }
                            case 's': {
                                if (instream != null) {
                                    throw new IllegalArgumentException("Invalid option: '-s'");
                                }
                                MolConverter.readInputStringFromCommandLine(args[++i], mcbld, null);
                                continue block30;
                            }
                            case '0': {
                                cleanDim = 0;
                                forceCleaning = true;
                                continue block30;
                            }
                            case '2': {
                                cleanDim = 2;
                                forceCleaning = true;
                                if (j >= s.length() - 2 || (c = s.charAt(j + 1)) != ':' && c != '=') continue block30;
                                int f = s.indexOf("F");
                                if (f == -1) {
                                    f = s.length();
                                } else {
                                    cleanFixedAtoms = StringUtil.parseInts(s.substring(f));
                                    int z = 0;
                                    while (z < cleanFixedAtoms.length) {
                                        int n = z++;
                                        cleanFixedAtoms[n] = cleanFixedAtoms[n] - 1;
                                    }
                                    if (s.charAt(f - 1) == ':') {
                                        --f;
                                    }
                                }
                                if (f != j + 1) {
                                    cleanOpts = s.substring(j + 2, f);
                                }
                                j = s.length() - 1;
                                continue block30;
                            }
                            case '3': {
                                cleanOpts = "";
                                cleanDim = 3;
                                forceCleaning = true;
                                if (j >= s.length() - 2 || (c = s.charAt(j + 1)) != ':' && c != '=') continue block30;
                                cleanOpts = s.substring(j + 2);
                                j = s.length() - 1;
                                continue block30;
                            }
                            case 'o': {
                                if (outstream != null) {
                                    throw new IllegalArgumentException("Invalid option: '-o'");
                                }
                                outfname = MolConverter.parseOutFile(args, i + 1, outfname);
                                ++i;
                                continue block30;
                            }
                            case 'c': {
                                StringTokenizer st = new StringTokenizer(args[++i], "&");
                                int condCount = st.countTokens();
                                condNames = new String[condCount];
                                condOPs = new int[condCount];
                                condValues = new String[condCount];
                                MolConverter.parseSDFConditions(st, condNames, condOPs, condValues);
                                continue block30;
                            }
                            case 'T': {
                                incFields = MolConverter.parseFields(args[++i]);
                                continue block30;
                            }
                            case 'I': {
                                molIndexRange = new IntRange(args[++i]);
                                continue block30;
                            }
                            case 'U': {
                                union = true;
                                continue block30;
                            }
                            case 'R': {
                                if (fuseFragsTable == null) {
                                    fuseFragsTable = new Properties();
                                }
                                String key = args[i].substring(j);
                                fuseFragsTable.put(key, args[++i]);
                                j = s.length() - 1;
                                continue block30;
                            }
                            case 'e': {
                                mcbld.setEncodings(args[++i]);
                                continue block30;
                            }
                            case 'm': {
                                mcbld.setOutputFlags(2);
                                continue block30;
                            }
                            default: {
                                MolConverter.writeHelpTo(defaultErr, "Unknown option: -" + c);
                                MolConverter.writeHelpTo(defaultErr, "Use -h for help.");
                                if (outstream != null) continue block30;
                                MolConverter.exit(1);
                            }
                        }
                    }
                    continue;
                }
                if (outfmt == null) {
                    outfmt = s;
                    continue;
                }
                if (outstream != null) {
                    throw new IllegalArgumentException("Not allowed: " + s);
                }
                String[] ss = MFileFormatUtil.splitFileAndOptions(s);
                mcbld.addInput(ss[0], ss[1] == null ? "" : ss[1]);
                try {
                    FileInputStream is = new FileInputStream(ss[0]);
                    ((InputStream)is).close();
                    continue;
                }
                catch (FileNotFoundException ex) {
                    System.err.println(ss[0].concat(": not found"));
                    MolConverter.exit(1);
                    continue;
                }
                catch (IOException ex) {
                    System.err.println(ss[0].concat(": cannot open"));
                    MolConverter.exit(1);
                }
            }
        } else {
            MolConverter.writeHelpTo(defaultOut, HELP_BASIC);
            return null;
        }
        if (outfmt == null) {
            System.err.println("Output format is not specified. Use the \"-h\" option to consult with the help.");
            MolConverter.exit(1);
            return null;
        }
        if (mcbld.getInputCount() == 0) {
            mcbld.addInput(defaultIn, "");
        }
        if (outfmt.equals("query-encoding")) {
            MolConverter.queryEncoding(mcbld.inFiles, mcbld.inputEncoding);
            return null;
        }
        MolConverter mc = null;
        try {
            if (incFields != null && incFields.length > 0 && (outfmt.startsWith("smiles") || outfmt.startsWith("cxsmiles") || outfmt.startsWith("smarts") || outfmt.startsWith("cxsmarts"))) {
                if (!outfmt.contains(":")) {
                    outfmt = outfmt + ":";
                }
                if (!outfmt.endsWith(":")) {
                    outfmt = outfmt + ",";
                }
                outfmt = outfmt + "T";
                for (int i = 0; i < incFields.length; ++i) {
                    outfmt = outfmt + (String)incFields[i] + (i == incFields.length - 1 ? "" : ":");
                }
            }
            if ((outfmt.startsWith("mol") || outfmt.startsWith("rxn") || outfmt.startsWith("sdf") || outfmt.startsWith("rdf") || outfmt.startsWith("rgf") || outfmt.startsWith("csmol") || outfmt.startsWith("csrxn") || outfmt.startsWith("cssdf") || outfmt.startsWith("csrdf") || outfmt.startsWith("csrgf")) && forceCleaning && cleanDim == 0) {
                outfmt = outfmt + ",omitClean0D";
            }
            if (outfname != null) {
                mcbld.setOutput(outfname, outfmt);
            } else {
                mcbld.setOutput(defaultOut, outfmt);
            }
            mcbld.setOutputFlags(1);
            mcbld.setFields(incFields);
            if (forceCleaning) {
                mcbld.clean(cleanDim, cleanOpts);
            }
            mc = new MolConverter(mcbld, removeSmallFrags, removeH, molFieldsToRecords, fuseFragsTable, molIndexRange, union, condNames, condOPs, condValues, cleanFixedAtoms, threadCount, ignoreError, verbose);
            if (verbosityLevel != null) {
                verbosityLevel[0] = verbose;
            }
            return mc;
        }
        catch (NoClassDefFoundError ex) {
            String s = ex.getMessage();
            if (s.startsWith("org/apache/batik/")) {
                System.err.println(ERROR_BATIK_MISSING);
            } else {
                ex.printStackTrace();
            }
            if (outstream == null) {
                MolConverter.exit(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (verbose > 1) {
                ex.printStackTrace();
            } else {
                System.err.println(ex.getMessage());
            }
            if (outstream == null) {
                MolConverter.exit(1);
            }
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        int[] theVerbose = new int[1];
        MolConverter mc = null;
        try {
            mc = MolConverter.createMolConverter(null, null, args, theVerbose);
        }
        catch (IllegalCharsetNameException ex) {
            System.err.println("Illegal input or output encoding name \"" + ex.getCharsetName() + "\"");
            MolConverter.exit(1);
        }
        catch (UnsupportedCharsetException ex) {
            System.err.println("Unsupported input or output encoding \"" + ex.getCharsetName() + "\"");
            MolConverter.exit(1);
        }
        if (mc == null) {
            return;
        }
        long totbytes = mc.sumInputFileLengths();
        int n = 0;
        long t0 = System.currentTimeMillis();
        try {
            while (mc.convert()) {
                long t;
                ++n;
                if (theVerbose[0] <= 0 || (t = System.currentTimeMillis()) - t0 < 1000L) continue;
                if (totbytes > 0L) {
                    int percent = (int)(100L * mc.inBytesRead / totbytes);
                    String spercent = percent < 10 ? "  " + percent : " " + percent;
                    System.err.print(spercent + "% " + n + "\r");
                } else {
                    System.err.print("" + n + "\r");
                }
                t0 += 1000L * ((t - t0) / 1000L);
            }
            OutputStream out = mc.theOptions.outputStream;
            mc.close(out == System.out ? 2 : 1);
        }
        catch (NoClassDefFoundError ex) {
            String s = ex.getMessage();
            if (s.startsWith("org/apache/batik/")) {
                System.err.println(ERROR_BATIK_MISSING);
            } else {
                ex.printStackTrace();
            }
            MolConverter.exit(1);
        }
        catch (IllegalCharsetNameException ex) {
            System.err.println("Illegal encoding name \"" + ex.getCharsetName() + "\"");
            mc.printError(ex, theVerbose[0]);
            MolConverter.exit(1);
        }
        catch (UnsupportedCharsetException ex) {
            System.err.println("Unsupported encoding \"" + ex.getCharsetName() + "\"");
            mc.printError(ex, theVerbose[0]);
            MolConverter.exit(1);
        }
        catch (IOException ex) {
            mc.printError(ex, theVerbose[0]);
            MolConverter.exit(1);
        }
        catch (Throwable ex) {
            mc.printError(ex, theVerbose[0]);
            ex.printStackTrace();
            MolConverter.exit(1);
        }
        if (theVerbose[0] > 0) {
            if (n == 0) {
                System.err.println("no structures found");
            } else {
                System.err.print(n + " molecule");
                if (n > 1) {
                    System.err.print("s");
                }
                System.err.println(" converted");
            }
        }
        MolConverter.exit(0);
    }

    private static void exit(int exitCode) {
        if (!isExitAllowed) {
            throw new RuntimeException("molconvert exit:" + exitCode);
        }
        System.exit(exitCode);
    }

    public static void mainWithoutExit(String[] args) throws IOException {
        isExitAllowed = false;
        MolConverter.main(args);
    }

    private static String parseOutFile(String[] args, int i, String out) {
        if (out == null) {
            String s = args[i];
            return s;
        }
        System.err.println("error: more than one output file specified");
        MolConverter.exit(1);
        return null;
    }

    private static void parseSDFConditions(StringTokenizer st, String[] names, int[] ops, String[] values) {
        int condIndex = 0;
        while (st.hasMoreTokens()) {
            String condString = st.nextToken();
            String OPString = "";
            if (condString.indexOf(">=") > 0) {
                ops[condIndex] = 1;
                OPString = ">=";
            } else if (condString.indexOf("<=") > 0) {
                ops[condIndex] = -1;
                OPString = "<=";
            } else if (condString.indexOf("=") > 0) {
                ops[condIndex] = 0;
                OPString = "=";
            } else if (condString.indexOf(">") > 0) {
                ops[condIndex] = 2;
                OPString = ">";
            } else if (condString.indexOf("<") > 0) {
                ops[condIndex] = -2;
                OPString = "<";
            } else {
                System.err.println("Unknown operator in " + condString);
                MolConverter.exit(1);
            }
            try {
                int index = condString.indexOf(OPString);
                names[condIndex] = condString.substring(0, index);
                values[condIndex] = condString.substring(index + OPString.length());
            }
            catch (Throwable t) {
                System.err.println("Error in condition: " + condString);
            }
            ++condIndex;
        }
    }

    private static String[] parseFields(String line) {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                if (++i < line.length()) {
                    c = line.charAt(i);
                }
                sb.append(c);
                continue;
            }
            if (c == ':') {
                fields.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        fields.add(sb.toString());
        String[] f = new String[fields.size()];
        fields.toArray(f);
        return f;
    }

    private Builder interpretOptions(Builder mcbld) throws IOException {
        Builder builder = mcbld.cloneBuilder();
        if (builder.outputFilename != null && (builder.outputFlags & 2) == 0) {
            this.ownsTheOutputStream = true;
            this.oraf = new RandomAccessFile(builder.outputFilename, "rw");
            this.oraf.setLength(0L);
            FileOutputStream fos = new FileOutputStream(this.oraf.getFD());
            builder.setOutput(fos, builder.formatAndOptions);
        }
        return builder;
    }

    @Deprecated
    public MolConverter(List<Object> inFiles, OutputStream out, String fmtopts, boolean useSysEOL) throws MolFormatException, MolExportException, IOException {
        throw OptionsNotSupported;
    }

    @Deprecated
    public MolConverter(List<Object> inFiles, String ofname, String fmtopts, boolean useSysEOL) throws MolFormatException, MolExportException, IOException {
        throw OptionsNotSupported;
    }

    @Deprecated
    public MolConverter(List<Object> inFiles, List<String> inOptions, String ofname, String fmtopts, boolean useSysEOL) throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
        throw OptionsNotSupported;
    }

    @Deprecated
    public MolConverter(Options opts) throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
        throw OptionsNotSupported;
    }

    @Deprecated
    public MolConverter(List<Object> inFiles, List<String> inOptions, OutputStream out, String fmtopts, boolean useSysEOL) throws MolFormatException, MolExportException, IOException {
        throw OptionsNotSupported;
    }

    @Deprecated
    public MolConverter(List<Object> inFiles, List<String> inOptions, OutputStream out, String fmtopts, boolean useSysEOL, String[] incFields) throws MolFormatException, MolExportException, IOException {
        throw OptionsNotSupported;
    }

    @Deprecated
    public MolConverter(List<Object> inFiles, List<String> inOptions, OutputStream out, String fmtopts, boolean useSysEOL, String[] incFields, String enc) throws MolFormatException, MolExportException, IOException {
        throw OptionsNotSupported;
    }

    @Deprecated
    public static class Options
    extends Builder {
        @Deprecated
        public Options() {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void addInput(File f, String opts) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void addInput(InputStream is, String opts) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void addInput(String fname, String opts) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public MolConverter build() throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public Builder clean(int dim, String opts) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public Builder clean(int dim) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void clear() {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        protected Object clone() {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public int getInputCount() {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void setEncodings(String enc) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void setFields(String[] fields) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void setOutput(File f, String fmtopts) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void setOutput(OutputStream out, String fmtopts) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void setOutput(String fname, String fmtopts) {
            throw OptionsNotSupported;
        }

        @Override
        @Deprecated
        public void setOutputFlags(int outflags) {
            throw OptionsNotSupported;
        }
    }

    private class ConverterErrorProcessor
    implements ErrorProcessor {
        private ConverterErrorProcessor() {
        }

        @Override
        public boolean processError(Throwable error) {
            MolConverter.this.printError(error, MolConverter.this.verbose);
            return true;
        }
    }

    public static class Builder {
        private List<Object> inFiles;
        private List<String> inOptions;
        private OutputStream outputStream;
        private String outputFilename;
        private String formatAndOptions;
        private int outputFlags;
        private String inputEncoding;
        private String outputEncoding;
        private String[] incFields;
        private boolean forceCleaning;
        private int cleanDim;
        private String cleanOpts;

        public Builder() {
            this.clear();
        }

        public MolConverter build() throws MolFormatException, MolExportException, IOException, IllegalArgumentException {
            return new MolConverter(this);
        }

        public void clear() {
            this.inFiles = new ArrayList<Object>();
            this.inOptions = new ArrayList<String>();
            this.outputStream = null;
            this.outputFilename = null;
            this.formatAndOptions = null;
            this.outputFlags = 0;
            this.inputEncoding = null;
            this.outputEncoding = null;
            this.incFields = null;
            this.forceCleaning = false;
            this.cleanDim = 2;
            this.cleanOpts = null;
        }

        public void addInput(InputStream is, String opts) {
            this.inFiles.add(is);
            this.inOptions.add(opts != null ? opts : "");
        }

        public void addInput(File f, String opts) {
            this.inFiles.add(f);
            this.inOptions.add(opts != null ? opts : "");
        }

        public void addInput(String fname, String opts) {
            this.inFiles.add(fname);
            this.inOptions.add(opts != null ? opts : "");
        }

        public int getInputCount() {
            return this.inFiles.size();
        }

        public void setOutput(OutputStream out, String fmtopts) {
            this.outputStream = out;
            this.outputFilename = null;
            this.formatAndOptions = fmtopts;
        }

        public void setOutput(File f, String fmtopts) {
            this.outputStream = null;
            this.outputFilename = f.getPath();
            this.formatAndOptions = fmtopts;
        }

        public void setOutput(String fname, String fmtopts) {
            this.outputStream = null;
            this.outputFilename = fname;
            this.formatAndOptions = fmtopts;
        }

        public void setOutputFlags(int outflags) {
            this.outputFlags |= outflags;
        }

        public void setEncodings(String enc) {
            this.inputEncoding = null;
            this.outputEncoding = null;
            if (enc == null) {
                return;
            }
            int i = enc.indexOf("..");
            if (i >= 0) {
                this.inputEncoding = Encoding.canonicalName(enc.substring(0, i));
                this.outputEncoding = Encoding.canonicalName(enc.substring(i + 2));
            } else {
                this.inputEncoding = Encoding.canonicalName(enc);
            }
        }

        public void setFields(String[] fields) {
            this.incFields = fields;
        }

        public Builder clean(int dim) {
            this.forceCleaning = true;
            this.cleanDim = dim;
            return this;
        }

        public Builder clean(int dim, String opts) {
            this.forceCleaning = true;
            this.cleanDim = dim;
            this.cleanOpts = opts;
            return this;
        }

        protected Object clone() {
            return this.cloneBuilder();
        }

        private Builder cloneBuilder() {
            Builder o = new Builder();
            for (int i = 0; i < this.inFiles.size(); ++i) {
                o.inFiles.add(this.inFiles.get(i));
                o.inOptions.add(this.inOptions.get(i));
            }
            o.outputStream = this.outputStream;
            o.outputFilename = this.outputFilename;
            o.formatAndOptions = this.formatAndOptions;
            o.outputFlags = this.outputFlags;
            o.inputEncoding = this.inputEncoding;
            o.outputEncoding = this.outputEncoding;
            if (this.incFields != null) {
                o.incFields = new String[this.incFields.length];
                System.arraycopy(this.incFields, 0, o.incFields, 0, this.incFields.length);
            }
            o.forceCleaning = this.forceCleaning;
            o.cleanDim = this.cleanDim;
            o.cleanOpts = this.cleanOpts;
            return o;
        }
    }
}

