/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class MolFileHandler {
    public static MRecordReader collectFileInfo(InputStream is, int maxRecords, Vector collectedFields) throws IOException, MRecordParseException {
        return MolFileHandler.collectFileInfo(is, maxRecords, collectedFields, null);
    }

    public static MRecordReader collectFileInfo(InputStream is, int maxRecords, Vector collectedFields, String fileName) throws IOException, MRecordParseException {
        String opts = MFileFormatUtil.getUnguessableFormat(fileName);
        MRecordReader mrr = MFileFormatUtil.createRecordReader(is, opts, null, fileName);
        if (mrr == null) {
            throw new IOException("File format not recognized.");
        }
        MRecord record = null;
        int recordCount = 0;
        while ((record = mrr.nextRecord()) != null) {
            String[] fields = record.getPropertyContainer().getKeys();
            for (int x = 0; x < fields.length; ++x) {
                String fieldName = fields[x].toUpperCase();
                if (collectedFields.contains(fieldName)) continue;
                collectedFields.addElement(fieldName);
            }
            if (++recordCount <= 100 || recordCount <= 100 || recordCount % 10 == 0) {
                // empty if block
            }
            if (maxRecords == 0 || recordCount < maxRecords) continue;
            break;
        }
        return mrr;
    }
}

