/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.recognizer.RecognitionSubsystem;
import chemaxon.marvin.io.PositionedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class MolInputStream
extends PositionedInputStream {
    private String filePath;
    private String fileFormat;
    private static final byte[] CDX_HEADER = new byte[]{86, 106, 67, 68, 48, 49, 48, 48};
    private static final byte[] SKC_HEADER = new byte[]{1, 3, 0, 4};
    private static final byte[] PS_HEADER = new byte[]{37, 33};
    private static final byte[] PDF_HEADER = new byte[]{37, 80, 68, 70};
    private static final byte[] BMP_HEADER = new byte[]{66, 77};
    private static final byte[] JPG_HEADER = new byte[]{-1, -40};
    private static final byte[] PPM_HEADER = new byte[]{80, 51};
    private static final byte[] PPM_HEADER_2 = new byte[]{80, 54};
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] GIF89_HEADER = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] GIF87_HEADER = new byte[]{71, 73, 70, 56, 55, 97};

    public MolInputStream(InputStream is) throws IOException {
        this(is, null, null, null);
    }

    public MolInputStream(InputStream is, String fmt) throws IOException {
        this(is, fmt, null, null);
    }

    public MolInputStream(InputStream is, String fmt, String enc) throws IOException {
        this(is, fmt, enc, null);
    }

    public MolInputStream(InputStream is, String fmt, String enc, String path) throws IOException {
        super(is, 8192, enc, 1024);
        if (fmt == null) {
            this.init(path);
        } else {
            String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(fmt);
            if (fmtopts[1] == null || fmtopts[1].length() == 0) {
                fmt = fmtopts[0];
            }
            this.fileFormat = fmt;
        }
        this.filePath = path;
    }

    private void init(String path) throws IOException {
        MolFormatException ex = null;
        IOException ioex = null;
        try {
            this.initTextFormat(path);
            if (this.fileFormat == null) {
                this.checkBinaryOrImageFormat(path == null ? "" : path);
            }
        }
        catch (IOException e) {
            this.pos = 0;
            this.resetFilePointer();
            this.checkBinaryOrImageFormat(path == null ? "" : path);
            ioex = e;
        }
        if (this.fileFormat == null) {
            ex = new MolFormatException("Cannot read molecule file.", ioex);
            throw ex;
        }
        this.setDesiredBufferSize(this.buf.length);
    }

    private void checkBinaryOrImageFormat(String path) {
        if (this.count >= 22 && this.buf[0] == 31 && this.buf[1] == -117) {
            this.fileFormat = "gzip";
        } else if (this.count >= 4 && this.buf[0] == -84 && this.buf[1] == -19) {
            this.fileFormat = "chemaxon.struc.Molecule";
        } else if (path.endsWith(".vmn") || this.isVMNFormat()) {
            this.fileFormat = "vmn";
        } else if (path.endsWith(".cdx") || this.isHeaderedBinFormat(CDX_HEADER)) {
            this.fileFormat = "cdx";
        } else if (path.endsWith(".skc") || this.isHeaderedBinFormat(SKC_HEADER)) {
            this.fileFormat = "skc";
        } else if (path.endsWith(".ps") || path.endsWith(".pdf") || this.isHeaderedBinFormat(PS_HEADER) || this.isHeaderedBinFormat(PDF_HEADER)) {
            this.fileFormat = "d2s";
        } else if (path.endsWith(".bmp") || path.endsWith(".gif") || this.isHeaderedBinFormat(BMP_HEADER) || this.isHeaderedBinFormat(GIF89_HEADER) || this.isHeaderedBinFormat(GIF87_HEADER)) {
            this.fileFormat = "osraimage";
        } else if (path.endsWith(".jpg") || path.endsWith(".jpeg") || this.isHeaderedBinFormat(JPG_HEADER)) {
            this.fileFormat = "jpeg";
        } else if (path.endsWith(".png") || this.isHeaderedBinFormat(PNG_HEADER)) {
            this.fileFormat = "png";
        } else if (path.endsWith(".ppm") || this.isHeaderedBinFormat(PPM_HEADER) || this.isHeaderedBinFormat(PPM_HEADER_2)) {
            this.fileFormat = "ppm";
        } else if (path.endsWith(".svg") || this.isSvgFormat()) {
            this.fileFormat = "svg";
        }
    }

    private boolean isHeaderedBinFormat(byte[] headerBytes) {
        if (this.count >= headerBytes.length) {
            int i;
            boolean canbe = true;
            for (i = 0; i < headerBytes.length && canbe; ++i) {
                if (headerBytes[i] == this.buf[i]) continue;
                canbe = false;
            }
            return i == headerBytes.length && canbe;
        }
        return false;
    }

    private boolean isSvgFormat() {
        if (this.buf.length < 4) {
            return false;
        }
        boolean foundSvgTag = false;
        for (int i = 3; !foundSvgTag && i < this.buf.length && i < 250; ++i) {
            byte[] arr = new byte[]{this.buf[i - 3], this.buf[i - 2], this.buf[i - 1], this.buf[i]};
            String str = new String(arr);
            if (!str.equalsIgnoreCase("<svg")) continue;
            foundSvgTag = true;
        }
        return foundSvgTag;
    }

    private boolean isVMNFormat() {
        if (this.count < 130) {
            return false;
        }
        if ((this.buf[118] == 0 || this.buf[118] == 1 || this.buf[118] == 2 || this.buf[118] == 3) && this.buf[119] == 0) {
            int n = 120;
            if (this.buf[118] == 2) {
                n += 2;
            }
            if ((this.buf[n] == 78 || this.buf[n] == 89) && this.buf[n + 4] == 0 && this.buf[n + 5] == 0) {
                return true;
            }
        }
        return false;
    }

    private void initTextFormat(String fname) throws IOException {
        int bufsize;
        int i;
        char[] headCharBuff;
        int maxHeadSize;
        byte[] head;
        int c;
        int wlen = 1;
        if (this.encoding != null) {
            wlen = this.encoding.wordLength();
        }
        int prevc = 0;
        this.fileFormat = null;
        int off = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RecognitionSubsystem recog = new RecognitionSubsystem();
        ByteBuffer cByteBuffer = ByteBuffer.allocate(wlen);
        this.setByteOrder(cByteBuffer);
        byte[] cbytes = cByteBuffer.array();
        block0: while ((c = this.bufincRead()) != -1) {
            baos.write(c);
            cbytes[0] = (byte)(c & 0xFF);
            for (int i2 = 1; i2 < wlen; ++i2) {
                c = this.bufincRead();
                if (c == -1) break block0;
                baos.write(c);
                cbytes[i2] = (byte)(c & 0xFF);
            }
            c = this.getWord(cByteBuffer, 0);
            if (c == 13 || c == 10) {
                if (prevc == 13 && c == 10 || prevc == 10 && c == 13) {
                    prevc = 0;
                    continue;
                }
                boolean r = this.processLine(recog, false);
                if (!r) {
                    break;
                }
            } else {
                if (off == 1 && prevc == 31 && c == 139) {
                    this.fileFormat = "gzip";
                    break;
                }
                if (off == 1 && prevc == 172 && c == 237) {
                    this.fileFormat = "chemaxon.struc.Molecule";
                    break;
                }
                byte[] lineBuf = this.lineByteBuffer.array();
                if (wlen * this.lineCurrentColumn >= lineBuf.length) {
                    byte[] b = new byte[lineBuf.length << 1];
                    System.arraycopy(lineBuf, 0, b, 0, wlen * this.lineCurrentColumn);
                    lineBuf = b;
                    this.lineByteBuffer = ByteBuffer.wrap(b);
                    this.setByteOrder(this.lineByteBuffer);
                }
                this.setWord(this.lineByteBuffer, wlen * this.lineCurrentColumn, c);
                ++this.lineCurrentColumn;
            }
            prevc = c;
            ++off;
        }
        if ((head = baos.toByteArray()).length > (maxHeadSize = 20)) {
            headCharBuff = new char[maxHeadSize];
            for (i = 0; i < headCharBuff.length; ++i) {
                headCharBuff[i] = (char)(head[i] & 0xFF);
            }
        } else {
            headCharBuff = new char[head.length];
            for (i = 0; i < headCharBuff.length; ++i) {
                headCharBuff[i] = (char)(head[i] & 0xFF);
            }
        }
        if (recog.getNumProcessedLines() == 0 || c == -1) {
            this.processLine(recog, c == -1);
        }
        if (this.fileFormat == null) {
            this.fileFormat = recog.getFormat(fname);
        }
        if (head.length == 0) {
            this.fileFormat = MFileFormatUtil.getMostLikelyMolFormat(fname);
            if (this.fileFormat != null) {
                return;
            }
            throw new IOException("Cannot read empty molecule file");
        }
        int total = head.length + this.count - this.pos;
        for (bufsize = this.buf.length; bufsize < total; bufsize <<= 1) {
        }
        if (bufsize != this.buf.length) {
            this.buf = new byte[bufsize];
        }
        System.arraycopy(this.buf, this.pos, this.buf, head.length, this.count - this.pos);
        System.arraycopy(head, 0, this.buf, 0, head.length);
        this.count = total;
        this.pos = 0;
        this.resetFilePointer();
    }

    private boolean processLine(RecognitionSubsystem recog, boolean last) throws UnsupportedEncodingException, MolFormatException {
        byte[] lineBuf = this.lineByteBuffer.array();
        String s = this.encoding != null ? this.encoding.convert(lineBuf, 0, this.encoding.wordLength() * this.lineCurrentColumn) : new String(lineBuf, 0, this.lineCurrentColumn);
        this.lineCurrentColumn = 0;
        return recog.processLine(s, last);
    }

    public String getFormat() {
        return this.fileFormat;
    }

    public void setFormat(String fmt) {
        this.fileFormat = fmt;
    }

    public String getPath() {
        return this.filePath;
    }
}

