/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;

public class ChimeRecognizer
extends Recognizer {
    private boolean needsMore = true;
    private static final boolean[] CAN_BE_IN_CHIME;

    public ChimeRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (ChimeRecognizer.canBeChime(line)) {
            boolean bl = this.needsMore = linenum < 2;
            if (linenum >= 2) {
                reclist.remove("chime");
            }
        } else {
            reclist.remove("chime");
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean canBeChime(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c < CAN_BE_IN_CHIME.length && CAN_BE_IN_CHIME[c]) continue;
            return false;
        }
        return true;
    }

    static {
        boolean[] inChime = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            if (i == 36 || i == 94 || i >= 48 && i <= 57 || i >= 97 && i <= 122 || i >= 65 && i <= 90) {
                inChime[i] = true;
            }
            if (i != 10 && i != 13) continue;
            inChime[i] = true;
        }
        CAN_BE_IN_CHIME = inChime;
    }
}

