/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;

public class InchiRecognizer
extends Recognizer {
    private boolean needsMore = true;

    public InchiRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (InchiRecognizer.isInchiLine(line)) {
            reclist.removeAllExcept("inchi");
            this.needsMore = false;
        } else if (!line.startsWith("AuxInfo=")) {
            reclist.remove("inchi");
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean isInchiLine(String s) {
        if (s.length() > 6) {
            return s.startsWith("InChI=") && Character.isDigit(s.charAt(6));
        }
        return false;
    }
}

