/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;

public class JTFRecognizer
extends Recognizer {
    private boolean needsMore = true;

    public JTFRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (linenum == 1) {
            if (JTFRecognizer.canBeJTFHeader(line)) {
                reclist.removeAllExcept("jtf");
            } else {
                reclist.remove("jtf");
            }
        }
        this.needsMore = false;
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean canBeJTFHeader(String line) {
        String[] fields = MFileFormatUtil.getJTFFields(line);
        if (fields == null) {
            return false;
        }
        for (int x = 0; x < fields.length; ++x) {
            String fieldName = fields[x];
            if (fieldName == null) {
                return false;
            }
            if (!fieldName.toUpperCase().equals("CD_STRUCTURE")) continue;
            return true;
        }
        return false;
    }
}

