/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.formats.recognizer.RecognizerUtil;

public class MDLRecognizer
extends Recognizer {
    private String format;
    private boolean needsMore = true;
    private boolean rxnfile = false;
    private boolean rgfile = false;
    private boolean line4IsMDLCounts = false;

    public MDLRecognizer(String fmt) {
        this.format = fmt;
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (linenum == 1) {
            this.line4IsMDLCounts = false;
        }
        if (linenum == 4 && MDLRecognizer.isMDLCountsLine(line)) {
            this.line4IsMDLCounts = true;
        }
        if (this.isLastLine()) {
            if (this.format.equals("mol") || this.format.equals("csmol") || this.format.equals("csmdl")) {
                if (linenum < 5 || !this.line4IsMDLCounts) {
                    reclist.remove(this.format);
                    return;
                }
            } else if (this.format.equals("mol:V3")) {
                if (linenum < 10 || !this.line4IsMDLCounts) {
                    reclist.remove(this.format);
                    return;
                }
            } else if (this.format.equals("sdf") || this.format.equals("cssdf")) {
                if (linenum < 6 || !this.line4IsMDLCounts) {
                    reclist.remove(this.format);
                    return;
                }
            } else if (this.format.equals("sdf:V3") || this.format.equals("cssdf")) {
                if (linenum < 11 || !this.line4IsMDLCounts) {
                    reclist.remove(this.format);
                    return;
                }
            } else if (this.format.equals("rgf") || this.format.equals("csrgf")) {
                if (linenum < 11) {
                    reclist.remove(this.format);
                    return;
                }
            } else if (this.format.equals("rxn") || this.format.equals("csrxn")) {
                if (linenum < 17) {
                    reclist.remove(this.format);
                    return;
                }
            } else if (this.format.equals("rxn:V3") && linenum < 20) {
                reclist.remove(this.format);
                return;
            }
        }
        if (linenum == 1) {
            int l = line.length();
            if (line.startsWith("$RXN V3000")) {
                reclist.removeAllExcept("rxn:V3");
                this.rxnfile = true;
                this.noMoreNeeded();
            } else if (line.startsWith("$RXN")) {
                reclist.removeAllExcept("rxn");
                this.rxnfile = true;
                this.noMoreNeeded();
            } else if (this.format.equals("rxn") || this.format.equals("rxn:V3") || this.format.equals("csrxn")) {
                reclist.remove("rxn");
                reclist.remove("rxn:V3");
                reclist.remove("csrxn");
                this.noMoreNeeded();
            }
            if (l >= 8 && line.substring(0, 8).equals("$MDL REV") || l >= 9 && line.substring(0, 9).equals("$MDL  REV")) {
                reclist.removeAllExcept("rgf csrgf");
                this.rgfile = true;
                this.noMoreNeeded();
            } else {
                reclist.remove("rgf");
                reclist.remove("csrgf");
            }
            if (MDLRecognizer.canBeSDFLine(line) && (this.format.equals("sdf") || this.format.equals("cssdf"))) {
                reclist.removeAllExcept("sdf cssdf");
                this.noMoreNeeded();
            }
        } else if (linenum == 4) {
            if (!this.rxnfile && !this.rgfile && (this.format.equals("mol") || this.format.equals("mol:V3") || this.format.equals("csmol") || this.format.equals("sdf") || this.format.equals("sdf:V3") || this.format.equals("cssdf"))) {
                if (this.line4IsMDLCounts) {
                    if (MDLRecognizer.isMDLV3CountsLine(line)) {
                        reclist.remove("mol");
                        reclist.remove("sdf");
                        reclist.remove("csmol");
                        reclist.remove("csmdl");
                        reclist.remove("cssdf");
                    } else {
                        reclist.remove("mol:V3");
                        reclist.remove("sdf:V3");
                    }
                } else {
                    reclist.remove("mol");
                    reclist.remove("mol:V3");
                    reclist.remove("csmol");
                    reclist.remove("csmdl");
                    reclist.remove("sdf");
                    reclist.remove("sdf:V3");
                    reclist.remove("cssdf");
                    this.noMoreNeeded();
                }
            }
        } else if (!(this.rxnfile || this.rgfile || linenum != 5 || line.length() != 10 && line.length() != 14 || !this.format.equals("csmol") && !this.format.equals("cssdf"))) {
            reclist.removeAllExcept("csmol cssdf");
            this.noMoreNeeded();
        }
        if (line.equals("$$$$") && (this.format.equals("sdf") || this.format.equals("cssdf"))) {
            reclist.removeAllExcept("sdf cssdf");
            this.noMoreNeeded();
        }
        if (linenum > 12) {
            this.noMoreNeeded();
            reclist.removeAllExcept("mol mol:V3 csmol csmdl sdf sdf:V3 cssdf rxn rxn:V3 csrxn rgf csrgf csmdl");
        }
    }

    private void noMoreNeeded() {
        this.needsMore = false;
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    static boolean isMDLCountsLine(String s) {
        int align2;
        int align1;
        return s.length() >= 6 && ((align1 = RecognizerUtil.checkPositiveInteger(s, 0, 3)) & (align2 = RecognizerUtil.checkPositiveInteger(s, 3, 3))) != 0;
    }

    private static boolean isMDLV3CountsLine(String s) {
        return s.length() >= 39 && s.substring(34, 39).equals("V3000");
    }

    private static boolean canBeSDFLine(String s) {
        char c0;
        if (s.startsWith(">  <") && Character.isLetter(c0 = s.charAt(4))) {
            int i;
            for (i = 5; i < s.length(); ++i) {
                boolean valid;
                char c = s.charAt(i);
                boolean bl = valid = Character.isLetterOrDigit(c) || c != '_' || c == '.' || c == '-';
                if (valid) continue;
                if (c == '>') break;
                return false;
            }
            return i >= s.length() - 1 || s.charAt(i + 1) == ' ';
        }
        return false;
    }
}

