/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.formats.recognizer.SMILESRecognizer;
import chemaxon.naming.n2s.CASNumberConverter;
import chemaxon.naming.n2s.Dictionary;
import chemaxon.naming.n2s.Standardize;
import chemaxon.naming.n2s.lex.NameLexer;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.RevolutionParser;
import java.util.ArrayList;

public class NameRecognizer
extends Recognizer {
    private static final int NOT_NAME = 0;
    private static final int MAYBE_NAME = 1;
    private static final int SURELY_NAME = 2;
    private int sureNames = 0;

    public NameRecognizer(String fmt) {
    }

    @Override
    public boolean needsMore() {
        return this.sureNames == 0;
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        int res = NameRecognizer.isNameLine(line, this.isLastLine());
        if (res == 2) {
            ++this.sureNames;
        }
        if (this.recognitionFailed(res, linenum)) {
            reclist.remove("name");
        }
    }

    private boolean recognitionFailed(int res, int linenum) {
        if (res == 0) {
            return true;
        }
        if (linenum >= 5 && this.sureNames == 0) {
            return true;
        }
        if (linenum > 10 && this.sureNames <= 1) {
            return true;
        }
        return this.isLastLine() && this.sureNames < Math.min(linenum, 2);
    }

    private static int isNameLine(String line, boolean isLastLine) {
        if (line.length() == 0) {
            if (isLastLine) {
                return 2;
            }
            return 1;
        }
        int tab = line.indexOf(9);
        if (tab != -1 && (line = line.substring(0, tab).trim()).length() == 0) {
            return 0;
        }
        String[] names = line.split(";");
        int i = names.length;
        while (--i >= 0) {
            int isName = NameRecognizer.evaluateName(names[i]);
            if (isName != 0 && isName != 2) continue;
            return isName;
        }
        return 1;
    }

    public static boolean isName(String name) {
        return NameRecognizer.evaluateName(name) == 2;
    }

    private static int evaluateName(String name) {
        if (!NameRecognizer.canBeName(name)) {
            return 0;
        }
        if (NameRecognizer.isSurelyName(name)) {
            return 2;
        }
        return 1;
    }

    private static boolean canBeName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (NameRecognizer.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNameChar(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        return " -+()[]{},.:?$^'\u2032\"\n\u200b".indexOf(c) != -1;
    }

    public static boolean isSurelyName(String name) {
        if (name.length() == 0) {
            return true;
        }
        if (NameRecognizer.noNeedToTry(name)) {
            return false;
        }
        if (CASNumberConverter.isCASNumber(name)) {
            return true;
        }
        name = Standardize.get(name);
        try {
            ArrayList<Token> tokens = NameLexer.parse(name, false);
            new RevolutionParser().parse(tokens, false);
            return true;
        }
        catch (Exception exception) {
            if (Dictionary.getTraditionalDict().find(name) != null) {
                return true;
            }
            return Dictionary.getUserDict().find(name) != null;
        }
    }

    static boolean noNeedToTry(String line) {
        if (line == null) {
            return true;
        }
        if (SMILESRecognizer.canBeSMILES(line)) {
            return true;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '<') {
            return true;
        }
        return line.startsWith("  Marvin");
    }
}

