/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.util.StringUtil;

public class NucleicAcidRecognizer
extends Recognizer {
    private boolean needsMore = true;
    private String format;

    public NucleicAcidRecognizer(String fmt) {
        this.format = fmt;
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (this.format.equals("rna")) {
            if (!NucleicAcidRecognizer.canBeRNASequence(line)) {
                reclist.remove(this.format);
                this.needsMore = false;
            }
        } else if (this.format.equals("dna") && !NucleicAcidRecognizer.canBeDNASequence(line)) {
            reclist.remove(this.format);
            this.needsMore = false;
        }
        if (linenum > 5) {
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean canBeDNASequence(String line) {
        String[] dnaTokens = new String[]{"dT", "dA", "dC", "dG"};
        for (int i = 0; i < dnaTokens.length && line.length() > 0; ++i) {
            line = StringUtil.replaceAll(line, dnaTokens[i], "");
        }
        return line.length() == 0;
    }

    public static boolean canBeRNASequence(String line) {
        String[] rnaTokens = new String[]{"U", "A", "C", "G"};
        for (int i = 0; i < rnaTokens.length && line.length() > 0; ++i) {
            line = StringUtil.replaceAll(line, rnaTokens[i], "");
        }
        return line.length() == 0;
    }
}

