/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;

public class RDfileRecognizer
extends Recognizer {
    private boolean needsMore = true;
    private String format;

    public RDfileRecognizer(String fmt) {
        this.format = fmt;
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (linenum == 1) {
            int l = line.length();
            if (l < 8 || !line.startsWith("$RDFILE ")) {
                reclist.remove("rdf");
                reclist.remove("csrdf");
                this.needsMore = false;
            }
        } else if (linenum >= 8) {
            if (line.length() == 10 || line.length() == 14) {
                reclist.removeAllExcept("csrdf");
            } else {
                reclist.removeAllExcept("rdf csrdf");
            }
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    @Override
    public int getPriority() {
        return this.format.equals("rdf") ? 10 : 11;
    }
}

