/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import java.util.ArrayList;
import java.util.List;

public class RecognitionSubsystem {
    private RecognizerList importableList;
    private RecognizerList recognizerList;
    private List<String> lineList;
    private int[] linenums;
    private StringBuffer textFileHead;
    private boolean lastLineReached = false;

    public RecognitionSubsystem() throws MolFormatException {
        this(MFileFormatUtil.findFormats(null, 4L, 4L));
    }

    public RecognitionSubsystem(MFileFormat[] formats_to_recognize) throws MolFormatException {
        MFileFormat[] mff = MFileFormatUtil.findFormats(null, 2L, 2L);
        this.importableList = new RecognizerList(mff);
        this.recognizerList = new RecognizerList(formats_to_recognize);
        int nlevels = this.recognizerList.getLevelCount();
        if (this.importableList.getLevelCount() > nlevels) {
            nlevels = this.importableList.getLevelCount();
        }
        this.linenums = new int[nlevels];
        this.lineList = new ArrayList<String>();
        for (int i = 0; i < nlevels; ++i) {
            this.linenums[i] = 0;
        }
        this.textFileHead = new StringBuffer();
    }

    public int getNumProcessedLines() {
        return this.lineList.size();
    }

    public boolean processLine(String line, boolean last) throws MolFormatException {
        this.lineList.add(line);
        if (!last || line.length() != 0) {
            if (this.lineList.size() > 1) {
                this.textFileHead.append('\n');
            }
            this.textFileHead.append(line);
        }
        boolean needsmore = this.processLine(line, last, 0);
        for (int level = 1; level < this.recognizerList.getLevelCount() && !needsmore; ++level) {
            if (this.recognizerList.size(level) == 0) continue;
            if (!this.recognizerList.isLevelMade(level)) {
                this.recognizerList.makeLevel(level);
            }
            for (int i = this.linenums[level]; i < this.lineList.size(); ++i) {
                boolean ret = this.processLine(this.lineList.get(i), last && i == this.lineList.size() - 1, level);
                if (i != this.lineList.size() - 1) continue;
                needsmore |= ret;
            }
        }
        if (last) {
            if (this.recognizerList.size() != 1) {
                this.recognizerList.removeAllExcept("abbrevgroup smiles smarts name mol mol:V3 peptide peptide:1 peptide:3");
            }
            this.lastLineReached = true;
        }
        return this.recognizerList.size() != 1 && needsmore;
    }

    private boolean processLine(String line, boolean last, int level) {
        Recognizer r;
        int i;
        int n = level;
        this.linenums[n] = this.linenums[n] + 1;
        for (i = this.recognizerList.size(level) - 1; i >= 0; --i) {
            r = this.recognizerList.getRecognizer(level, i);
            if (r.getLastProcessedLineNum() >= this.linenums[level]) continue;
            if (last) {
                r.setLastLine();
            }
            r.tryToRecognize(line, this.linenums[level], this.recognizerList);
            r.setLastProcessedLineNum(this.linenums[level]);
            if (i <= this.recognizerList.size(level)) continue;
            i = this.recognizerList.size(level);
        }
        for (i = this.recognizerList.size(level) - 1; i >= 0; --i) {
            r = this.recognizerList.getRecognizer(level, i);
            if (!r.needsMore()) continue;
            return true;
        }
        return false;
    }

    public String getFormat(String fname) throws MolFormatException {
        Object format2 = null;
        RecognizerList r = this.recognizerList;
        if (r.size() == 1) {
            String fmt = r.getName(0);
            return fmt;
        }
        if (fname != null) {
            r = this.importableList.selectByExtension(fname);
            if (r.size() == 1) {
                String fmt = r.getName(0);
                return fmt;
            }
            r = r.size() == 0 ? this.recognizerList : this.recognizerList.selectByExtension(fname);
        }
        if ((r = r.selectHighestPriority()).size() == 1) {
            String fmt = r.getName(0);
            return fmt;
        }
        String possiblefmts = r.toString();
        if (fname != null) {
            throw new MolFormatException(fname + ": Cannot recognize format (" + possiblefmts + "?)");
        }
        StringBuffer sb = new StringBuffer("Cannot recognize format (");
        sb.append(possiblefmts.toString());
        sb.append("?)");
        if (this.textFileHead.length() != 0) {
            sb.append("\nUnrecognized file contents:\n");
            if (this.textFileHead.length() > 256) {
                sb.append(this.textFileHead.substring(0, 253));
                sb.append("...");
            } else {
                sb.append(this.textFileHead.toString());
            }
            if (!this.lastLineReached) {
                sb.append("\n...");
            }
        }
        throw new MolFormatException(sb.toString());
    }
}

