/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import java.util.regex.Pattern;

public class SMILESRecognizer
extends Recognizer {
    private static final boolean[] CAN_BE_IN_BRACKETLESS_SMARTS;
    private boolean needsMore = true;
    private int numCommentLines = 0;
    private static Pattern pipePattern;
    private String format;

    public SMILESRecognizer(String fmt) {
        this.format = fmt;
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (line.length() == 0 || SMILESRecognizer.isComment(line)) {
            return;
        }
        if (SMILESRecognizer.isCxSMILESLine(line)) {
            reclist.removeAllExcept("cxsmiles");
            return;
        }
        if (SMILESRecognizer.isComment(line)) {
            ++this.numCommentLines;
        }
        if (this.format.equals("smiles") || this.format.equals("cxsmiles")) {
            if (!SMILESRecognizer.canBeSMILES(line)) {
                reclist.remove("smiles");
                reclist.remove("cxsmiles");
                this.needsMore = false;
            }
        } else if ((this.format.equals("smarts") || this.format.equals("cxsmarts")) && !SMILESRecognizer.canBeSMARTS(line)) {
            reclist.remove("smarts");
            reclist.remove("cxsmarts");
            this.needsMore = false;
        }
        if (linenum - this.numCommentLines > 5) {
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean canBeSMILES(String s) {
        if (SMILESRecognizer.isComment(s)) {
            return true;
        }
        if (SMILESRecognizer.canBeSMARTS(s)) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t') {
                    return true;
                }
                if ("~,$&!;".indexOf(c) < 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canBeSMARTS(String s) {
        char first;
        if (SMILESRecognizer.isComment(s)) {
            return true;
        }
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t') continue;
            s = s.substring(0, i);
            break;
        }
        if (s.endsWith(",")) {
            return false;
        }
        int dollar = s.indexOf(36);
        if (dollar >= 0) {
            return dollar < s.length() - 1 && s.charAt(dollar + 1) == '(';
        }
        if (s.length() > 0 && (first = s.charAt(0)) >= '0' && first <= '9') {
            return false;
        }
        if (SMILESRecognizer.isInteger(s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '[') {
                int b2 = s.indexOf(93, i + 1);
                int b3 = s.indexOf(91, i + 1);
                if (b2 < 0 || b3 >= 0 && b3 < b2) {
                    return false;
                }
                s = s.substring(0, i).concat(s.substring(b2 + 1));
                --i;
                continue;
            }
            if (c != ']') continue;
            return false;
        }
        int irxn1 = s.indexOf(62);
        int irxn2 = s.indexOf(62, irxn1 + 1);
        int irxn3 = s.indexOf(62, irxn2 + 1);
        if (irxn1 >= 0 && irxn2 >= 0 && irxn3 < 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '>') continue;
                if (c == '+') {
                    c = '.';
                }
                sb.append(c);
            }
            s = sb.toString();
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c >= '\u0000' && c < CAN_BE_IN_BRACKETLESS_SMARTS.length && CAN_BE_IN_BRACKETLESS_SMARTS[c] || c == 'H' && SMILESRecognizer.canBeSMILESWithBadHydrogenAt(s, i))) {
                return false;
            }
            if ("rl".indexOf(c) < 0) continue;
            if (i == 0) {
                return false;
            }
            char cc = s.charAt(i - 1);
            if ((cc == 'B' || c != 'r') && (cc == 'C' || c != 'l')) continue;
            return false;
        }
        return true;
    }

    public static boolean isComment(String s) {
        return s.startsWith("#");
    }

    private static boolean canBeSMILESWithBadHydrogenAt(String s, int i) {
        if (s.charAt(i) != 'H' || i == 0) {
            return false;
        }
        if (i < s.length() - 1) {
            if (s.charAt(i - 1) == '(' && s.charAt(i + 1) == ')') {
                return true;
            }
            if (s.charAt(i - 1) == ')' && s.charAt(i - 1) == '.') {
                return true;
            }
        }
        return i == s.length() - 1 && s.charAt(i - 1) == ')';
    }

    private static boolean isInteger(String line) {
        String s = line.trim();
        if (s.startsWith("-") || s.startsWith("+")) {
            s = s.substring(1);
        }
        if (s.length() != 0) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isCxSMILESLine(String s) {
        if (pipePattern == null) {
            pipePattern = Pattern.compile("[^<][^\\|]*\\s\\|.*\\|(\\s[^\\|]*|$)");
        }
        return pipePattern.matcher(s).matches();
    }

    static {
        pipePattern = null;
        boolean[] inBlSMARTS = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            if ("aAbBrcClnNoOpPsSIF0123456789.%\\/-=#:~!@?;()*,&".indexOf(i) >= 0) {
                inBlSMARTS[i] = true;
            }
            if (i != 10 && i != 13) continue;
            inBlSMARTS[i] = true;
        }
        CAN_BE_IN_BRACKETLESS_SMARTS = inBlSMARTS;
    }
}

