/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.struc.MolAtom;

public class XYZRecognizer
extends Recognizer {
    private boolean needsMore = true;
    private int atomCount;
    private boolean line1Comment = false;
    private int firstLineInRecord = 1;

    public XYZRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (this.isLastLine() && linenum < 2) {
            reclist.remove("xyz");
        }
        if (linenum == 1 && line.startsWith("#")) {
            this.line1Comment = true;
            ++this.firstLineInRecord;
            return;
        }
        if ((linenum -= this.firstLineInRecord - 1) == this.atomCount + 3) {
            this.firstLineInRecord += this.atomCount + 2;
            linenum -= this.atomCount + 2;
        }
        if (linenum == 1) {
            if (XYZRecognizer.isXYZCountLine(line)) {
                this.atomCount = Integer.parseInt(line.trim());
            } else if (!XYZRecognizer.isXYZAtomLine(line)) {
                reclist.remove("xyz");
                this.needsMore = false;
            }
        } else if (linenum >= 3) {
            if (XYZRecognizer.isXYZAtomLine(line)) {
                reclist.removeAllExcept("xyz");
            } else {
                reclist.remove("xyz");
            }
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean isXYZCountLine(String line) {
        try {
            int n = Integer.parseInt(line.trim());
            return n > 0;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isXYZAtomLine(String line) {
        char c;
        int i = XYZRecognizer.findNonWS(line, 0);
        if (i < 0) {
            return false;
        }
        int j = i;
        for (j = i + 1; j < line.length() && (c = line.charAt(j)) >= 'a' && c <= 'z'; ++j) {
        }
        if (i < line.length()) {
            String s = line.substring(i, i + 1).toUpperCase() + line.substring(i + 1, j);
            int atno = MolAtom.numOf(s);
            if (atno == 0) {
                return false;
            }
        } else {
            return false;
        }
        return XYZRecognizer.findReals(line, j = XYZRecognizer.findWS(line, j), 3) >= 0;
    }

    protected static int findReals(String s, int i, int count) {
        int j = i;
        for (int k = 0; k < count; ++k) {
            i = XYZRecognizer.findNonWS(s, j);
            if (i < 0) {
                return -1;
            }
            j = XYZRecognizer.findWS(s, i);
            String r = s.substring(i, j);
            try {
                Double.valueOf(r);
                continue;
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return j;
    }

    protected static int findWS(String s, int i) {
        for (int j = i; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
            return j;
        }
        return s.length();
    }

    protected static int findNonWS(String s, int i) {
        for (int j = i; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == ' ' || c == '\t') continue;
            return j;
        }
        return -1;
    }
}

