/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.fragmenter.CutBondReviser;
import chemaxon.fragmenter.ExhaustiveFragmenter;
import chemaxon.fragmenter.FragmenterConfig;
import chemaxon.fragmenter.GreedyFragmenter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public abstract class Fragmenter
implements Licensable {
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = lineSep + "Fragmenter " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Fragments molecules by predefined cleaving transformations." + lineSep + "Usage:" + lineSep + "  fragment -c <config file> [options] [input files/strings]" + lineSep + lineSep + "General options: " + lineSep + "  -h, --help                          this help message" + lineSep + "  -c, --config <filepath>             configuration XML file" + lineSep + "  -x, --fragment-count <count>        the maximum number of fragments" + lineSep + "                                      per fragment set (default: unlimited)" + lineSep + "  -y, --set-count <count>             the maximum number of fragment sets" + lineSep + "                                      per molecule (default: unlimited)" + lineSep + "  -e, --extensive                     include extendable cut sets" + lineSep + "  -i, --id <SDF tag>                  SDFile tag that stores the molecule ID" + lineSep + "                                      (default ID: the molecule index)" + lineSep + "  -s, --statistics <SDF tag>          SDFile tag that stores data used later" + lineSep + "                                      for making statistics (default: none)" + lineSep + "  -g, --ignore-error                  continue with next molecule on error" + lineSep + lineSep + "Output options: " + lineSep + "  -f, --format <format>               output file format (default: cxsmiles)" + lineSep + "  -o, --output <filepath>             output file path (default: stdout)" + lineSep + "  -k, --skip-unfragmented             skip unfragmented molecules in output" + lineSep + "  -d, --data <N|L|I|LI>               fragment cut-data:" + lineSep + "                                      N:  no data stored" + lineSep + "                                      L:  in atom labels" + lineSep + "                                      I:  in fragment ID" + lineSep + "                                      LI: in both atom labels and fragment ID" + lineSep + "                                      (default: LI)" + lineSep + "  -p, --attachment-point <N|S|A>      fragment attachment points:" + lineSep + "                                      N:  no marker atoms" + lineSep + "                                      S:  denoted by any-atom (star) markers" + lineSep + "                                      A:  denoted by Al and Ar atom markers" + lineSep + "                                          (Al: aliphatic, Ar: aromatic)" + lineSep + "                                      (default: N)" + lineSep + lineSep + "Examples:" + lineSep + "  fragment -c Fragmenter.xml in.sdf -x 3 -f sdf -o out.sdf" + lineSep + "  fragment -c Fragmenter.xml in.sdf -s DATA -o out.cxsmiles" + lineSep;
    static final int ATNO_AL = 13;
    static final int ATNO_AR = 18;
    public static final int ATTACH_NONE = 0;
    public static final int ATTACH_ANY_ATOM = 1;
    public static final int ATTACH_AL_AR = 2;
    private int attachmentPointType = 0;
    private static final String DEF_SOURCETAG = "SOURCE";
    private static final int MAXMAPS = 1024;
    private static final int MSHIFT = 10;
    private static final int MMASK = 1023;
    protected String licenseEnvironment = "";
    protected CutBondSearch[] cbs = null;
    protected CutBondReviser reviser = null;
    protected BondClassifier classifier = new BondClassifier();
    private IntArrayComparator comparator = new IntArrayComparator();
    private Standardizer standardizer = null;
    private int[] cutbond = null;
    private int[] cutbondmaps = null;
    private Hashtable<MolAtom, ArrayList<int[]>> cutdata = null;
    protected int maxfragmentcount = Integer.MAX_VALUE;
    private String uidTag = null;
    private String cutidsTag = null;
    private String cutcountsTag = null;
    private String cutsumTag = null;
    private String countTag = null;
    protected String fragmentsetsTag = null;
    private boolean dataInLabel = false;
    private int molCount = 0;

    public static String getData(Molecule fragment, int index) {
        String alias = fragment.getAtom(index).getAliasstr();
        if (alias == null) {
            return "";
        }
        int i = alias.indexOf("_{");
        if (i == -1) {
            return "";
        }
        int j = alias.indexOf("}", i += 2);
        if (j == -1) {
            return "";
        }
        return alias.substring(i, j);
    }

    public Fragmenter() {
    }

    public Fragmenter(RxnMolecule[] reactions) throws SearchException {
        this(reactions, null, null);
    }

    public Fragmenter(RxnMolecule[] reactions, Standardizer standardizer) throws SearchException {
        this(reactions, standardizer, null);
    }

    public Fragmenter(RxnMolecule[] reactions, Standardizer standardizer, CutBondReviser reviser) throws SearchException {
        this.init(reactions, standardizer, reviser);
    }

    protected void init(RxnMolecule[] reactions, Standardizer standardizer, CutBondReviser reviser) throws SearchException {
        this.cbs = this.createCBS(reactions);
        this.standardizer = standardizer;
        this.reviser = reviser != null ? reviser : new CutBondReviser();
        this.reviser.setFragmenter(this);
        this.alloc(64);
    }

    protected BondClassifier getClassifier() {
        return this.classifier;
    }

    public void setMaxFragmentCount(int maxfragmentcount) {
        this.maxfragmentcount = maxfragmentcount;
    }

    public void setCountTag(String countTag) {
        this.countTag = countTag;
    }

    public void setFragmentSetsTag(String fragmentsetsTag) {
        this.fragmentsetsTag = fragmentsetsTag;
    }

    public void setDataInLabel(boolean dataInLabel) {
        this.dataInLabel = dataInLabel;
    }

    public void setAttachmentPointType(int attachmentPointType) {
        this.attachmentPointType = attachmentPointType;
    }

    public void collect(String uidTag, String cutidsTag, String cutcountsTag, String cutsumTag, String[] reactionIDs) {
        this.uidTag = uidTag;
        this.cutidsTag = cutidsTag;
        this.cutcountsTag = cutcountsTag;
        this.cutsumTag = cutsumTag;
        for (int i = 0; i < reactionIDs.length; ++i) {
            this.cbs[i].reactionID = reactionIDs[i];
        }
        this.cutdata = new Hashtable();
    }

    public void collect(String uidTag, String cutidsTag, String cutcountsTag, String cutsumTag, String[] reactionIDs, boolean dataInLabel) {
        this.collect(uidTag, cutidsTag, cutcountsTag, cutsumTag, reactionIDs);
        this.dataInLabel = dataInLabel;
    }

    public void find(Molecule mol) throws SearchException, LicenseException {
        this.checkLicense();
        if (this.standardizer != null) {
            this.standardizer.standardize(mol);
        }
        this.classifier.classify(mol);
        this.reviser.setMolecule(mol);
        this.alloc(mol.getAtomCount());
        for (int i = 0; i < this.cbs.length; ++i) {
            this.cbs[i].searcher.setTarget(mol);
        }
        this.find();
    }

    protected abstract void find() throws SearchException;

    public void create(List coll) {
        Molecule mol = (Molecule)this.reviser.getMolecule().clone();
        ArrayList attachAtomList = null;
        ArrayList attachBondList = null;
        if (this.attachmentPointType != 0) {
            attachAtomList = new ArrayList();
            attachBondList = new ArrayList();
        }
        for (int j = mol.getBondCount() - 1; j >= 0; --j) {
            int i2;
            MolBond b = mol.getBond(j);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int i1 = mol.indexOf(a1);
            int i = this.getCutBond(i1, i2 = mol.indexOf(a2));
            if (i == -1) continue;
            int m1 = 0;
            int m2 = 0;
            if (this.cutdata != null) {
                int m = this.getCutBondMaps(i1, i2);
                if (i1 < i2) {
                    m1 = m >> 10;
                    m2 = m & 0x3FF;
                } else {
                    m2 = m >> 10;
                    m1 = m & 0x3FF;
                }
                this.setCutData(a1, a2, m1, m2, i);
            }
            if (this.attachmentPointType != 0) {
                this.addAttachmentMarkers(attachAtomList, attachBondList, b, m1, m2, i);
            }
            mol.removeBond(j);
        }
        if (this.attachmentPointType != 0) {
            for (MolAtom a : attachAtomList) {
                mol.add(a);
            }
            for (MolBond b : attachBondList) {
                mol.add(b);
            }
        }
        mol.valenceCheck();
        MoleculeGraph[] frags = mol.convertToFrags();
        if (this.cutdata != null) {
            this.storeCutData(frags);
            this.cutdata.clear();
        }
        MolSearch searcher = new MolSearch();
        searcher.getSearchOptions().setSubgraphSearch(false);
        for (int i = 0; i < frags.length; ++i) {
            MoleculeGraph currfrag = frags[i];
            String uid1 = this.uidTag != null ? ((Molecule)currfrag).getProperty(this.uidTag) : "";
            boolean firstsearch = true;
            boolean unique = true;
            for (int j = coll.size() - 1; j >= 0; --j) {
                String uid2;
                Molecule frag = (Molecule)coll.get(j);
                String string = uid2 = this.uidTag != null ? frag.getProperty(this.uidTag) : "";
                if (!uid1.equals(uid2)) continue;
                if (firstsearch) {
                    searcher.setTarget((Molecule)currfrag);
                    firstsearch = false;
                }
                searcher.setQuery(frag);
                try {
                    if (!searcher.isMatching()) continue;
                    this.setTags(frag);
                    unique = false;
                    break;
                }
                catch (SearchException e) {
                    System.err.println("Fragment repetition check failed: " + e);
                }
            }
            if (!unique) continue;
            currfrag.setAbsStereo(ReactionUtil.isAbsoluteStereoRelevant((Molecule)currfrag));
            this.setTags((Molecule)currfrag);
            coll.add(currfrag);
        }
    }

    private void addAttachmentMarkers(List attachAtomList, List attachBondList, MolBond cutBond, int m1, int m2, int i) {
        MolAtom a1 = cutBond.getAtom1();
        MolAtom a2 = cutBond.getAtom2();
        MolAtom ma1 = this.createMarkerAtom(a1);
        MolAtom ma2 = this.createMarkerAtom(a2);
        MolBond mb1 = cutBond.cloneBond(a1, ma2);
        MolBond mb2 = cutBond.cloneBond(ma1, a2);
        attachAtomList.add(ma1);
        attachAtomList.add(ma2);
        attachBondList.add(mb1);
        attachBondList.add(mb2);
        if (this.cutdata != null) {
            this.setCutData(ma1, ma2, m1, m2, i);
        }
    }

    private MolAtom createMarkerAtom(MolAtom a) {
        int atno = 131;
        if (this.attachmentPointType == 2) {
            atno = a.hasAromaticBond() ? 18 : 13;
        }
        return new MolAtom(atno, a.getX(), a.getY(), a.getZ());
    }

    protected void setTags(Molecule frag) {
        if (this.countTag != null) {
            String countStr = frag.getProperty(this.countTag);
            if (countStr != null) {
                frag.setProperty(this.countTag, String.valueOf(Integer.parseInt(countStr) + 1));
            } else {
                frag.setProperty(this.countTag, "1");
            }
        }
    }

    private void setCutData(MolAtom a1, MolAtom a2, int m1, int m2, int i) {
        ArrayList<Object> rids2;
        ArrayList<Object> rids1 = this.cutdata.get(a1);
        if (rids1 == null) {
            rids1 = new ArrayList(a1.getBondCount());
            this.cutdata.put(a1, rids1);
        }
        if ((rids2 = this.cutdata.get(a2)) == null) {
            rids2 = new ArrayList(a2.getBondCount());
            this.cutdata.put(a2, rids2);
        }
        rids1.add(new int[]{i, m1});
        rids2.add(new int[]{i, m2});
    }

    private void storeCutData(MoleculeGraph[] fragments) {
        for (int i = 0; i < fragments.length; ++i) {
            Molecule fragment = (Molecule)fragments[i];
            boolean emptyalias = true;
            int cutsum = 0;
            ArrayList<ArrayList<int[]>> uids = new ArrayList<ArrayList<int[]>>();
            StringBuffer cutids = new StringBuffer();
            StringBuffer cutcounts = new StringBuffer();
            int n = fragment.getAtomCount();
            for (int j = 0; j < n; ++j) {
                int size;
                MolAtom atom = fragment.getAtom(j);
                ArrayList<int[]> rids = this.cutdata.get(atom);
                if (rids != null) {
                    Collections.sort(rids, this.comparator);
                }
                int n2 = size = rids != null ? rids.size() : 0;
                if (this.uidTag != null) {
                    uids.add(rids);
                }
                if (this.dataInLabel || this.cutidsTag != null) {
                    String atomdata = "";
                    for (int k = 0; k < size; ++k) {
                        if (k > 0) {
                            atomdata = atomdata + ",";
                        }
                        int[] data = rids.get(k);
                        atomdata = atomdata + this.cbs[data[0]].reactionID + ":" + data[1];
                    }
                    if (this.dataInLabel && atomdata.length() > 0) {
                        fragment.getAtom(j).setExtraLabel(atomdata);
                        emptyalias = false;
                    }
                    if (this.cutidsTag != null) {
                        if (j > 0) {
                            cutids.append(";");
                        }
                        cutids.append(atomdata);
                    }
                }
                if (this.cutcountsTag != null) {
                    if (j > 0) {
                        cutcounts.append(";");
                    }
                    if (size > 0) {
                        cutcounts.append(size);
                    }
                }
                cutsum += size;
            }
            if (emptyalias) {
                fragment.getAtom(0).setAliasstr("");
            }
            if (this.uidTag != null) {
                int[] grinv = new int[n];
                fragment.getGrinv(grinv);
                Object[] u = new String[n];
                for (int j = 0; j < n; ++j) {
                    ArrayList rids = (ArrayList)uids.get(j);
                    StringBuffer s = new StringBuffer();
                    s.append(grinv[j] + "|");
                    if (rids != null) {
                        int size = rids.size();
                        for (int k = 0; k < size; ++k) {
                            if (k > 0) {
                                s.append(",");
                            }
                            int[] data = (int[])rids.get(k);
                            s.append(data[0] + ":" + data[1]);
                        }
                    }
                    u[j] = new String(s);
                }
                Arrays.sort(u);
                StringBuffer uid = new StringBuffer();
                for (int j = 0; j < n; ++j) {
                    if (j > 0) {
                        uid.append(";");
                    }
                    uid.append(((String)u[j]).substring(((String)u[j]).indexOf("|") + 1));
                }
                fragment.setProperty(this.uidTag, new String(uid));
            }
            if (this.cutidsTag != null) {
                fragment.setProperty(this.cutidsTag, new String(cutids));
            }
            if (this.cutcountsTag != null) {
                fragment.setProperty(this.cutcountsTag, new String(cutcounts));
            }
            if (this.cutsumTag == null) continue;
            fragment.setProperty(this.cutsumTag, String.valueOf(cutsum));
        }
    }

    public void fragment(List coll, Molecule mol) throws SearchException {
        this.find(mol);
        this.create(coll);
    }

    private CutBondSearch[] createCBS(RxnMolecule[] reactions) throws SearchException {
        CutBondSearch[] res = new CutBondSearch[reactions.length];
        ArrayList<int[]> bmaps = new ArrayList<int[]>();
        ArrayList<int[]> bindices = new ArrayList<int[]>();
        for (int i = 0; i < reactions.length; ++i) {
            int m2;
            int m1;
            if (reactions[i].getReactantCount() != 1) {
                throw new SearchException("Reaction check failed: reactant count for reaction " + i + " is " + reactions[i].getReactantCount() + " - must be 1.");
            }
            int flags = 4;
            Molecule reactant = reactions[i].getComponent(flags, 0);
            MolSearch searcher = new MolSearch();
            MolSearchOptions mso = new MolSearchOptions(2);
            mso.setOrderSensitiveSearch(true);
            mso.setHitIncludesRNodes(true);
            searcher.setSearchOptions(mso);
            searcher.setQuery(reactant);
            bmaps.clear();
            bindices.clear();
            int[][] bonds = new int[reactant.getBondCount()][];
            for (int j = reactant.getBondCount() - 1; j >= 0; --j) {
                MolBond b = reactant.getBond(j);
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                bonds[j] = new int[]{reactant.indexOf(a1), reactant.indexOf(a2)};
                m1 = a1.getAtomMap();
                m2 = a2.getAtomMap();
                if (m1 == 0 || m2 == 0) continue;
                bmaps.add(new int[]{m1, m2});
                bindices.add(bonds[j]);
            }
            for (int k = reactions[i].getProductCount() - 1; k >= 0; --k) {
                Molecule product = reactions[i].getProduct(k);
                for (int j = product.getBondCount() - 1; j >= 0; --j) {
                    MolBond b = product.getBond(j);
                    m1 = b.getAtom1().getAtomMap();
                    m2 = b.getAtom2().getAtomMap();
                    if (m1 == 0 || m2 == 0) continue;
                    for (int l = bmaps.size() - 1; l >= 0; --l) {
                        int[] p = (int[])bmaps.get(l);
                        if ((p[0] != m1 || p[1] != m2) && (p[0] != m2 || p[1] != m1)) continue;
                        bindices.remove(l);
                        bmaps.remove(l);
                    }
                }
            }
            int[][] cuts = new int[bindices.size()][];
            bindices.toArray((T[])cuts);
            int[][] maps = new int[bmaps.size()][];
            bmaps.toArray((T[])maps);
            res[i] = new CutBondSearch(searcher, bonds, cuts, maps);
        }
        return res;
    }

    public boolean isCutBond(int i, int j) {
        if (i < 0 || j < 0) {
            return false;
        }
        if (i == -2147483647 || j == -2147483647) {
            return false;
        }
        return this.cutbond[this.getBondIndex(i, j)] != -1;
    }

    public int getCutBond(int i, int j) {
        if (i < 0 || j < 0) {
            return -1;
        }
        if (i == -2147483647 || j == -2147483647) {
            return -1;
        }
        return this.cutbond[this.getBondIndex(i, j)];
    }

    private int getCutBondMaps(int i, int j) {
        return this.cutbondmaps[this.getBondIndex(i, j)];
    }

    protected final void setCutBond(int i, int j, int r, int mi, int mj) {
        if (i < 0 || j < 0) {
            return;
        }
        int k = this.getBondIndex(i, j);
        this.cutbond[k] = r;
        if (this.cutdata != null) {
            int m;
            this.cutbondmaps[k] = m = i < j ? mi << 10 | mj : mj << 10 | mi;
        }
    }

    protected final void setCutBond(int i, int j, int r) {
        if (i < 0 || j < 0) {
            return;
        }
        int k = this.getBondIndex(i, j);
        this.cutbond[k] = r;
    }

    protected final void clearCutBond(int i, int j) {
        if (i < 0 || j < 0) {
            return;
        }
        int k = this.getBondIndex(i, j);
        this.cutbond[k] = -1;
    }

    protected final void clearCutBonds() {
        Arrays.fill(this.cutbond, -1);
    }

    private int getBondIndex(int i, int j) {
        return i > j ? i * (i - 1) / 2 + j : j * (j - 1) / 2 + i;
    }

    private void alloc(int capacity) {
        int n;
        int s = capacity * (capacity - 1) / 2;
        for (n = this.cutbond != null ? this.cutbond.length : 1; n < s; n <<= 1) {
        }
        if (this.cutbond == null || n > this.cutbond.length) {
            this.cutbond = new int[n];
            this.cutbondmaps = new int[n];
        }
        this.clearCutBonds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(MolImporter[] ins, OutputStream out, String format2, String molidtag, String stattag, boolean skipUnfrag, boolean ignoreError) throws Exception {
        if (format2.toLowerCase().startsWith("cxsmi") && (this.uidTag != null || stattag != null)) {
            format2 = format2.indexOf(":") != -1 ? format2 + " " : format2 + ":";
            String sep = "T";
            if (this.uidTag != null) {
                format2 = format2 + sep + this.uidTag;
                sep = ":";
            }
            if (stattag != null) {
                format2 = format2 + sep + stattag;
                sep = ":";
            }
            if (this.cutidsTag != null) {
                format2 = format2 + sep + this.cutidsTag;
                sep = ":";
            }
            if (this.cutcountsTag != null) {
                format2 = format2 + sep + this.cutcountsTag;
                sep = ":";
            }
            if (this.cutsumTag != null) {
                format2 = format2 + sep + this.cutsumTag;
                sep = ":";
            }
            if (this.countTag != null) {
                format2 = format2 + sep + this.countTag;
                sep = ":";
            }
            if (this.fragmentsetsTag != null) {
                format2 = format2 + sep + this.fragmentsetsTag;
                sep = ":";
            }
        }
        this.molCount = 0;
        String molid = null;
        String stat = null;
        String sourcetag = molidtag != null ? DEF_SOURCETAG + molidtag : DEF_SOURCETAG;
        ArrayList list = new ArrayList();
        MolExporter exporter = new MolExporter(out, format2);
        Molecule target = null;
        try {
            block6: for (int i = 0; i < ins.length; ++i) {
                MolImporter molimp = ins[i];
                while ((target = ConfigTools.readMol(molimp, ignoreError)) != null) {
                    ++this.molCount;
                    if (ConfigTools.isReadErrorMol(target)) {
                        System.err.println("Import error when reading molecule " + this.molCount + ": " + ConfigTools.getReadErrorMessage(target));
                        continue;
                    }
                    String string = molid = molidtag != null ? target.getProperty(molidtag) : null;
                    if (molid == null) {
                        molid = String.valueOf(this.molCount);
                    }
                    if (stattag != null && (stat = target.getProperty(stattag)) == null) {
                        stat = "-";
                    }
                    list.clear();
                    try {
                        this.fragment(list, target);
                        int size = list.size();
                        if (skipUnfrag && size <= 1) continue;
                        for (int j = 0; j < size; ++j) {
                            Molecule frag = (Molecule)list.get(j);
                            frag.setProperty(sourcetag, molid);
                            if (stattag != null) {
                                frag.setProperty(stattag, stat);
                            }
                            ConfigTools.writeMol(frag, exporter, ignoreError);
                        }
                    }
                    catch (LicenseException e) {
                        System.err.println(e);
                        continue block6;
                    }
                    catch (Exception e) {
                        System.err.println("Error at molecule " + this.molCount + ": " + e);
                        if (ignoreError) {
                            System.err.println(e);
                            e.printStackTrace();
                            continue;
                        }
                        throw e;
                    }
                }
            }
        }
        finally {
            exporter.close();
            if (out != System.out) {
                out.close();
            }
        }
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Fragmenter", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Fragmenter", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public static void main(String[] args) throws Exception {
        CLQ clq = new CLQ(args, null);
        if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(helptext);
            return;
        }
        CLQ.Parameter pConfig = clq.lookup("-c", "--config", "", 2, true, false);
        File config = new File(pConfig.getString());
        CLQ.Parameter pMolIdTag = clq.lookup("-i", "--id", "", 2, false, false);
        String molidtag = pMolIdTag != null ? pMolIdTag.getString() : null;
        CLQ.Parameter pStatTag = clq.lookup("-s", "--statistics", "", 2, false, false);
        String stattag = pStatTag != null ? pStatTag.getString() : null;
        CLQ.Parameter pFormat = clq.lookup("-f", "--format", "", 2, false, false);
        String format2 = pFormat == null ? "cxsmiles" : pFormat.getString();
        CLQ.Parameter pOutput = clq.lookup("-o", "--output", "", 2, false, false);
        FragmenterConfig fc = null;
        try {
            fc = new FragmenterConfig(config);
        }
        catch (IOException e) {
            System.err.println(e);
            return;
        }
        CutBondReviser reviser = fc.getReviser();
        CLQ.Parameter pAlgorithm = clq.lookup("-a", "--algorithm", "", 2, false, false);
        int algorithm = pAlgorithm != null ? ("greedy".equalsIgnoreCase(pAlgorithm.getString()) ? 1 : 0) : fc.getAlgorithm();
        CLQ.Parameter pFragmentCount = clq.lookup("-x", "--fragment-count", "", 2, false, false);
        int count = pFragmentCount != null ? pFragmentCount.getInt() : fc.getMaxFragmentCount();
        CLQ.Parameter pSetCount = clq.lookup("-y", "--set-count", "", 2, false, false);
        int limit = pSetCount != null ? pSetCount.getInt() : fc.getMaxSetCount();
        CLQ.Parameter pExtensive = clq.lookup("-e", "--extensive", "", 1, false, false);
        boolean extensive = pExtensive != null ? true : fc.isExtensive();
        CLQ.Parameter pSkipUnfrag = clq.lookup("-k", "--skip-unfragmented", "", 1, false, false);
        boolean skipUnfrag = pSkipUnfrag != null;
        CLQ.Parameter pData = clq.lookup("-d", "--data", "", 2, false, false);
        String data = pData != null ? pData.getString().toUpperCase() : "LI";
        boolean dataInLabel = data.indexOf("L") != -1;
        boolean dataInUID = data.indexOf("I") != -1;
        CLQ.Parameter pAttach = clq.lookup("-p", "--attachment-point", "", 2, false, false);
        String attach = pAttach != null ? pAttach.getString().toUpperCase() : "N";
        int attachmentPointType = 0;
        if (attach.startsWith("S")) {
            attachmentPointType = 1;
        } else if (attach.startsWith("A")) {
            attachmentPointType = 2;
        }
        boolean ignoreError = clq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
        Fragmenter fragmenter = null;
        switch (algorithm) {
            case 0: {
                ExhaustiveFragmenter efragmenter = new ExhaustiveFragmenter(fc.getReactions(), fc.getStandardizer(), reviser);
                efragmenter.setFragmentSetsTag(fc.getFragmentSetsTag());
                efragmenter.setMaxSetCount(limit);
                efragmenter.setExtensive(extensive);
                fragmenter = efragmenter;
                break;
            }
            case 1: {
                GreedyFragmenter gfragmenter = new GreedyFragmenter(fc.getReactions(), fc.getStandardizer(), reviser);
                fragmenter = gfragmenter;
            }
        }
        String uidTag = dataInUID ? fc.getUidTag() : null;
        fragmenter.setMaxFragmentCount(count);
        fragmenter.setCountTag(fc.getCountTag());
        fragmenter.setDataInLabel(dataInLabel);
        fragmenter.setAttachmentPointType(attachmentPointType);
        fragmenter.collect(uidTag, fc.getCutIdsTag(), fc.getCutCountsTag(), fc.getCutSumTag(), fc.getReactionIDs());
        PrintStream out = pOutput == null ? new PrintStream(new BufferedOutputStream(System.out)) : new PrintStream(new BufferedOutputStream(new FileOutputStream(pOutput.getString())));
        MolImporter[] ins = ConfigTools.getTargetMolImporters(clq);
        fragmenter.run(ins, out, format2, molidtag, stattag, skipUnfrag, ignoreError);
    }

    static class IntArrayComparator
    implements Comparator {
        IntArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            int[] t1 = (int[])o1;
            int[] t2 = (int[])o2;
            int r = t1[0] - t2[0];
            return r != 0 ? r : t1[1] - t2[1];
        }
    }

    static class CutBondSearch {
        MolSearch searcher = null;
        String reactionID = null;
        int[][] bonds = null;
        int[][] cuts = null;
        int[][] maps = null;

        public CutBondSearch(MolSearch searcher, int[][] bonds, int[][] cuts, int[][] maps) {
            this.searcher = searcher;
            this.bonds = bonds;
            this.cuts = cuts;
            this.maps = maps;
        }

        public String toString() {
            int i;
            StringBuffer s = new StringBuffer();
            s.append("bonds:" + lineSep);
            for (i = 0; i < this.bonds.length; ++i) {
                s.append(this.bonds[i][0] + " - " + this.bonds[i][1] + lineSep);
            }
            s.append("cuts:" + lineSep);
            for (i = 0; i < this.cuts.length; ++i) {
                s.append(this.cuts[i][0] + " - " + this.cuts[i][1] + lineSep);
            }
            return new String(s);
        }
    }
}

