/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.fragmenter.CutBondReviser;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.ConfigTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class FragmenterConfig {
    public static final int ALG_EXHAUSTIVE = 0;
    public static final int ALG_GREEDY = 1;
    public static final String DEF_UIDTAG = "UID";
    private Standardizer standardizer = null;
    private RxnMolecule[] reactions = null;
    private String[] reactionIDs = null;
    private int maxfragmentcount = Integer.MAX_VALUE;
    private int maxsetcount = Integer.MAX_VALUE;
    private int algorithm = 0;
    private boolean extensive = false;
    private String uidTag = "UID";
    private String cutidsTag = null;
    private String cutcountsTag = null;
    private String cutsumTag = null;
    private String fragmentsetsTag = null;
    private String countTag = null;
    private String dir = null;
    private CutBondReviser reviser = null;

    public FragmenterConfig(File file) throws IOException {
        this.readConfig(file);
    }

    public FragmenterConfig(InputStream is) throws IOException {
        this.readConfig(is);
    }

    public FragmenterConfig(String xmlstr) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(xmlstr.getBytes()));
        this.readConfig(is);
    }

    public FragmenterConfig(Element root) throws IOException {
        this.readConfig(root);
    }

    public Standardizer getStandardizer() {
        return this.standardizer;
    }

    public RxnMolecule[] getReactions() {
        return this.reactions;
    }

    public String[] getReactionIDs() {
        return this.reactionIDs;
    }

    public int getMaxFragmentCount() {
        return this.maxfragmentcount;
    }

    public int getMaxSetCount() {
        return this.maxsetcount;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public boolean isExtensive() {
        return this.extensive;
    }

    public String getUidTag() {
        return this.uidTag;
    }

    public String getCutIdsTag() {
        return this.cutidsTag;
    }

    public String getCutCountsTag() {
        return this.cutcountsTag;
    }

    public String getCutSumTag() {
        return this.cutsumTag;
    }

    public String getFragmentSetsTag() {
        return this.fragmentsetsTag;
    }

    public String getCountTag() {
        return this.countTag;
    }

    public void readConfig(InputStream is) throws IOException {
        this.dir = null;
        Element root = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(is);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new IOException("Error occured during XML parsing.");
        }
        this.readConfig(root);
    }

    public void readConfig(File file) throws IOException {
        this.dir = file.getParent();
        Element root = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(file);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new IOException("Error occured during XML parsing.");
        }
        this.readConfig(root);
    }

    public void readConfig(Element root) throws IOException {
        XPath path = DocumentHelper.createXPath((String)"Standardizer");
        Element standardizerRoot = (Element)path.selectSingleNode((Object)root);
        path = DocumentHelper.createXPath((String)"Fragmenter");
        Element fragmenterRoot = (Element)path.selectSingleNode((Object)root);
        path = DocumentHelper.createXPath((String)"Reviser | Revisers");
        Element reviserRoot = (Element)path.selectSingleNode((Object)root);
        this.setStandardizer(standardizerRoot);
        this.setFragmenter(fragmenterRoot);
        this.setReviser(reviserRoot);
    }

    public void setStandardizer(Element root) throws IOException {
        if (root != null) {
            try {
                this.standardizer = new Standardizer(root, this.dir);
            }
            catch (StandardizerException e) {
                throw new IOException("Standardizer object creation failed: " + e.getMessage());
            }
        }
    }

    public void setFragmenter(Element root) throws IOException {
        if (root == null) {
            throw new IOException("invalid XML configuration");
        }
        Element actionsRoot = (Element)root.selectSingleNode("Actions");
        Element paramsRoot = (Element)root.selectSingleNode("Params");
        this.setActions((Node)actionsRoot);
        this.setParams(paramsRoot);
    }

    public void setActions(Node root) throws IOException {
        ArrayList<RxnMolecule> v = new ArrayList<RxnMolecule>();
        ArrayList<String> ids = new ArrayList<String>();
        if (root != null) {
            List actions = root.selectNodes("Action");
            int n = actions.size();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)actions.get(i);
                String type = element.attributeValue("Type");
                String structure = element.attributeValue("Structure");
                if (structure == null) {
                    throw new IOException("Structure attribute is mandatory for Action elements.");
                }
                Molecule rmol = ConfigTools.getQueryMolecule(structure, type, this.dir);
                RxnMolecule rxmol = RxnMolecule.getReaction(rmol);
                if (rxmol == null) {
                    throw new IOException("reaction is not in rxn format");
                }
                if (this.standardizer != null) {
                    try {
                        int j;
                        for (j = rxmol.getReactantCount() - 1; j >= 0; --j) {
                            this.standardizer.standardize(rxmol.getReactant(j));
                        }
                        for (j = rxmol.getProductCount() - 1; j >= 0; --j) {
                            this.standardizer.standardize(rxmol.getProduct(j));
                        }
                    }
                    catch (SearchException e) {
                        throw new IOException("Standardization failed for action " + (i + 1) + " in the Actions section: " + e.getMessage());
                    }
                }
                v.add(rxmol);
                String id = element.attributeValue("ID");
                if (id == null || id.length() == 0) {
                    id = "" + (i + 1);
                }
                ids.add(id);
            }
        }
        this.reactions = new RxnMolecule[v.size()];
        this.reactionIDs = new String[ids.size()];
        v.toArray(this.reactions);
        ids.toArray(this.reactionIDs);
    }

    public void setParams(Element root) throws IOException {
        this.uidTag = DEF_UIDTAG;
        this.algorithm = 0;
        if (root != null) {
            XPath path = DocumentHelper.createXPath((String)"SDFTags");
            Element sdftags = (Element)path.selectSingleNode((Object)root);
            path = DocumentHelper.createXPath((String)"Fragmentation");
            Element fragmentation = (Element)path.selectSingleNode((Object)root);
            if (sdftags != null) {
                String countTagAttr;
                String fragmentsetsTagAttr;
                String cutsumTagAttr;
                String cutcountsTagAttr;
                String cutidsTagAttr;
                String uidTagAttr = sdftags.attributeValue("Uid");
                if (uidTagAttr != null) {
                    this.uidTag = uidTagAttr;
                }
                if ((cutidsTagAttr = sdftags.attributeValue("CutIds")) != null) {
                    this.cutidsTag = cutidsTagAttr;
                }
                if ((cutcountsTagAttr = sdftags.attributeValue("CutCounts")) != null) {
                    this.cutcountsTag = cutcountsTagAttr;
                }
                if ((cutsumTagAttr = sdftags.attributeValue("CutSum")) != null) {
                    this.cutsumTag = cutsumTagAttr;
                }
                if ((fragmentsetsTagAttr = sdftags.attributeValue("FragmentSets")) != null) {
                    this.fragmentsetsTag = fragmentsetsTagAttr;
                }
                if ((countTagAttr = sdftags.attributeValue("Count")) != null) {
                    this.countTag = countTagAttr;
                }
            }
            if (fragmentation != null) {
                String algorithmAttr;
                String limitAttr;
                String maxfragmentsAttr = fragmentation.attributeValue("MaxFragmentCount");
                if (maxfragmentsAttr != null) {
                    try {
                        this.maxfragmentcount = Integer.parseInt(maxfragmentsAttr);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("MaxFragmentCount is not an integer: " + maxfragmentsAttr);
                    }
                }
                if ((limitAttr = fragmentation.attributeValue("MaxSetCount")) != null) {
                    try {
                        this.maxsetcount = Integer.parseInt(limitAttr);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("SetCount is not an integer: " + limitAttr);
                    }
                }
                this.algorithm = (algorithmAttr = fragmentation.attributeValue("Algorithm", "")).equalsIgnoreCase("greedy") ? 1 : 0;
                String extensiveAttr = fragmentation.attributeValue("Extensive", "");
                this.extensive = extensiveAttr.equalsIgnoreCase("true");
            }
        }
    }

    public void setReviser(Element root) throws IOException {
        Element element;
        this.reviser = null;
        if (root != null && (element = (Element)root.selectSingleNode("*")) != null) {
            this.reviser = CutBondReviser.create(element, this.standardizer, this.dir);
        }
    }

    public CutBondReviser getReviser() {
        return this.reviser;
    }
}

