/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.fragmenter.CutBondReviser;
import chemaxon.fragmenter.Fragmenter;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.RxnMolecule;

public class GreedyFragmenter
extends Fragmenter {
    public GreedyFragmenter(RxnMolecule[] reactions, Standardizer standardizer) throws SearchException {
        this(reactions, standardizer, null);
    }

    public GreedyFragmenter(RxnMolecule[] reactions, Standardizer standardizer, CutBondReviser reviser) throws SearchException {
        super(reactions, standardizer, reviser);
    }

    @Override
    protected void find() throws SearchException {
        int count = 1;
        int[] hit = null;
        for (int i = 0; i < this.cbs.length; ++i) {
            Fragmenter.CutBondSearch r = this.cbs[i];
            while ((hit = r.searcher.findNext()) != null) {
                int j;
                boolean overlapping = false;
                for (j = 0; j < r.bonds.length; ++j) {
                    if (!this.isCutBond(hit[r.bonds[j][0]], hit[r.bonds[j][1]])) continue;
                    overlapping = true;
                    break;
                }
                if (overlapping) continue;
                for (j = 0; j < r.cuts.length; ++j) {
                    int a1 = hit[r.cuts[j][0]];
                    int a2 = hit[r.cuts[j][1]];
                    if (a1 < 0 || a2 < 0 || !this.reviser.revise(a1, a2)) continue;
                    this.reviser.set(a1, a2);
                    this.setCutBond(a1, a2, i, r.maps[j][0], r.maps[j][1]);
                    if (++count != this.maxfragmentcount) continue;
                    return;
                }
            }
        }
    }
}

