/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.smiles.SmilesExport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MoleculeFragmenter
implements Licensable {
    private static final String FILTER_SMILES_FORMAT = "smiles:q";
    private Molecule molecule;
    private int maxBondCount = Integer.MAX_VALUE;
    private boolean explicitizedOutput = false;
    private boolean cleaveAromaticBonds = false;
    private boolean cleaveAliphaticRingBonds = true;
    private String licenseEnviroment = "";
    private final SmilesExport smilesExport = new SmilesExport();
    private static final int PROCESSOR_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int INTEGER_MEMORY_SIZE = 22;
    private static final int MAX_COLLECTION_SIZE = (int)Math.floor(Runtime.getRuntime().maxMemory() / 22L / 2L);
    private int sequencesSize = 0;
    private int queueSize = 0;
    private boolean queueSizeLimitExceed = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String COLUMN_SEPARATOR = "\t\t\t\t";
    private static final String HELP_TEXT = "MoleculeFragmenter" + LINE_SEPARATOR + "Usage:" + LINE_SEPARATOR + "molfragment <moleculefile>/<smiles> [-o <outputFile>] [-f <smiles/sdf/rdf/mrv>] [-m <maxBondCount>] [-e] [-l <logfile>]" + LINE_SEPARATOR + LINE_SEPARATOR + "General Options:" + LINE_SEPARATOR + "-h,--help" + "\t\t\t\t" + "this help message" + LINE_SEPARATOR + "-o," + "\t\t\t\t" + "output file path (if not set standard output will be used)" + LINE_SEPARATOR + "-f," + "\t\t\t\t" + "output format (default is smiles)" + LINE_SEPARATOR + "-m," + "\t\t\t\t" + "maximum count of the CCQ bonds in the generated fragments (default is unlimited)" + LINE_SEPARATOR + "-e," + "\t\t\t\t" + "add explicit hydrogens to the fragments" + LINE_SEPARATOR + "-l," + "\t\t\t\t" + "log file path" + LINE_SEPARATOR + LINE_SEPARATOR + "Examples: " + LINE_SEPARATOR + "molfragment NC(CSC(Cl)=CCl)C(O)=O" + LINE_SEPARATOR + "molfragment NC(CSC(Cl)=CCl)C(O)=O -f mrv" + LINE_SEPARATOR + "molfragment NC(CSC(Cl)=CCl)C(O)=O -f mrv -e";

    public MoleculeFragmenter() {
        try {
            this.smilesExport.open(FILTER_SMILES_FORMAT);
        }
        catch (MolExportException e) {
            e.printStackTrace();
        }
    }

    public Collection<String> calculateFragments() throws LicenseException {
        int i;
        this.checkLicense();
        this.queueSize = 0;
        this.sequencesSize = 0;
        this.queueSizeLimitExceed = false;
        Collection<String> fragments = Collections.synchronizedCollection(new HashSet());
        try {
            if (!this.explicitizedOutput) {
                fragments.add(this.smilesExport.toSMILES(this.molecule));
            } else {
                Molecule molecule = this.molecule.cloneMolecule();
                molecule.addExplicitHydrogens(2047);
                fragments.add(this.smilesExport.toSMILES(molecule));
            }
        }
        catch (MolExportException exception) {
            exception.printStackTrace();
        }
        Map[] atomFragmentNumMaps = new Map[PROCESSOR_COUNT];
        Map[] fragmentNumFragmentMaps = new Map[PROCESSOR_COUNT];
        MolBond[][] neededBondsArray = new MolBond[PROCESSOR_COUNT][];
        Map[] neighbourMaps = new Map[PROCESSOR_COUNT];
        Molecule[] primitiveFragments = null;
        for (int i2 = 0; i2 < PROCESSOR_COUNT; ++i2) {
            Molecule molecule = this.molecule.cloneMolecule();
            molecule.aromatize();
            neededBondsArray[i2] = this.collectNeededBonds(molecule);
            HashedArrayList.setMaxElementCount(neededBondsArray[i2].length);
            primitiveFragments = this.createPrimitiveFragments(neededBondsArray[i2], molecule);
            fragmentNumFragmentMaps[i2] = this.createFragmentMap(primitiveFragments);
            atomFragmentNumMaps[i2] = this.createAtomFragmentNumMap(primitiveFragments);
            Map<MolAtom, Collection<Integer>> atomBondNumsMap = this.createAtomBondNumsMap(neededBondsArray[i2]);
            neighbourMaps[i2] = this.createNeighbourMap(neededBondsArray[i2], atomFragmentNumMaps[i2], fragmentNumFragmentMaps[i2], atomBondNumsMap);
        }
        if (primitiveFragments == null) {
            return fragments;
        }
        try {
            for (int j = 0; j < primitiveFragments.length; ++j) {
                if (!this.isFragmentNeeded((Molecule)primitiveFragments[j])) continue;
                String frag = this.smilesExport.toSMILES((Molecule)primitiveFragments[j]);
                fragments.add(frag);
            }
        }
        catch (MolExportException e) {
            e.printStackTrace();
        }
        Collection<HashedArrayList<Integer>> sequences = this.createSequences(neighbourMaps[0]);
        Collection<List<Integer>>[] subsequences = this.splitSequences(sequences);
        sequences.clear();
        Thread[] threads = new Thread[PROCESSOR_COUNT];
        for (i = 0; i < PROCESSOR_COUNT; ++i) {
            threads[i] = new Thread(new MoleculeCreator(fragments, subsequences[i], neededBondsArray[i], fragmentNumFragmentMaps[i], atomFragmentNumMaps[i]));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return fragments;
    }

    public String[] calculateFragmentsArray() throws LicenseException {
        Collection<String> fragments = this.calculateFragments();
        return fragments.toArray(new String[fragments.size()]);
    }

    public String[] calculateFragments(Molecule molecule) throws LicenseException {
        this.setMolecule(molecule);
        return this.calculateFragmentsArray();
    }

    public void setMolecule(Molecule molecule) {
        this.molecule = molecule.cloneMolecule();
        this.molecule.implicitizeHydrogens(2047);
    }

    public void setMaxBondCount(int maxBondCount) {
        this.maxBondCount = maxBondCount;
    }

    public boolean isExplicitizedOutput() {
        return this.explicitizedOutput;
    }

    public void setExplicitizedOutput(boolean explicitizedOutput) {
        this.explicitizedOutput = explicitizedOutput;
    }

    public boolean isCleaveAromaticBonds() {
        return this.cleaveAromaticBonds;
    }

    public void setCleaveAromaticBonds(boolean cleaveAromaticBonds) {
        this.cleaveAromaticBonds = cleaveAromaticBonds;
    }

    public boolean isCleaveAliphaticRingBonds() {
        return this.cleaveAliphaticRingBonds;
    }

    public void setCleaveAliphaticRingBonds(boolean cleaveAliphaticRingBonds) {
        this.cleaveAliphaticRingBonds = cleaveAliphaticRingBonds;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Fragmenter", this.licenseEnviroment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnviroment = env;
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Fragmenter", this.licenseEnviroment);
    }

    private Collection<List<Integer>>[] splitSequences(Collection<HashedArrayList<Integer>> sequences) {
        Collection[] subSequences = new Collection[PROCESSOR_COUNT];
        Object[] seqs = sequences.toArray();
        int subSequenceSize = (int)Math.floor((float)seqs.length / (float)PROCESSOR_COUNT);
        for (int i = 0; i < subSequences.length; ++i) {
            int sequenceLength = i == subSequences.length - 1 ? Math.max((i + 1) * subSequenceSize, seqs.length) - i * subSequenceSize : subSequenceSize;
            List[] objects = new List[sequenceLength];
            System.arraycopy(seqs, i * subSequenceSize, objects, 0, sequenceLength);
            subSequences[i] = Arrays.asList(objects);
        }
        return subSequences;
    }

    private Collection<HashedArrayList<Integer>> createSequences(final Map<Integer, List<Integer>> neighbourMap) {
        final Map<List<Boolean>, HashedArrayList<Integer>> sequences = Collections.synchronizedMap(new LinkedHashMap());
        final LinkedList<HashedArrayList<Integer>> queue = new LinkedList<HashedArrayList<Integer>>();
        for (Integer startingNode : neighbourMap.keySet()) {
            int i;
            HashedArrayList<Integer> startingSequence = new HashedArrayList<Integer>();
            startingSequence.add(startingNode);
            List<Boolean> hash = startingSequence.hash();
            if (!sequences.containsKey(hash)) {
                sequences.put(hash, startingSequence);
                this.sequencesSize += startingSequence.size();
            }
            List<Integer> neighbours = neighbourMap.get(startingNode);
            if (!this.queueSizeLimitExceed) {
                this.queueNewPaths(startingSequence, neighbours, queue);
            }
            Thread[] threads = new Thread[PROCESSOR_COUNT];
            for (i = 0; i < PROCESSOR_COUNT; ++i) {
                threads[i] = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean done = false;
                        while (!done) {
                            HashedArrayList nextSequence = null;
                            LinkedList linkedList = queue;
                            synchronized (linkedList) {
                                boolean bl = done = queue.isEmpty() || MoleculeFragmenter.this.sequencesSize >= MAX_COLLECTION_SIZE;
                                if (MoleculeFragmenter.this.queueSize >= MAX_COLLECTION_SIZE) {
                                    MoleculeFragmenter.this.queueSizeLimitExceed = true;
                                }
                                if (!done) {
                                    nextSequence = (HashedArrayList)queue.removeFirst();
                                    MoleculeFragmenter.this.queueSize -= nextSequence.size();
                                }
                            }
                            if (nextSequence == null) continue;
                            List<Boolean> hash = nextSequence.hash();
                            if (!sequences.containsKey(hash)) {
                                sequences.put(hash, nextSequence);
                                MoleculeFragmenter.this.sequencesSize += nextSequence.size();
                            }
                            List neighbours = (List)neighbourMap.get(nextSequence.get(nextSequence.size() - 1));
                            if (MoleculeFragmenter.this.queueSizeLimitExceed) continue;
                            MoleculeFragmenter.this.queueNewPaths(nextSequence, neighbours, queue);
                        }
                    }
                });
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        queue.clear();
        if (this.queueSizeLimitExceed || this.sequencesSize >= MAX_COLLECTION_SIZE) {
            System.err.println("WARNING: Memory size limit exceed. Only partial result will be available!");
        }
        return sequences.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewPaths(HashedArrayList<Integer> nextSequence, List<Integer> neighbours, List<HashedArrayList<Integer>> queue) {
        for (Integer nextFragNum : neighbours) {
            if (nextSequence.size() > this.maxBondCount || nextSequence.contains(nextFragNum)) continue;
            HashedArrayList<Integer> sequence = new HashedArrayList<Integer>((Collection<Integer>)nextSequence);
            sequence.add(nextFragNum);
            List<HashedArrayList<Integer>> list = queue;
            synchronized (list) {
                queue.add(sequence);
                this.queueSize += sequence.size();
            }
        }
    }

    private Molecule[] createPrimitiveFragments(MolBond[] neededBonds, Molecule molecule) {
        int i;
        Molecule[] primitiveFragments = null;
        for (i = 0; i < neededBonds.length; ++i) {
            molecule.removeBond(neededBonds[i]);
        }
        primitiveFragments = molecule.convertToFrags();
        if (this.explicitizedOutput) {
            for (i = 0; i < primitiveFragments.length; ++i) {
                primitiveFragments[i].addExplicitHydrogens(2047);
            }
        }
        return primitiveFragments;
    }

    private Map<MolAtom, Integer> createAtomFragmentNumMap(Molecule[] fragments) {
        HashMap<MolAtom, Integer> atomFragmentNumMap = new HashMap<MolAtom, Integer>();
        for (int i = 0; i < fragments.length; ++i) {
            MolAtom[] atoms = fragments[i].getAtomArray();
            for (int j = 0; j < atoms.length; ++j) {
                atomFragmentNumMap.put(atoms[j], i);
            }
        }
        return atomFragmentNumMap;
    }

    private Map<MolAtom, Collection<Integer>> createAtomBondNumsMap(MolBond[] bonds) {
        HashMap<MolAtom, Collection<Integer>> atomBondNumMap = new HashMap<MolAtom, Collection<Integer>>();
        for (int i = 0; i < bonds.length; ++i) {
            HashSet<Integer> bondNums;
            MolAtom atom1 = bonds[i].getAtom1();
            MolAtom atom2 = bonds[i].getAtom2();
            if (!atomBondNumMap.containsKey(atom1)) {
                bondNums = new HashSet<Integer>();
                bondNums.add(i);
                atomBondNumMap.put(atom1, bondNums);
            } else {
                ((Collection)atomBondNumMap.get(atom1)).add(i);
            }
            if (!atomBondNumMap.containsKey(atom2)) {
                bondNums = new HashSet();
                bondNums.add(i);
                atomBondNumMap.put(atom2, bondNums);
                continue;
            }
            ((Collection)atomBondNumMap.get(atom2)).add(i);
        }
        return atomBondNumMap;
    }

    private Map<Integer, Molecule> createFragmentMap(Molecule[] fragments) {
        HashMap<Integer, Molecule> fragmentMap = new HashMap<Integer, Molecule>();
        for (int i = 0; i < fragments.length; ++i) {
            fragmentMap.put(i, fragments[i]);
        }
        return fragmentMap;
    }

    private Map<Integer, List<Integer>> createNeighbourMap(MolBond[] neededBonds, Map<MolAtom, Integer> atomFragmentNumMap, Map<Integer, Molecule> fragmentNumFragmentMap, Map<MolAtom, Collection<Integer>> atomBondNumsMap) {
        int i;
        LinkedHashMap<Integer, List<Integer>> neighbourMap = new LinkedHashMap<Integer, List<Integer>>();
        ArrayList neighbourLists = new ArrayList();
        for (i = 0; i < neededBonds.length; ++i) {
            neighbourLists.add(i, new ArrayList());
            Integer firstFragKey = atomFragmentNumMap.get(neededBonds[i].getAtom1());
            Integer secondFragKey = atomFragmentNumMap.get(neededBonds[i].getAtom2());
            Molecule firstFrag = fragmentNumFragmentMap.get(firstFragKey);
            Molecule secondFrag = fragmentNumFragmentMap.get(secondFragKey);
            MolAtom[] firstFragAtoms = firstFrag.getAtomArray();
            MolAtom[] secondFragAtoms = secondFrag.getAtomArray();
            MolAtom[] atoms = new MolAtom[firstFragAtoms.length + secondFragAtoms.length];
            System.arraycopy(firstFragAtoms, 0, atoms, 0, firstFragAtoms.length);
            System.arraycopy(secondFragAtoms, 0, atoms, firstFragAtoms.length, secondFragAtoms.length);
            for (int j = 0; j < atoms.length; ++j) {
                if (!atomBondNumsMap.containsKey(atoms[j])) continue;
                Collection<Integer> bondNums = atomBondNumsMap.get(atoms[j]);
                for (Integer bondNumKey : bondNums) {
                    int bondNum = bondNumKey;
                    if (i == bondNum || ((List)neighbourLists.get(i)).contains(bondNumKey)) continue;
                    ((List)neighbourLists.get(i)).add(bondNumKey);
                }
            }
        }
        for (i = 0; i < neighbourLists.size(); ++i) {
            neighbourMap.put(i, (List<Integer>)neighbourLists.get(i));
        }
        return neighbourMap;
    }

    private MolBond[] collectNeededBonds(Molecule molecule) {
        int i;
        MolBond[] bonds = molecule.getBondArray();
        ArrayList<MolBond> neededEdges = new ArrayList<MolBond>();
        LinkedHashMap<MolAtom, Integer> atomMap = new LinkedHashMap<MolAtom, Integer>();
        MolAtom[] atoms = molecule.getAtomArray();
        atomMap.clear();
        for (i = 0; i < atoms.length; ++i) {
            atomMap.put(atoms[i], i);
        }
        for (i = 0; i < bonds.length; ++i) {
            MolAtom atom1 = bonds[i].getAtom1();
            MolAtom atom2 = bonds[i].getAtom2();
            if (!(atom1.getAtno() != 6 ^ atom2.getAtno() != 6)) continue;
            MolAtom carbon = atom1.getAtno() == 6 ? atom1 : atom2;
            MolAtom hetero = atom2.equals(carbon) ? atom1 : atom2;
            int atomNum = (Integer)atomMap.get(carbon);
            int[][] ctab = molecule.getCtab();
            int neighbourCount = ctab[atomNum].length;
            for (int j = 0; j < neighbourCount; ++j) {
                MolAtom neighbour = molecule.getAtom(ctab[atomNum][j]);
                if (neighbour.equals(hetero) || neighbour.getAtno() != 6) continue;
                int neighbourBondCount = neighbour.getBondCount();
                for (int k = 0; k < neighbourBondCount; ++k) {
                    MolBond neighbourBond = neighbour.getBond(k);
                    boolean isRingBond = molecule.isRingBond(k);
                    if ((neighbourBond.getType() != 1 || (!this.cleaveAliphaticRingBonds || !isRingBond) && isRingBond) && (neighbourBond.getType() != 4 || !this.cleaveAromaticBonds) || neighbourBond.getOtherAtom(neighbour) != carbon || neededEdges.contains(neighbourBond)) continue;
                    neededEdges.add(neighbourBond);
                }
            }
        }
        return neededEdges.toArray(new MolBond[neededEdges.size()]);
    }

    private boolean isFragmentNeeded(Molecule molecule) {
        boolean needed = false;
        if (molecule.getAtomCount() < 3) {
            return false;
        }
        MolAtom[] atoms = molecule.getAtomArray();
        for (int i = 0; i < atoms.length && !needed; ++i) {
            needed = atoms[i].getAtno() != 6 && atoms[i].getAtno() != 1;
        }
        return needed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HashSet<String> set = new HashSet<String>();
        if (args.length > 1) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-")) continue;
                if (!MoleculeFragmenter.isSwitchCorrect(args[i])) {
                    MoleculeFragmenter.printHelp();
                    return;
                }
                set.add(args[i]);
            }
        }
        if (args.length > 0 && (args[0].equals("--help") || args[0].equals("-h") || !MoleculeFragmenter.containsAllNeededSwitch(set))) {
            MoleculeFragmenter.printHelp();
            return;
        }
        InputStream inputStream = System.in;
        OutputStream output = System.out;
        OutputStream logStream = System.err;
        String format2 = FILTER_SMILES_FORMAT;
        MoleculeFragmenter fragmenter = new MoleculeFragmenter();
        PrintWriter logWriter = new PrintWriter(logStream);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                try {
                    output = new FileOutputStream(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (FileNotFoundException e) {
                    logWriter.println("Error: could not open output file, exiting.");
                    e.printStackTrace(logWriter);
                    logWriter.flush();
                    return;
                }
            }
            if (args[i].equals("-f")) {
                format2 = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-m")) {
                fragmenter.setMaxBondCount(Integer.parseInt(args[i + 1]));
                ++i;
                continue;
            }
            if (args[i].equals("-e")) {
                fragmenter.setExplicitizedOutput(true);
                continue;
            }
            if (args[i].equals("-l")) {
                try {
                    logStream = new FileOutputStream(args[i + 1]);
                    logWriter = new PrintWriter(logStream);
                    ++i;
                }
                catch (IOException exception) {
                    logStream = System.err;
                    logWriter = new PrintWriter(logStream);
                    logWriter.println("Warning: could not open log file, System.err is logStream.");
                }
                continue;
            }
            File file = new File(args[i]);
            if (file.exists()) {
                try {
                    inputStream = new FileInputStream(args[i]);
                    continue;
                }
                catch (IOException e) {
                    logWriter.println("Error: could not read input molecule file, exiting.");
                    e.printStackTrace(logWriter);
                    logWriter.flush();
                    return;
                }
            }
            inputStream = new ByteArrayInputStream(args[i].getBytes());
        }
        int fragmentCount = 0;
        try {
            Molecule molecule;
            MolImporter importer = new MolImporter(inputStream);
            MolExporter exporter = null;
            PrintWriter writer = null;
            if (format2.equals(FILTER_SMILES_FORMAT)) {
                writer = new PrintWriter(output);
            } else {
                exporter = new MolExporter(output, format2);
            }
            while ((molecule = importer.read()) != null) {
                fragmenter.setMolecule(molecule);
                String[] fragments = fragmenter.calculateFragmentsArray();
                fragmentCount += fragments.length;
                for (int i = 0; i < fragments.length; ++i) {
                    if (exporter != null) {
                        exporter.write(MolImporter.importMol(fragments[i]));
                        continue;
                    }
                    if (writer == null) continue;
                    writer.println(fragments[i]);
                }
                output.flush();
            }
            if (exporter != null) {
                exporter.close();
            }
            if (writer != null) {
                writer.close();
            }
            output.close();
            importer.close();
            inputStream.close();
        }
        catch (IOException exception) {
            logWriter.println("Error: some error has occured during fragmenting process, exiting.");
            exception.printStackTrace(logWriter);
            logWriter.flush();
        }
        catch (LicenseException licenseException) {
            logWriter.println("Error: license problem has been found, exiting.");
            licenseException.printStackTrace(logWriter);
            logWriter.flush();
        }
        finally {
            try {
                output.flush();
                output.close();
                inputStream.close();
            }
            catch (IOException exception) {}
        }
    }

    private static void printHelp() {
        System.out.println(HELP_TEXT);
    }

    private static boolean isSwitchCorrect(String switchString) {
        return "-e".equals(switchString) || "-o".equals(switchString) || "-m".equals(switchString) || "-f".equals(switchString) || "-l".equals(switchString);
    }

    private static boolean containsAllNeededSwitch(Set<String> set) {
        return true;
    }

    private static class MoleculeCreator
    implements Runnable {
        private final Collection<String> fragments;
        private final Collection<List<Integer>> sequences;
        private final MolBond[] neededBonds;
        private final Map<Integer, Molecule> fragmentNumFragmentMap;
        private final Map<MolAtom, Integer> atomFragmentNumMap;
        private final SmilesExport smilesExport = new SmilesExport();

        public MoleculeCreator(Collection<String> fragments, Collection<List<Integer>> sequences, MolBond[] neededBonds, Map<Integer, Molecule> fragmentNumFragmentMap, Map<MolAtom, Integer> atomFragmentNumMap) {
            this.fragments = fragments;
            this.sequences = sequences;
            this.neededBonds = neededBonds;
            this.fragmentNumFragmentMap = fragmentNumFragmentMap;
            this.atomFragmentNumMap = atomFragmentNumMap;
            try {
                this.smilesExport.open(MoleculeFragmenter.FILTER_SMILES_FORMAT);
            }
            catch (MolExportException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (List<Integer> sequence : this.sequences) {
                Molecule fragment = new Molecule();
                int n = sequence.size();
                for (int i = 0; i < n; ++i) {
                    Integer bondNum = sequence.get(i);
                    MolBond bond = this.neededBonds[bondNum];
                    Molecule firstFragment = this.fragmentNumFragmentMap.get(this.atomFragmentNumMap.get(bond.getAtom1()));
                    Molecule secondFragment = this.fragmentNumFragmentMap.get(this.atomFragmentNumMap.get(bond.getAtom2()));
                    MolAtom[] firstFragmentAtoms = firstFragment.getAtomArray();
                    MolAtom[] secondFragmentAtoms = secondFragment.getAtomArray();
                    MolAtom[] atoms = new MolAtom[firstFragmentAtoms.length + secondFragmentAtoms.length];
                    System.arraycopy(firstFragmentAtoms, 0, atoms, 0, firstFragmentAtoms.length);
                    System.arraycopy(secondFragmentAtoms, 0, atoms, firstFragmentAtoms.length, secondFragmentAtoms.length);
                    for (int j = 0; j < atoms.length; ++j) {
                        if (fragment.contains(atoms[j])) continue;
                        fragment.add(atoms[j]);
                    }
                    MolBond[] firstFragmentBonds = firstFragment.getBondArray();
                    MolBond[] secondFragmentBonds = secondFragment.getBondArray();
                    MolBond[] bonds = new MolBond[firstFragmentBonds.length + secondFragmentBonds.length];
                    System.arraycopy(firstFragmentBonds, 0, bonds, 0, firstFragmentBonds.length);
                    System.arraycopy(secondFragmentBonds, 0, bonds, firstFragmentBonds.length, secondFragmentBonds.length);
                    for (int j = 0; j < bonds.length; ++j) {
                        if (fragment.contains(bonds[j])) continue;
                        fragment.add(bonds[j]);
                    }
                    fragment.add(bond);
                }
                try {
                    String frag = this.smilesExport.toSMILES(fragment);
                    Collection<String> collection = this.fragments;
                    synchronized (collection) {
                        this.fragments.add(frag);
                    }
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }
    }

    private static class HashedArrayList<T>
    extends ArrayList<T> {
        private static int maxElementCount = 0;
        private static final long serialVersionUID = 4428159751996597847L;

        public HashedArrayList() {
        }

        public HashedArrayList(Collection<T> collection) {
            super(collection);
        }

        public HashedArrayList(int initialCapacity) {
            super(initialCapacity);
        }

        public List<Boolean> hash() {
            Boolean[] hash = new Boolean[maxElementCount];
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                hash[this.get((int)i).hashCode()] = Boolean.TRUE;
            }
            return Arrays.asList(hash);
        }

        public static void setMaxElementCount(int count) {
            maxElementCount = count;
        }
    }
}

