/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem;

import chemaxon.jchem.db.CTColumnRegenerator;
import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.Exporter;
import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.Importer;
import chemaxon.jchem.db.MDRegenerator;
import chemaxon.jchem.db.PreRegeneration;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableStatistics;
import chemaxon.jchem.db.TableTypeConstants;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.Updater;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DotfileUtil;
import chemaxon.util.SupportedPlatform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class Command {
    private static final Logger logger = Logger.getLogger(Command.class.getName());
    public static final String UNKNOWN_OPTION = "unknown option ";
    static final String configFile = new File(DotfileUtil.getDotDir(), ".jchem").getAbsolutePath();
    private static String strhelp = "JChemManager " + VersionInfo.JCHEM_VERSION + ", (C) 2000-2012 ChemAxon Ltd.\n" + "Usage of GUI program:\n" + "        jcman\n" + "Usage of command line program:\n" + "        jcman <command> [options]\n" + "\nCommands:\n" + "c <table>                  create table in database\n" + "t [--rowcount]             list structure tables with or without row numbers\n" + "t <table>                  show information on a structure table\n" + "t <table> <row>            show the specified row\n" + "v                          show version information\n" + "a <table> <file>           import (add molecules) from a file into a table\n" + "x <table> <format>         export table to standard output.\n" + "                           format:\n" + "                               sdf   (MDL SDfile)\n" + "                               mol   (MDL Molfile)\n" + "                               rdf   (MDL RDMolfile)\n" + "                               smi   (Daylight smiles)\n" + "                               mol2  (Tripos Mol2 file)\n" + "                               inchi (IUPAC InChI file)\n" + "                               mrv   (Marvin document)\n" + "x <table> <file>           export a table into a file. (The format will be\n" + "                           determined from the extension:.sdf/.mol/.smi\n" + "                           /.rdf/.mol2/.inchi/.mrv)\n" + "x <table> <file> <field>[:<field>]\n" + "                           exports specific fields from a table into a file\n" + "x <table> <file> |<dbColumnName>:<outputName>[|<dbColumnName>:<outputName>]|\n" + "                           replaces the original names of database columns\n" + "                           to user defined names in the export output file. Can be used\n" + "                           together with the previous export option\n" + "d <table>                  drop (remove) a structure table\n" + "d <table> -where <\"where clause\">\n" + "                           deletes all entries that satisfy the conditions\n" + "                           (valid 'where clause' between double quotes) from\n" + "                           a structure table\n" + "u                          upgrades database structure and recalculates old\n" + "                           tables if necessary (typically after upgrade)\n" + "u --ptid                   upgrades database structure (with recalculation) and\n" + "                           generate a new unique identifier for the currently used\n" + "                           property table. This is needed by the cache if you use\n" + "                           multiple databases or schemas with different property\n" + "                           tables are handling the same JChem table names.\n" + "r                          recalculate all structure tables without Chemical Terms\n" + "r <table>                  recalculate a structure table without Chemical Terms\n" + "r --ct <table>             recalculate only the Chemical Terms columns of a table\n" + "r --md [<table>] [<desc table>]\n" + "                           recalculate only the Molecular Descriptors\n" + "k                          precalculate all structure tables with Chemical Terms\n" + "k <table>                  precalculate a structure table with Chemical Terms\n" + "k --remove [<table>]       remove precalculated data for one or for every table\n" + "s <table>                  calculates and prints statistics for table\n" + "m <table>                  miscellaneous operations on the specified table\n" + "g <global-option>          set options affecting all tables\n" + "\nOptions (general):\n" + "-h --help                  this help message\n" + "   --driver <JDBC driver>  the JDBC driver to use\n" + "   --dburl <url>           the database URL to connect\n" + "   --proptable <table>     the name of property table\n" + "-l --login <login>         login name\n" + "-p --password <password>   password\n" + "-s --saveconf              save settings into\n" + "\"" + configFile + "\"\n" + "\nOptions for table creation:\n" + "   --fplength <n>          fingerprint size in bits    (default depends on table type)\n" + "   --bits <n>              bits to be set for patterns (default depends on table type)\n" + "   --bonds <n>             pattern length              (default depends on table type)\n" + "   --coldefs <column defs> column definitions. If not empty, then syntax is\n" + "                               \", name1 type1, name2 type2, ...\"\n" + "                           see doc of CREATE TABLE on how to define columns\n" + "   --stconfig <file>       standardizer configuration. If not given, default\n" + "                           standardization is used.\n" + "   --relative              only treats as absolute stereo if chiral flag set.\n" + "   --nodup                 does not import molecules already in database\n" + "   --ctcolcfg <cols-exprs> a semicolon separated list of pairs of\n" + "                           column names and Chemical Terms expressions.\n" + "                           Each pair specifies that the values of the given\n" + "                           column should be automatically calculated using\n" + "                           the given Chemical Terms expression.\n" + "                           In each pair, the column name and the\n" + "                           Chemical Terms expression is separated with\n" + "                           an equal sign ('=').\n" + "   --t:<type>              the type of the structure table\n" + "          --t:molecules    Specific structures, like single molecules,\n" + "                           mixtures, salts, polymers\n" + "          --t:any          All types of structures are allowed, but no\n" + "                           structure type-specific searching\n" + "          --t:reactions    single step reactions\n" + "          --t:markush      for the storage of Markush structures (this table type\n" + "                           is not allowed for Ms Access dbms).\n" + "          --t:query        query structures\n" + "   --tds:[y/n]             specify \"y\" to consider tautomers during duplicate\n" + "                           search (default is \"n\")\n" + "\nOption for recalculation :\n" + "   --stconfig <file>       standardizer configuration. If not given, there is\n" + "                           no change in the standardizer configuration.\n" + "                           Specify \"reset_to_default\" to change to default\n" + "                           standardization.\n" + "   --tds:[y/n]             specify \"y\"to consider tautomers during duplicate\n" + "                           search (default is \"n\")\n" + "\nOptions for import:\n" + "   --connect <connections> assign custom table fields to SDFile tags\n" + "                           Note: If not given, only those SDFile tags will be imported\n" + "                           which have identical field names in the structure table\n" + "                           Example: --connect \"dbfield1=sdfield1;dbfield2=sdfield2\"\n" + "   --nametofield <field>   name of the database field which should store the\n" + "                           structures' names\n" + "   --skip <n>              skip the first n molecules in SD file\n" + "   --records <n>           check only the first n records for field names\n" + "   --noempty               does not import empty molecules\n" + "   --setchiralflag         sets chiral flag for MDL file formats.\n" + "   --diff                  does not import ANY molecules, only output\n" + "   --duplicates            write duplicate molecules to output\n" + "   --nonduplicates         write non-duplicate molecules to output\n" + "   --output                redirects output to a file (otherwise stdout)\n" + "\nOptions for export:\n" + "   --where <condition>     where clause. Example: --where \"cd_id<1000\"\n" + "\nOptions for miscellaneous table management operations (command 'm'):\n" + "   --add-ctcolcfg <opt>    adds Chemical Terms expressions to existing user-\n" + "                           defined columns. <opt> has the same format as the\n" + "                           argument to the --ctcolcfg parameter of the 'c'\n" + "                           (create table) command. The columns specified\n" + "                           must have no Chemical Terms expression\n" + "                           assigned to them.\n" + "   --set-ctcolcfg <opt>    sets Chemical Terms expressions to existing user-\n" + "                           defined columns. <opt> has the same format as the\n" + "                           argument to the --ctcolcfg parameter of the 'c'\n" + "                           (create table) command. The columns specified may\n" + "                           have Chemical Terms expressions already assigned\n" + "                           to them.\n" + "   --del-ctcolcfg <opt>    removes the assignment of Chemical Terms expressions\n" + "                           from existing user-defined columns. <opt> is\n" + "                           a semi-colon-separated list of column names.\n" + "   --set-abs-stereo (true|false)" + "                           Sets the Absolute Stereo table option.\n" + "   --set-dupl-filtering (true|false)" + "                           Sets the Duplicate Filtering table option.\n" + "   --set-use-tautomers (true|false)" + "                           Sets the 'Duplicate search uses tautomers' table option.\n" + "                           Note: Recalculation is needed after the change." + "   --set-switchoff-prots (true|false)" + "                           Sets the 'Switch off all protections for tautomer \n" + "                           duplicate checks' table option.\n" + "                           Note: Recalculation is needed after the change.\n" + "\nExamples:\n" + "$ jcman c strdata --coldefs \", name CHAR(200), stock INTEGER\"\\\n" + "   --fplength 256 -l joe --driver com.mysql.jdbc.Driver\\\n" + "   --dburl jdbc:mysql://localhost/mydb -s\n" + "$ jcman c ctcols --coldefs \", logp numeric(18,9), rotbl_bnd_cnt numeric(1,0)\"\\\n" + "   --ctcolcfg \"logp=logp();rotbl_bnd_cnt=rotatableBondCount()>4\"\n" + "...\n" + "$ jcman a str3d str3d.sdf.gz\n" + "$ jcman a str3d str3d.sdf.gz --connect \"MOLNAME=NAME;PH=PH_VAL\"\n" + "$ jcman t --rowcount\n" + "                                              Precalc.     Precalc.  Precalc.  Precalc.  Precalc.\n" + "    Table name              Version     Rows  recommended  version    status    valid    invalid rows\n" + "  1 str3d                   5020100   198556       N\n" + "  2 testdata                5020100     4260       Y       5020100    READY       Y                16\n" + "$ jcman t ncidata\n" + "    Column name     Type name\n" + "  1 cd_id           LONG\n" + "  2 cd_structure    BLOB\n" + "...\n" + " 18 cd_fp16         LONG\n" + "$ jcman m strtable --add-ctcolcfg \"logp=logp();rotbl_bnd_cnt=rotatableBondCount()>4\"\n" + "\n" + "See http://www.chemaxon.com/jchem/doc/admin/index.html for more information.";
    private static boolean isExitAllowed = true;
    private boolean duplicatesAllowed = true;
    private boolean emptyAllowed = true;
    private boolean setChiralFlag = false;
    private boolean absoluteStereo = true;
    private Boolean tautomerFiltering = null;
    private boolean setPropTableId = false;
    private boolean forceYes = false;

    public static void main(String[] args) {
        Command cmd = new Command();
        cmd.run(args);
    }

    public static void mainWithoutExit(String[] args) {
        isExitAllowed = false;
        Command.main(args);
    }

    protected static void exit(int exitCode) {
        if (isExitAllowed) {
            System.exit(exitCode);
        } else if (exitCode != 0) {
            throw new RuntimeException("jcsearch exit:" + exitCode);
        }
    }

    public void run(String[] args) {
        ConnectionHandler conh;
        String jvmWarning;
        String command = null;
        String connections = null;
        String nameField = "";
        int row = -1;
        int offset = 0;
        boolean saveprops = false;
        String s = null;
        Properties props = new Properties();
        Properties cmd = new Properties();
        StructureTableOptions options = new StructureTableOptions();
        boolean setFPLength = true;
        boolean setBits = true;
        boolean setBonds = true;
        String coldefs = "";
        String stconfig = null;
        if (args.length == 0) {
            System.err.println(strhelp);
            Command.exit(0);
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String ss;
                s = args[i];
                if (s.equals("--help")) {
                    System.err.println(strhelp);
                    Command.exit(0);
                    continue;
                }
                if (s.equals("--version")) {
                    command = "v";
                    continue;
                }
                if ("--force-yes".equalsIgnoreCase(s)) {
                    this.forceYes = true;
                    continue;
                }
                if (s.equals("--saveconf") || s.equals("-s")) {
                    saveprops = true;
                    continue;
                }
                if (s.equals("--nodup")) {
                    this.duplicatesAllowed = false;
                    continue;
                }
                if (s.equals("--noempty")) {
                    this.emptyAllowed = false;
                    continue;
                }
                if (s.equals("--diff")) {
                    cmd.put("import.diff", "true");
                    continue;
                }
                if (s.equals("--duplicates")) {
                    cmd.put("import.matching", "true");
                    continue;
                }
                if (s.equals("--nonduplicates")) {
                    cmd.put("import.nonmatching", "true");
                    continue;
                }
                if (s.equals("--relative")) {
                    this.absoluteStereo = false;
                    continue;
                }
                if (s.equals("--setchiralflag")) {
                    this.setChiralFlag = true;
                    continue;
                }
                if (s.equals("--ptid")) {
                    this.setPropTableId = true;
                    continue;
                }
                if (s.equals("--get-commit-interval")) {
                    cmd.put("option.name", "get.commit.interval");
                    continue;
                }
                if (s.equals("--md")) {
                    String[] ss2 = new String[2];
                    if (args.length > i + 1 && args[i + 1].charAt(0) != '-') {
                        ss2[0] = args[++i];
                        if (args.length > i + 1 && args[i + 1].charAt(0) != '-') {
                            ss2[1] = args[++i];
                        }
                    }
                    cmd.put("regeneration.md", ss2);
                    continue;
                }
                if (s.startsWith("--")) {
                    int j = s.indexOf(61);
                    if (j == -1) {
                        j = s.indexOf(58);
                    }
                    if (j > 0) {
                        ss = s.substring(j + 1);
                        s = s.substring(0, j);
                    } else {
                        ss = args[++i];
                    }
                    if (s.equals("--dburl")) {
                        cmd.put("connection.jdbcUrl", ss);
                        continue;
                    }
                    if (s.equals("--driver")) {
                        cmd.put("connection.jdbcDriver", ss);
                        continue;
                    }
                    if (s.equals("--login")) {
                        cmd.put("connection.login", ss);
                        continue;
                    }
                    if (s.equals("--password")) {
                        cmd.put("connection.password", ss);
                        continue;
                    }
                    if (s.equals("--proptable")) {
                        cmd.put("connection.propertyTable", ss);
                        continue;
                    }
                    if (s.equals("--connect")) {
                        connections = ss;
                        continue;
                    }
                    if (s.equals("--where")) {
                        cmd.put("where.clause", ss);
                        continue;
                    }
                    if (s.equals("--skip")) {
                        offset = Integer.parseInt(ss);
                        continue;
                    }
                    if (s.equals("--records")) {
                        cmd.put("import.numberOfRecords", ss);
                        continue;
                    }
                    if (s.equals("--output")) {
                        cmd.put("import.output", ss);
                        continue;
                    }
                    if (s.equals("--ct")) {
                        cmd.put("regeneration.ct", ss);
                        continue;
                    }
                    if (s.equals("--noct")) {
                        cmd.put("regeneration.noct", ss);
                        continue;
                    }
                    if (s.equals("--nametofield")) {
                        nameField = ss;
                        continue;
                    }
                    if (s.equals("--fplength")) {
                        setFPLength = false;
                        int l = Integer.parseInt(ss);
                        if (l % 32 != 0) {
                            throw new IllegalArgumentException("Error: fingerprint length must be dividable by 32.");
                        }
                        options.fp_numberOfInts = l /= 32;
                        continue;
                    }
                    if (s.equals("--bits")) {
                        setBits = false;
                        options.fp_numberOfOnes = Integer.parseInt(ss);
                        continue;
                    }
                    if (s.equals("--bonds")) {
                        setBonds = false;
                        options.fp_numberOfEdges = Integer.parseInt(ss);
                        continue;
                    }
                    if (s.equals("--coldefs")) {
                        coldefs = ss;
                        continue;
                    }
                    if (s.equals("--stconfig")) {
                        stconfig = ss;
                        continue;
                    }
                    if (s.equals("--ctcolcfg")) {
                        options.chemTermColsConfig = Command.parseChemTermColsCfg(ss);
                        continue;
                    }
                    if (s.equals("--t")) {
                        String typeString = ss;
                        if (typeString.equalsIgnoreCase("any")) {
                            options.tableType = 2;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("molecules")) {
                            options.tableType = 0;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("markush")) {
                            options.tableType = 3;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("reactions")) {
                            options.tableType = 1;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("query")) {
                            options.tableType = 4;
                            continue;
                        }
                        System.err.println("Unknown table type: \"" + typeString + "\"");
                        Command.exit(1);
                        continue;
                    }
                    if (s.equalsIgnoreCase("--tdf") || s.equalsIgnoreCase("--tds")) {
                        if (ss.equalsIgnoreCase("y")) {
                            this.tautomerFiltering = Boolean.TRUE;
                            continue;
                        }
                        if (ss.equalsIgnoreCase("n")) {
                            this.tautomerFiltering = Boolean.FALSE;
                            continue;
                        }
                        System.err.println("Unknown option for tautomer duplicate search: \"" + ss + "\"");
                        Command.exit(1);
                        continue;
                    }
                    if (s.equals("--add-ctcolcfg")) {
                        cmd.put("ctcolcfg.op", "add");
                        cmd.put("ctcolcfg", Command.parseChemTermColsCfg(ss));
                        continue;
                    }
                    if (s.equals("--set-ctcolcfg")) {
                        cmd.put("ctcolcfg.op", "set");
                        cmd.put("ctcolcfg", Command.parseChemTermColsCfg(ss));
                        continue;
                    }
                    if (s.equals("--del-ctcolcfg")) {
                        cmd.put("ctcolcfg.op", "del");
                        cmd.put("ctcolcfg", ss);
                        continue;
                    }
                    if (s.equals("--set-commit-interval")) {
                        cmd.put("option.name", "set.commit.interval");
                        cmd.put("commit.interval.value", ss);
                        continue;
                    }
                    if (s.equals("--set-dupl-filtering")) {
                        cmd.put("table.option.name", "duplicateFiltering");
                        cmd.put("table.option.value", ss);
                        continue;
                    }
                    if (s.equals("--set-abs-stereo")) {
                        cmd.put("table.option.name", "absoluteStereo");
                        cmd.put("table.option.value", ss);
                        continue;
                    }
                    if (s.equals("--set-use-tautomers")) {
                        cmd.put("table.option.name", "tautomerDuplicateFiltering");
                        cmd.put("table.option.value", ss);
                        continue;
                    }
                    if (s.equals("--set-switchoff-prots")) {
                        cmd.put("table.option.name", "switchOffAllProtections");
                        cmd.put("table.option.value", ss);
                        continue;
                    }
                    System.err.println(UNKNOWN_OPTION + s);
                    Command.exit(1);
                    continue;
                }
                block45: for (int j = 0; j < s.length(); ++j) {
                    switch (s.charAt(j)) {
                        case 'h': {
                            System.out.println(strhelp);
                            Command.exit(0);
                            continue block45;
                        }
                        case 'c': {
                            if (command != null) continue block45;
                            command = "c";
                            options.name = args[++i];
                            continue block45;
                        }
                        case 't': {
                            if (command != null) continue block45;
                            command = "t";
                            if (i + 1 >= args.length) continue block45;
                            ss = args[i + 1];
                            if (ss.equals("--rowcount")) {
                                cmd.put("list.count", "true");
                                ++i;
                                continue block45;
                            }
                            if (ss.charAt(0) == '-') continue block45;
                            command = "t ".concat(ss);
                            if (++i + 1 >= args.length || (ss = args[i + 1]).charAt(0) == '-') continue block45;
                            row = Integer.parseInt(ss);
                            ++i;
                            continue block45;
                        }
                        case 'a': {
                            if (command != null) continue block45;
                            command = "a";
                            cmd.put("import.selectedTable", args[++i]);
                            cmd.put("import.fileName", args[++i]);
                            continue block45;
                        }
                        case 'x': {
                            if (command != null) continue block45;
                            command = "x";
                            cmd.put("export.selectedTable", args[++i]);
                            cmd.put("export.fileName", args[++i]);
                            while (args.length > ++i) {
                                String fields = args[i];
                                if (fields.startsWith("--")) {
                                    --i;
                                    continue block45;
                                }
                                if (args[i].contains("|")) {
                                    cmd.put("export.fieldConversion", fields);
                                    continue;
                                }
                                fields = fields.replace(':', ' ');
                                cmd.put("export.selectedFields", fields);
                            }
                            continue block45;
                        }
                        case 'd': {
                            if (command != null) continue block45;
                            command = "d";
                            cmd.put("delete.selectedTable", args[++i]);
                            if (args.length <= i + 1 || !args[i + 1].equalsIgnoreCase("-where")) continue block45;
                            ++i;
                            String whereClause = "WHERE " + args[++i];
                            cmd.put("delete.rows.query", whereClause);
                            continue block45;
                        }
                        case 'l': {
                            cmd.put("connection.login", args[++i]);
                            continue block45;
                        }
                        case 'p': {
                            cmd.put("connection.password", args[++i]);
                            continue block45;
                        }
                        case 's': {
                            if (command != null) continue block45;
                            command = "s";
                            if (i + 1 >= args.length || (ss = args[i + 1]).charAt(0) == '-') continue block45;
                            command = "s ".concat(ss);
                            ++i;
                            continue block45;
                        }
                        case 'r': {
                            if (command != null) continue block45;
                            command = "r";
                            if (i + 1 >= args.length || (ss = args[i + 1]).charAt(0) == '-') continue block45;
                            command = "r ".concat(ss);
                            ++i;
                            continue block45;
                        }
                        case 'k': {
                            if (command != null) continue block45;
                            command = "k";
                            if (i + 1 >= args.length) continue block45;
                            if (args[i + 1].equals("--remove")) {
                                cmd.put("precalculation.remove", "true");
                                if (++i + 1 >= args.length) continue block45;
                                cmd.put("precalculation.table", args[++i]);
                                continue block45;
                            }
                            cmd.put("precalculation.table", args[++i]);
                            if (i + 1 >= args.length) continue block45;
                            cmd.put("precalculation.remove", "true");
                            ++i;
                            continue block45;
                        }
                        case 'u': {
                            if (command != null) continue block45;
                            command = "u";
                            continue block45;
                        }
                        case 'v': {
                            if (command != null) continue block45;
                            command = "v";
                            continue block45;
                        }
                        case 'm': {
                            if (command != null) continue block45;
                            command = "m";
                            cmd.put("manage.table", args[++i]);
                            continue block45;
                        }
                        case 'g': {
                            if (command != null) continue block45;
                            command = "g";
                            continue block45;
                        }
                        default: {
                            if (s.charAt(0) == '-' && j == 0) continue block45;
                            System.err.println(UNKNOWN_OPTION + s.charAt(j));
                            Command.exit(1);
                        }
                    }
                }
            }
        }
        catch (NumberFormatException exc) {
            System.err.println("Argument for option " + s + " must be integer");
            Command.exit(1);
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            System.err.println("Argument missing for option " + s);
            Command.exit(1);
        }
        if (command == null) {
            System.err.println("Command required: a, c, d, g, k, m, r, t, u, v, x");
            Command.exit(1);
        }
        SettingsHandler settingsHandler = null;
        try {
            settingsHandler = new SettingsHandler();
            props = settingsHandler.getSettings();
        }
        catch (IOException exc) {
            Command.exit(1);
        }
        Enumeration<?> e = cmd.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            props.remove(key);
            props.put(key, cmd.get(key));
        }
        if (saveprops) {
            try {
                settingsHandler.save();
            }
            catch (IOException exc) {
                Command.exit(1);
            }
        }
        if ((jvmWarning = SupportedPlatform.getJavaVersionErrorString(props)) != null) {
            logger.warning(jvmWarning + "\n" + "Supported SUN compatible JREs can be downloaded from:\n" + "http://www.oracle.com/technetwork/java/javase/downloads/index.html");
        }
        if (!(conh = new ConnectionHandler()).loadValuesFromProperties(props)) {
            System.err.println("More properties needed to make the connection.");
            Command.exit(1);
        }
        try {
            conh.connect();
            if (!DatabaseProperties.propertyTableExists(conh)) {
                DatabaseProperties.createPropertyTable(conh);
                System.out.println("Table " + conh.getPropertyTable() + " has been created.\n" + "It will store information on tables containing structures.\n" + "If necessary, please grant read/write access rights on this table to users.\n");
            }
        }
        catch (Exception exc) {
            System.err.println("Cannot connect:");
            exc.printStackTrace();
            Command.exit(1);
        }
        switch (command.charAt(0)) {
            case 'u': {
                this.updateTables(conh);
                break;
            }
            case 'c': {
                if (setFPLength) {
                    options.fp_numberOfInts = TableTypeConstants.FP_DEFAULT_LENGTH_IN_INTS[options.tableType];
                }
                if (setBits) {
                    options.fp_numberOfOnes = TableTypeConstants.FP_DEFAULT_BITS_PER_PATTERN[options.tableType];
                }
                if (setBonds) {
                    options.fp_numberOfEdges = TableTypeConstants.FP_DEFAULT_PATTERN_LENGTH[options.tableType];
                }
                if (!this.duplicatesAllowed) {
                    options.duplicateFiltering = !this.duplicatesAllowed;
                }
                this.createTable(conh, options, coldefs, stconfig);
                break;
            }
            case 't': {
                if (command.length() > 2) {
                    String tableName = command.substring(2);
                    if (row >= 0) {
                        Command.viewRow(conh, tableName, row);
                        break;
                    }
                    Command.viewTable(conh, props, tableName);
                    break;
                }
                Command.listTables(conh, cmd.get("list.count") != null);
                break;
            }
            case 'a': {
                if (!this.duplicatesAllowed) {
                    System.out.println("WARNING: '--nodup' option has been a table option from version 5.4. It can be used at table creation.");
                }
                this.importFromFile(conh, props, connections, nameField, offset);
                break;
            }
            case 'x': {
                Command.exportToFile(conh, props);
                break;
            }
            case 'd': {
                if (cmd.get("delete.rows.query") != null) {
                    Command.deleteTableRows(conh, props);
                    break;
                }
                Command.deleteTable(conh, props);
                break;
            }
            case 'r': {
                if (cmd.get("regeneration.ct") != null) {
                    this.regenerateCTColumns(conh, cmd.get("regeneration.ct").toString());
                    break;
                }
                if (cmd.get("regeneration.noct") != null) {
                    this.regenerateWithoutCT(conh, cmd.get("regeneration.noct").toString(), stconfig);
                    break;
                }
                if (cmd.get("regeneration.md") != null) {
                    String[] ss = (String[])cmd.get("regeneration.md");
                    this.regenerateMDColumns(conh, ss[0], ss[1]);
                    break;
                }
                if (command.length() > 2) {
                    String tableName = command.substring(2);
                    this.regenerateTable(conh, tableName, stconfig);
                    break;
                }
                this.regenerateTables(conh, stconfig);
                break;
            }
            case 'k': {
                String table = (String)cmd.get("precalculation.table");
                String remove = (String)cmd.get("precalculation.remove");
                if (table == null) {
                    if (remove == null) {
                        this.precalculateTables(conh, stconfig);
                        break;
                    }
                    this.removePrecalculatedData(conh);
                    break;
                }
                try {
                    if (Command.checkTableExists(conh, table)) {
                        if (remove == null) {
                            this.precalculateTable(conh, table, stconfig);
                            break;
                        }
                        System.out.print("Remove precalculated data for table " + table + " ... ");
                        PreRegeneration pr = new PreRegeneration(conh);
                        pr.removeTempTable(table);
                        System.out.println("  Done.");
                        break;
                    }
                    System.out.println("Table not found: " + table);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case 's': {
                if (command.length() <= 2) break;
                String tableName = command.substring(2);
                Command.printTableStatistics(conh, tableName);
                break;
            }
            case 'm': {
                this.manageTable(conh, cmd);
                break;
            }
            case 'g': {
                this.globalOptions(conh, cmd);
                break;
            }
            case 'v': {
                Command.versionInfo();
            }
        }
        try {
            conh.close();
        }
        catch (SQLException e1) {
            // empty catch block
        }
    }

    private static Map<String, String> parseChemTermColsCfg(String ctColCfgString) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(ctColCfgString, ";");
        while (tokenizer.hasMoreTokens()) {
            String ss = tokenizer.nextToken();
            int eqsPos = ss.indexOf(61);
            if (eqsPos == -1) {
                System.err.println("Invalid format for --ctcolcfg: " + ss);
                Command.exit(1);
            }
            map.put(ss.substring(0, eqsPos).toUpperCase(), ss.substring(eqsPos + 1));
        }
        return map;
    }

    private void updateTables(ConnectionHandler conh) {
        try {
            Updater ud = new Updater(conh);
            Updater.UpdateInfo ui = null;
            while ((ui = ud.getNextUpdateInfo()) != null) {
                String message;
                if (!this.forceYes) {
                    if (Command.displayMessage(ui)) {
                        System.out.println("\n" + ui.processingMessage + "\n");
                        message = ud.performCurrentUpdate();
                        System.out.println(message);
                        continue;
                    }
                    if (!ui.isOperationRequired) continue;
                    break;
                }
                message = ud.performCurrentUpdate();
                System.out.println(message);
            }
            System.out.println("Done.");
            if (this.setPropTableId) {
                DatabaseOptions.setPropertyTableIdentifier(new DatabaseProperties(conh));
                System.out.println("New property table identifier has been generated");
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Command.exit(1);
        }
    }

    private static boolean displayMessage(Updater.UpdateInfo ui) throws IOException {
        System.out.println("\n\n\n");
        System.out.println(ui.message);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean perform = false;
        String[] objects = ui.entityList;
        while (true) {
            if (objects != null) {
                System.out.print("Perform operation  ([Y]es / [N]o / [L]ist objects) ? : ");
            } else {
                System.out.print("Perform operation  ([Y]es / [N]o) ? : ");
            }
            String line = in.readLine();
            line = line.toUpperCase();
            if (line.equals("Y") || line.equals("YES")) {
                perform = true;
                break;
            }
            if (line.equals("N") || line.equals("NO")) {
                perform = false;
                break;
            }
            if (!line.equals("L") && !line.equals("LIST") || objects == null) continue;
            Command.listTables(objects);
        }
        return perform;
    }

    private static void listTables(String[] oldTables) throws IOException {
        System.out.println("\n");
        for (int x = 0; x < oldTables.length; ++x) {
            if (x % 20 == 19) {
                System.out.print("Press [enter] to continue ...");
                new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            System.out.println(oldTables[x]);
        }
        System.out.println("\n");
    }

    private static String getStandardizerConfig(String configFileName) throws IOException {
        String standardizerConfig = null;
        if (configFileName != null) {
            File configFile = new File(configFileName);
            try {
                BufferedReader br = new BufferedReader(new FileReader(configFile));
                standardizerConfig = "";
                String line = null;
                while ((line = br.readLine()) != null) {
                    standardizerConfig = standardizerConfig + line + "\n";
                }
                br.close();
            }
            catch (IOException e) {
                System.err.println("Error while reading custom standardizer configuration from file.");
                throw e;
            }
        }
        return standardizerConfig;
    }

    private void createTable(ConnectionHandler conh, StructureTableOptions options, String coldefs, String stconfig) {
        try {
            options.standardizerConfig = Command.getStandardizerConfig(stconfig);
            options.absoluteStereo = this.absoluteStereo;
            options.tautomerDuplicateChecking = this.tautomerFiltering == null ? false : this.tautomerFiltering;
            options.extraColumnDefinitions = coldefs;
            UpdateHandler.createStructureTable(conh, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            Command.exit(1);
        }
    }

    private static void listTables(ConnectionHandler conh, boolean count) {
        block14: {
            try {
                DatabaseProperties dbProp = new DatabaseProperties(conh);
                Enumeration<String> e = dbProp.getStructureTableNames().elements();
                if (e.hasMoreElements()) {
                    Command.print("", count ? 73 : 62);
                    Command.print("Precalc.", 13);
                    for (int i = 0; i < (count ? 4 : 3); ++i) {
                        Command.print("Precalc.", 10);
                    }
                    System.out.println();
                    Command.print("", 3);
                    System.out.print(" ");
                    Command.print("Table name", 45);
                    System.out.print(" ");
                    Command.print("Version", 10);
                    System.out.print(" ");
                    if (count) {
                        Command.print("      Rows", 10);
                        System.out.print(" ");
                    }
                    System.out.print(" ");
                    Command.print("recommended", 12);
                    System.out.print(" ");
                    Command.print("version", 10);
                    System.out.print(" ");
                    Command.print("status", 9);
                    System.out.print(" ");
                    Command.print("valid", 8);
                    System.out.print(" ");
                    if (count) {
                        Command.print("invalid rows", 12);
                    }
                    System.out.println();
                    PreRegeneration pr = new PreRegeneration(conh);
                    int i = 0;
                    while (e.hasMoreElements()) {
                        String tableName = e.nextElement();
                        Command.print(i + 1, 3);
                        System.out.print(" ");
                        Command.print(tableName, 45);
                        System.out.print(" ");
                        String tableVersion = dbProp.getTableProperty(tableName, "version");
                        Command.print(tableVersion, 10);
                        System.out.print(" ");
                        int rowCount = 0;
                        if (count) {
                            rowCount = DBUtil.getRowCount(conh.getConnection(), tableName);
                            Command.print(rowCount, 10);
                            System.out.print(" ");
                        }
                        String prVersion = pr.getVersion(tableName);
                        boolean isValid = pr.isValid(tableName);
                        int regenNeeded = RegenerationChecker.isRegenerationNeeded(tableName, dbProp);
                        if (!(regenNeeded != 1 || prVersion != null && prVersion.equals(tableVersion) && isValid)) {
                            Command.print("      Y", 14);
                        } else {
                            Command.print("      N", 14);
                        }
                        if (prVersion != null) {
                            Command.print(prVersion, 9);
                            System.out.print(" ");
                            String status = pr.getStatus(tableName);
                            Command.print(status != null && status.equals("1") ? "  READY" : "NOT READY", 10);
                            System.out.print(" ");
                            Command.print(isValid ? "  Y" : "  N", 7);
                            if (count) {
                                System.out.print(" ");
                                try {
                                    Command.print(rowCount - UpdateHandler.getPrecalculatedRowNumber(conh, tableName), 13);
                                }
                                catch (SQLException ex) {
                                    Command.print("        ERROR", 13);
                                }
                            }
                        }
                        System.out.println();
                        ++i;
                    }
                    break block14;
                }
                System.out.println("There are no structure tables in the database.");
            }
            catch (SQLException exc) {
                System.err.println("Cannot get table information:");
                exc.printStackTrace();
                Command.exit(1);
            }
        }
    }

    private static void versionInfo() {
        System.out.println("JChem version: " + VersionInfo.JCHEM_VERSION);
        System.out.println("Table version: " + VersionInfo.JCHEM_TABLE_VERSION);
        System.out.println();
    }

    private static void viewTable(ConnectionHandler conh, Properties props, String tableName) {
        try {
            String standardizerConfig = null;
            tableName = TableInfo.getTableNameWithSchema(conh.getConnection(), tableName);
            DatabaseProperties dbProp = new DatabaseProperties(conh);
            int tableType = dbProp.getTableType(tableName);
            String tableTypeString = TableTypeConstants.TABLE_TYPE_NAMES[tableType];
            System.out.println("\nTable type: " + tableTypeString + "\n");
            String tableVersion = dbProp.getTableProperty(tableName, "version");
            System.out.println("Table version: " + tableVersion + "\n");
            String tautomerString = dbProp.isTautomerDuplicateFilteringEnabled(tableName) ? "Yes" : "No";
            System.out.println("Uses tautomers for duplicate search: " + tautomerString + "\n");
            String duplicateFilteringOption = dbProp.isDuplicateFilteringOption(tableName) ? "Yes" : "No";
            System.out.println("Filters out the duplicate structures: " + duplicateFilteringOption + "\n");
            TableInfo tableFields = TableInfo.getTableInfo(conh, props, tableName);
            int numberOfBits = FingerprintHandler.getNumberOfBits(conh, tableName, false);
            int numberOfOnes = FingerprintHandler.getNumberOfOnes(conh, tableName, false);
            int numberOfEdges = FingerprintHandler.getNumberOfEdges(conh, tableName, false);
            System.out.println("Fingerprint settings:\n");
            System.out.println("\tLength (bits): " + numberOfBits + "\n\tPattern length: " + numberOfEdges + "\n\tBits per pattern: " + numberOfOnes);
            standardizerConfig = TableInfo.getStandardizerConfig(conh, tableName);
            if (standardizerConfig != null) {
                System.out.println("\nCustom standardization configuration:\n----------------------------------------\n" + standardizerConfig + "\n" + "----------------------------------------\n");
            } else {
                System.out.println("\nTable uses default standardization.\n");
            }
            Enumeration<FieldInfo> e = tableFields.elements();
            Command.print("", 3);
            System.out.print(" ");
            Command.print("Column name", 15);
            System.out.print(" ");
            Command.print("Type name", 15);
            System.out.println();
            int i = 1;
            while (e.hasMoreElements()) {
                FieldInfo fi = e.nextElement();
                String name = fi.getName();
                String tname = fi.getTypeName();
                Command.print(i, 3);
                System.out.print(" ");
                Command.print(name, 15);
                System.out.print(" ");
                Command.print(tname, 15);
                System.out.println();
                ++i;
            }
        }
        catch (Exception exc) {
            System.err.println("Cannot get field information.");
            exc.getMessage();
            exc.printStackTrace();
            Command.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void viewRow(ConnectionHandler conh, String tableName, int row) {
        try {
            String ss = "SELECT * FROM " + tableName + " LIMIT " + row + ", 1";
            int rdbms = DatabaseOptions.getDBMSType(conh);
            if (rdbms == 6) {
                ss = "SELECT * FROM " + tableName + " LIMIT 1 OFFSET " + (row - 1);
            }
            Statement st = conh.getConnection().createStatement();
            try {
                ResultSet rs = st.executeQuery(ss);
                try {
                    boolean success = rs.next();
                    if (!success) {
                        System.err.println("No such row: " + row);
                        st.close();
                        return;
                    }
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int cols = rsmd.getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        String name = rsmd.getColumnName(i);
                        System.out.print("--------------------");
                        Command.print(i, 3);
                        System.out.print(" ");
                        Command.print(name, 15);
                        System.out.println(" --------------------");
                        String s = rs.getString(i);
                        if (s == null) continue;
                        System.out.println(s);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                st.close();
            }
        }
        catch (SQLException exc) {
            System.err.println("Cannot get row information:");
            exc.printStackTrace();
            Command.exit(1);
        }
    }

    private static void print(int i, int w) {
        String s = "                                " + i;
        System.out.print(s.substring(s.length() - w));
    }

    private static void print(String s, int w) {
        if (s == null) {
            s = "-";
        }
        s = s.concat("                                                                                             ");
        System.out.print(s.substring(0, w));
    }

    private void importFromFile(ConnectionHandler conh, Properties props, String connections, String nameField, int offset) {
        String fname = (String)props.get("import.fileName");
        String tname = (String)props.get("import.selectedTable");
        boolean diffMode = props.get("import.diff") != null;
        String output = (String)props.get("import.output");
        boolean exportMatching = props.get("import.matching") != null;
        boolean exportNonMatching = props.get("import.nonmatching") != null;
        try {
            int nl = 0;
            String snl = (String)props.get("import.numberOfRecords");
            if (snl != null) {
                try {
                    nl = Integer.parseInt(snl);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
            }
            Importer importer = new Importer();
            importer.setConnectionHandler(conh);
            importer.setInput(fname);
            importer.setTableName(tname);
            importer.setLinesToCheck(nl);
            importer.setHaltOnError(false);
            importer.setEmptyStructuresAllowed(this.emptyAllowed);
            int duplAllowed = this.duplicatesAllowed ? 0 : 1;
            importer.setDuplicateImportAllowed(duplAllowed);
            importer.setSetChiralFlag(this.setChiralFlag);
            importer.setFieldConnections(connections);
            importer.setInfoStream(System.err);
            importer.setNameFieldInDB(nameField);
            System.err.println("Collecting file information ...");
            importer.init();
            System.err.println(" Done.");
            if (offset > 0) {
                System.err.println("Skipping " + offset + " structures ...");
                importer.skip(offset);
                System.err.println(" Done.");
            }
            String msg = "structures from " + fname + " ...";
            msg = !diffMode ? "Importing " + msg : "Collecting " + msg;
            System.err.println(msg);
            OutputStream os = System.out;
            if (output != null) {
                os = new FileOutputStream(output);
            }
            importer.setOutputOptions(exportMatching, exportNonMatching, os, diffMode);
            long start = System.currentTimeMillis();
            int imported = importer.importMols();
            long end = System.currentTimeMillis();
            long time = end - start;
            int duplicates = importer.getDuplicates();
            int processed = importer.getStructCount();
            int empties = importer.getEmptyStructures();
            DatabaseProperties dbProp = new DatabaseProperties(conh);
            String results = "";
            results = results + "\nTotal number of processed molecules: " + processed + "\n";
            if (dbProp.isDuplicateFilteringOption(tname) || !this.duplicatesAllowed) {
                results = results + "Not imported (duplicates): " + duplicates + "\n";
            }
            if (!this.emptyAllowed) {
                results = results + "Not imported (empty): " + empties + "\n";
            }
            results = results + "Not imported (error): " + (processed - duplicates - empties - imported) + "\n";
            results = results + "Successfully imported: " + imported;
            String timeString = "" + (int)Math.ceil((double)time / 1000.0);
            results = results + "\nElapsed time: " + timeString + " seconds";
            System.err.println(results);
            System.err.println(" Done.");
        }
        catch (Throwable exc) {
            System.err.print("Cannot import to table.\n" + exc.getMessage());
            exc.printStackTrace();
            Command.exit(1);
        }
    }

    private void precalculateTables(ConnectionHandler conh, String stconfig) {
        try {
            Enumeration<String> e = new DatabaseProperties(conh).getStructureTableNames().elements();
            while (e.hasMoreElements()) {
                String tableName = e.nextElement();
                this.precalculateTable(conh, tableName, stconfig);
            }
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            Command.exit(1);
        }
    }

    private void precalculateTable(ConnectionHandler conh, String tableName, String stconfig) {
        block7: {
            System.out.print("Precalculating " + tableName + " ... ");
            try {
                DatabaseProperties dbProps;
                int regenType;
                boolean changeStandardization = false;
                String standardizerConfig = null;
                if (stconfig != null) {
                    changeStandardization = true;
                    if (!stconfig.equals("reset_to_default")) {
                        standardizerConfig = Command.getStandardizerConfig(stconfig);
                    }
                }
                if ((regenType = RegenerationChecker.getRegenerationTypeForTable(dbProps = new DatabaseProperties(conh), tableName)) == 1) {
                    String[] columns = dbProps.getChemTermColumns(tableName);
                    UpdateHandler.recalculateCTColumns(conh, tableName, columns, new ProgressWriter("", 1L, 1L), 1);
                    break block7;
                }
                if (regenType == 2) {
                    UpdateHandler.recalculateWithoutCTColumns(conh, tableName, changeStandardization, standardizerConfig, this.tautomerFiltering, new ProgressWriter("", 1L, 1L), 1);
                    break block7;
                }
                if (regenType == 0) {
                    UpdateHandler.recalculateTable(conh, tableName, changeStandardization, standardizerConfig, null, this.tautomerFiltering, new ProgressWriter("", 1L, 1L), 1);
                    break block7;
                }
                System.out.println("  Recalculation is not needed.");
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                Command.exit(1);
            }
        }
        System.out.println("  Done.");
    }

    private void removePrecalculatedData(ConnectionHandler conh) {
        System.out.print("Remove precalculated data ... ");
        try {
            PreRegeneration pr = new PreRegeneration(conh);
            Enumeration<String> e = new DatabaseProperties(conh).getStructureTableNames().elements();
            while (e.hasMoreElements()) {
                String tableName = e.nextElement();
                pr.removeTempTable(tableName);
            }
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            Command.exit(1);
        }
        System.out.println("  Done.");
    }

    private void regenerateTables(ConnectionHandler conh, String stconfig) {
        try {
            Enumeration<String> e = new DatabaseProperties(conh).getStructureTableNames().elements();
            while (e.hasMoreElements()) {
                String tableName = e.nextElement();
                this.regenerateTable(conh, tableName, stconfig);
            }
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            Command.exit(1);
        }
    }

    private void regenerateTable(ConnectionHandler conh, String tableName, String stconfig) {
        this.regenerateTable(conh, tableName, stconfig, null);
    }

    private void regenerateTable(ConnectionHandler conh, String tableName, String stconfig, Map chemTermColCfg) {
        System.out.print("Recalculating " + tableName + " ... ");
        try {
            boolean changeStandardization = false;
            String standardizerConfig = null;
            if (stconfig != null) {
                changeStandardization = true;
                if (!stconfig.equals("reset_to_default")) {
                    standardizerConfig = Command.getStandardizerConfig(stconfig);
                }
            }
            UpdateHandler.recalculateTable(conh, tableName, changeStandardization, standardizerConfig, chemTermColCfg, this.tautomerFiltering, new ProgressWriter("", 1L, 1L));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Command.exit(1);
        }
        System.out.println("  Done.");
    }

    private void regenerateCTColumns(ConnectionHandler conh, String tableName) {
        System.out.print("Recalculating Chemical Terms in table " + tableName + " ... ");
        try {
            DatabaseProperties dbProp = new DatabaseProperties(conh);
            String[] columns = dbProp.getChemTermColumns(tableName);
            if (columns.length > 0) {
                UpdateHandler.recalculateCTColumns(conh, tableName, columns, new ProgressWriter("", 1L, 1L));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            Command.exit(1);
        }
        System.out.println("  Done.");
    }

    private void regenerateWithoutCT(ConnectionHandler conh, String tableName, String stconfig) {
        System.out.print("Recalculating table " + tableName + " without Chemical Terms columns... ");
        try {
            boolean changeStandardization = true;
            String standardizerConfig = null;
            if (stconfig != null) {
                changeStandardization = true;
                if (!stconfig.equals("reset_to_default")) {
                    standardizerConfig = Command.getStandardizerConfig(stconfig);
                }
            }
            UpdateHandler.recalculateWithoutCTColumns(conh, tableName, changeStandardization, standardizerConfig, this.tautomerFiltering, new ProgressWriter("", 1L, 1L));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Command.exit(1);
        }
        System.out.println("  Done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerateMDColumns(ConnectionHandler conh, String strucTableName, String descriptor) {
        try {
            MDRegenerator regen = new MDRegenerator(conh);
            try {
                if (strucTableName == null) {
                    System.out.println("Recalculating all Molecular Descriptors ...");
                    regen.run();
                } else if (descriptor == null) {
                    System.out.println("Recalculating Molecular Descriptors in table '" + strucTableName + "' ... ");
                    regen.run(strucTableName);
                } else {
                    System.out.println("Recalculating Molecular Descriptor '" + descriptor + "' in table '" + strucTableName + "' ... ");
                    regen.run(strucTableName, descriptor);
                }
            }
            finally {
                regen.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            Command.exit(1);
        }
        System.out.println("  Done.");
    }

    private static void printTableStatistics(ConnectionHandler conh, String tableName) {
        System.out.print("\nCollecting statistics for table: " + tableName + " ... \n");
        try {
            TableStatistics ts = new TableStatistics();
            ts.collectStatisitcs(conh, tableName);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Command.exit(1);
        }
    }

    private static void exportToFile(ConnectionHandler conh, Properties props) {
        String fname = (String)props.get("export.fileName");
        String tname = (String)props.get("export.selectedTable");
        String fieldString = (String)props.get("export.selectedFields");
        String fieldConversion = (String)props.get("export.fieldConversion");
        String whereClause = (String)props.get("where.clause");
        try {
            OutputStream os;
            boolean toStdOut = fname.toLowerCase().equals("smi") || fname.toLowerCase().equals("mol") || fname.toLowerCase().equals("sdf") || fname.toLowerCase().equals("jtf") || fname.toLowerCase().equals("mrv") || fname.toLowerCase().equals("rdf") || fname.toLowerCase().equals("mol2") || fname.toLowerCase().equals("inchi");
            int format2 = FileInfo.getFormat(fname);
            if (format2 == -1) {
                System.err.println("Unrecognized file format");
                Command.exit(1);
            }
            if (toStdOut) {
                os = System.out;
            } else {
                File file = new File(fname);
                os = new FileOutputStream(file);
                System.err.println("Exporting structures into " + fname + " ...");
            }
            Exporter ex = new Exporter();
            ex.setConnectionHandler(conh);
            ex.setTableName(tname);
            ex.setFieldList(fieldString);
            ex.setOutputFieldConversion(fieldConversion);
            ex.setOutputStream(os);
            ex.setFormat(format2);
            if (whereClause != null && whereClause.length() > 0) {
                ex.setConditions("where " + whereClause);
            }
            ex.setDefaults(true);
            int written = ex.writeAll();
            System.err.println(written + " molecules were exported.");
            if (!toStdOut) {
                System.err.println(" Done.");
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            Command.exit(1);
        }
    }

    private static void deleteTable(ConnectionHandler conh, Properties props) {
        String tname = (String)props.get("delete.selectedTable");
        try {
            UpdateHandler.dropStructureTable(conh, tname);
            System.out.println("Table " + tname + " dropped.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            Command.exit(1);
        }
    }

    private static void deleteTableRows(ConnectionHandler conh, Properties props) {
        String tableName = (String)props.get("delete.selectedTable");
        String query = props.getProperty("delete.rows.query");
        try {
            UpdateHandler.deleteRows(conh, tableName, query);
            System.out.println("Selected table entries were deleted.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            Command.exit(1);
        }
    }

    private void manageTable(ConnectionHandler conh, Properties cmd) {
        String tableName = cmd.getProperty("manage.table");
        if (tableName == null) {
            System.err.println("Missing table name.");
            Command.exit(1);
        }
        try {
            tableName = TableInfo.getTableNameWithSchema(conh.getConnection(), tableName);
            if (!Command.checkTableExists(conh, tableName)) {
                throw new IllegalArgumentException("JChem table " + tableName + " cannot be found in JChem properties table " + conh.getPropertyTable());
            }
            if (cmd.get("ctcolcfg") != null) {
                this.manageChemTermColsCfg(conh, tableName, cmd);
            } else if (cmd.getProperty("table.option.name") != null && cmd.get("table.option.value") != null) {
                DatabaseProperties dbProps = new DatabaseProperties(conh);
                dbProps.setTableProperty(tableName, cmd.getProperty("table.option.name"), cmd.getProperty("table.option.value"));
            } else {
                System.err.println("Missing parameter for command 'm' (manage JChem table)");
                Command.exit(1);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Command.exit(1);
        }
        System.out.println("Done.");
    }

    private static boolean checkTableExists(ConnectionHandler ch, String argTableName) throws SQLException {
        boolean found = false;
        DatabaseProperties dbProps = new DatabaseProperties(ch);
        Vector<String> tableNames = dbProps.getStructureTableNames();
        for (int i = 0; i < tableNames.size(); ++i) {
            int dotPos;
            String tableName = tableNames.get(i);
            if (argTableName.indexOf(46) == -1 && (dotPos = tableName.indexOf(46)) != -1) {
                tableName = tableName.substring(dotPos + 1);
            }
            if (!tableName.equalsIgnoreCase(argTableName)) continue;
            found = true;
            break;
        }
        return found;
    }

    private void manageChemTermColsCfg(ConnectionHandler conh, String tableName, Properties cmd) throws Exception {
        tableName = TableInfo.getTableNameWithSchema(conh.getConnection(), tableName);
        String op = cmd.getProperty("ctcolcfg.op");
        if (op.equals("add")) {
            Map ctColCfg = (Map)cmd.get("ctcolcfg");
            this.addChemTermColCfg(conh, tableName, ctColCfg);
        } else if (op.equals("set")) {
            Map ctColCfg = (Map)cmd.get("ctcolcfg");
            Command.setChemTermColCfg(conh, tableName, ctColCfg);
        } else if (op.equals("del")) {
            String ctColList = (String)cmd.get("ctcolcfg");
            Command.delChemTermColCfg(conh, tableName, ctColList);
        }
    }

    private void addChemTermColCfg(ConnectionHandler conh, String tableName, Map ctColCfg) throws Exception {
        Set newCtColNames = ctColCfg.keySet();
        DatabaseProperties dbProps = new DatabaseProperties(conh);
        String[] ctColNames = dbProps.getChemTermColumns(tableName);
        for (int i = 0; i < ctColNames.length; ++i) {
            String ctColName = ctColNames[i];
            if (!newCtColNames.contains(ctColName)) continue;
            String existingCtExpression = dbProps.getChemTermForColumn(tableName, ctColName);
            throw new IllegalArgumentException("Column " + ctColName + " is already configured to use " + existingCtExpression);
        }
        Command.setChemTermColCfg(conh, tableName, ctColCfg);
    }

    private static void setChemTermColCfg(ConnectionHandler conh, String tableName, Map ctColCfg) throws Exception {
        DatabaseProperties dbProps = new DatabaseProperties(conh);
        TableInfo.saveChemTermColNamesAndExprs(conh, dbProps, tableName, ctColCfg);
        String[] ctColNames = ctColCfg.keySet().toArray(new String[0]);
        CTColumnRegenerator ctColumnRegenerator = new CTColumnRegenerator(conh, tableName, ctColNames, null, 0);
        ctColumnRegenerator.run();
    }

    private static void delChemTermColCfg(ConnectionHandler conh, String tableName, String ctColList) throws Exception {
        DatabaseProperties dbProps = new DatabaseProperties(conh);
        String[] ctColNames = dbProps.getChemTermColumns(tableName);
        List<String> ctColNameList = Arrays.asList(ctColNames);
        ArrayList<String> delCtColList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(ctColList, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String delCtColName = stringTokenizer.nextToken().toUpperCase();
            if (!ctColNameList.contains(delCtColName)) {
                throw new IllegalArgumentException("Column " + delCtColName + " has no Chemical Terms expression assigned to it");
            }
            delCtColList.add(delCtColName);
        }
        for (String delCtColName : delCtColList) {
            dbProps.deleteChemTermForColumn(tableName, delCtColName);
        }
    }

    private void globalOptions(ConnectionHandler conh, Properties cmd) {
        block6: {
            String optionName = cmd.getProperty("option.name");
            if (optionName == null) {
                System.err.println("Mission option for command 'g'.");
                Command.exit(1);
            }
            try {
                if (optionName.equals("set.commit.interval")) {
                    String commintValueStr = cmd.getProperty("commit.interval.value");
                    if (commintValueStr == null) {
                        System.err.println("Missing parameter for the --commit-interval global option");
                        Command.exit(1);
                    }
                    int commitInterval = Integer.parseInt(commintValueStr);
                    DatabaseProperties prop = new DatabaseProperties(conh);
                    DatabaseOptions.setCommitInterval(prop, commitInterval);
                    System.out.println("Commit interval has been successfully set");
                    break block6;
                }
                if (optionName.equals("get.commit.interval")) {
                    System.out.println("Commit interval: " + DatabaseOptions.getCommitInterval(new DatabaseProperties(conh)));
                    break block6;
                }
                throw new IllegalArgumentException("Unknown global option: " + optionName);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                Command.exit(1);
            }
        }
    }
}

