/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem;

import chemaxon.reaction.Standardizer;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.util.CLQ;
import java.io.File;
import java.util.ArrayList;

public abstract class SearchBase
implements SearchConstants {
    protected static final String lineSep = System.getProperty("line.separator");
    public static final String searchOptionsHelp = "--orderSensitive              Switches on order sensitive search" + lineSep + "--tautomerSearch:d/y/n        Tautomer search mode: d-default, y-on, n-off." + lineSep + "                              When set to d, tautomer search is off," + lineSep + "                              except in case of duplicate search in" + lineSep + "                              a tautomer duplicate database table." + lineSep + "--tdf:y/n                     Use generic tautomers of query and target." + lineSep + "                              Effective only in case of duplicate search." + lineSep + "                              Default is n." + lineSep + "--exactAtomMatching:y/n       Exact atom matching(y) or not(n). Default is n." + lineSep + "                              (Deprecated.)" + lineSep + "--exactQueryAtomMatching:y/n  Exact query atom matching(y) or not(n)." + lineSep + "                              Default is n." + lineSep + "--exactRadicalMatching:y/n    Exact radical matching(y) or not(n)." + lineSep + "                              Default is n. (--radical is preferred instead.)" + lineSep + "--exactIsotopeMatching:y/n    Exact isotope matching(y) or not(n)." + lineSep + "                              Default is n. (--isotope is preferred instead.)" + lineSep + "--exactChargeMatching:y/n     Exact charge matching(y) or not(n)." + lineSep + "                              Default is n. (--charge is preferred instead.)" + lineSep + "--charge:d/e/i                Charge matching mode: d-default," + lineSep + "                              e-exact, i-ignore" + lineSep + "                              --charge:i forces --implicitHMatching:i in case of" + lineSep + "                              duplicate search" + lineSep + "--isotope:d/e/i               Isotope matching mode: d-default," + lineSep + "                              e-exact, i-ignore" + lineSep + "--radical:d/e/i               Radical matching mode: d-default," + lineSep + "                              e-exact, i-ignore" + lineSep + "--valence:d/i                 Valence matching mode: d-default, i-ignore" + lineSep + "--vagueBond:n/1/2/3/4         Vague handling of bond types:" + lineSep + "                               n - off," + lineSep + "                               1 - handling of certain 5-membered ambiguous" + lineSep + "                                   aromatic rings like [C,N]1C=CC=C1 (default)" + lineSep + "                               2 - all single and double ring bonds" + lineSep + "                                   match aromatic" + lineSep + "                               3 - all single and double bonds" + lineSep + "                                   match aromatic " + lineSep + "                               4 - ignore all bond types." + lineSep + "--completeHG:y/n              Sets if only such structures can match on a " + lineSep + "                              homology group that form an entire group. (e.g. " + lineSep + "                              alkyl can't match on a cycloalkyl). default:y" + lineSep + "--chekSpHyb                   Switch on sp hybridization checking." + lineSep + "--mix:d/i                     Handling of com, mix and for brackets: d-default," + lineSep + "                                i-ignore" + lineSep + "--polymer:d/i                 Handling of polymer brackets: d-default," + lineSep + "                                i-ignore" + lineSep + "--endGroupMatching:y/n        Polymer end groups must match: y-yes," + lineSep + "                                n-no (default: yes)" + lineSep + "--transformMonomer:y/n        Polymer in their source based representation" + lineSep + "                              are transformed to structure based : y-yes," + lineSep + "                                n-no (default: yes)" + lineSep + "--phaseShift:y/n              Polymers match the phase shifted variant:" + lineSep + "                              y-yes, n-no (default: yes)" + lineSep + "--copolymerMatching:y/n       Polymers in copolymers can only be matched by" + lineSep + "                              copolymers: y-yes, n-no (default: no)" + lineSep + "--homologyNarrowTranslation:n/a/m  Query homology pseudo atoms are matching" + lineSep + "                              on the represented group or only on pseudo: " + lineSep + "                              n-none, a - all, m - marked atoms only  " + lineSep + "                              (default: none)" + lineSep + "--homologyBroadTranslation:n/a/m  If specific atoms can match target  " + lineSep + "                              homology atoms: " + lineSep + "                              n-none, a - all, m - marked atoms only  " + lineSep + "                              (default: none)" + lineSep + "--doubleBondStereo:N/M/A      Double bond stereo Matching mode:None/Marked/All" + lineSep + "                              Default is M." + lineSep + "--stereoSearchType:s/i/e/d/a    Sets the stereo search type." + lineSep + "                               Possible values:" + lineSep + "                               s - stereo specific searching (default)," + lineSep + "                               i - ignore stereo, " + lineSep + "                               e - exact stereo," + lineSep + "                               d - diastereomer search" + lineSep + "                               a - enantiomer search" + lineSep + "--stereoModel:l/g/c           Sets the used stereo model (for tetrahedral and " + lineSep + "                              double bond stereo). Possible values:" + lineSep + "                              l - local, g - global, c - comprehensive" + lineSep + "--ignoreTetrahedralStereo:y/n Option for ignoring tetrahedral stereo " + lineSep + "                              during searching: y-yes ignore, n-no" + lineSep + "                              (default: no)" + lineSep + "--ignoreDoubleBondStereo:y/n  Option for ignoring double bond stereo " + lineSep + "                              during searching: y-yes ignore, n-no" + lineSep + "                              (default: no)" + lineSep + "--ignoreAlleneStereo:y/n      Option for ignoring allene stereo " + lineSep + "                              during searching: y-yes ignore, n-no" + lineSep + "                              (default: yes)" + lineSep + "--ignoreAxialStereo:y/n       Option for ignoring axial stereo " + lineSep + "                              during searching: y-yes ignore, n-no" + lineSep + "                              (default: yes)" + lineSep + "--ignoreSynAntiStereo:y/n     Option for ignoring syn-anti stereo " + lineSep + "                              during searching: y-yes ignore, n-no" + lineSep + "                              (default: yes)" + lineSep + "--reactionUnpairedMap:All/unpairedOnly   Option for matching unpaired maps in " + lineSep + "                                         reaction search:" + lineSep + "                                   All(default): match to any atom map, " + lineSep + "                                   unPairedOnly: match to unpaired map only. " + lineSep + "--HCountMatching:G/E/A        Hydrogen count query property interpretation." + lineSep + "      Values:" + lineSep + "        G    (greater or equal, mdl behaviour) target atom must have H-s" + lineSep + "             greater or equal to query H-s, in excess of explicit H-s. " + lineSep + "             H0 means no extra H other than explicitly drawn." + lineSep + "        E    (equal, daylight behaviour) target atom must have H-s equal to " + lineSep + "             H count number." + lineSep + "        A    automatically determine whether G or E should be used, from the" + lineSep + "             query source. (smiles and smarts source: E, all other: G)." + lineSep + "--implicitHMatching:d/y/n/i   Describes the matching of implicit and " + lineSep + "                              explicit hydrogens." + lineSep + "      Values:" + lineSep + "        d   Default: its value is y in almost every cases." + lineSep + "            There is only one exception: its value is n in case of duplicate" + lineSep + "            search against a query table in a database." + lineSep + "        y   Implicit and explicit hydrogens can match. In case of duplicate" + lineSep + "\t     searchThe sum of implicit and explicit hydrogens of the query atom" + lineSep + "\t     and the sum on the matched target atom must equal." + lineSep + "        n   Explicit hydrogens matches only on another explicit hydrogen. The " + lineSep + "            number of implicit hydrogens (of the matching atoms) are not checked." + lineSep + "        i   Implicit and explicit hydrogens are ignored. Hydrogens are excluded" + lineSep + "            from the matching." + lineSep + "            For a more detailed explanation see:" + lineSep + "\t     http://www.chemaxon.com/jchem/doc/dev/java/api/chemaxon/sss/search/SearchOptions.html#setImplicitHMatching(int)" + lineSep + "--ssrType:s/c   Describes the set of smallest rings to use for atom " + lineSep + "                              property calculations." + lineSep + "      Values:" + lineSep + "        s   Smallest set of smallest rings(SSSR), may vary depending on atom orders." + lineSep + "        c   Complete set of smallest rings(CSSR)." + lineSep + "--keepQueryOrder              Does not rearrange the atoms of the query which " + lineSep + "                              is done to achieve best search performance." + lineSep + "--markush:n/y                 Disable/enable special handling of" + lineSep + "                              Markush targets. Default is n." + lineSep + "                              Enabling requires special license. " + lineSep + "--hitIndexType:m/i            For Markush targets returns hits for the " + lineSep + "                              original Markush diagram (m - default) or for the" + lineSep + "                              inner compiled representation (i)(See --allHits)." + lineSep + "--hitOrdering:n/g             Hit ordering type for undefined R-atom" + lineSep + "                              atom-group matches." + lineSep + "                               Possible values:" + lineSep + "                               n - none (default)," + lineSep + "                               g - order hits by R-atom matches processed" + lineSep + "                                   in the order of R-group numbers:" + lineSep + "                                   1. heavy group, 2. H atom, 3. empty group" + lineSep + "--optimizeQueries:y/n         Tries to speed up search when query molecule " + lineSep + "                              contains special query features (atom lists, " + lineSep + "                              bond lists) Default is y." + lineSep + "--distinctFirstAtomMatching:n/y   Disable/enable special findAll algorithm." + lineSep + "                              If set, the hits must have different first atoms." + lineSep + "                              Default is n." + lineSep + "--attachedDataMatch           Describes whether attached data" + lineSep + "                              is compared." + lineSep + "      Values:" + lineSep + "        i   Default: ignores attached data when checks matching." + lineSep + "        g   general: if attached data is present in query, it must be" + lineSep + "            present in target as well." + lineSep + "        e   exact: existing attached data must match" + lineSep + "            both in query and target." + lineSep + "--attachedDataMatchPrefixes   Comma separated list of name prefixes" + lineSep + "                              (of attached data labels), that will be" + lineSep + "                              compared. When not set or set to empty" + lineSep + "                              string all attached data is checked. " + lineSep + "                              Effective only when attachedDataMatch" + lineSep + "                              is not set to 'i'." + lineSep + "--timeoutLimitMilliseconds    The search timeouts reaching this number" + lineSep + "\t\t\t       of milliseconds. Setting to -1 means no " + lineSep + "\t\t\t       timeout (Default 120000)" + lineSep + "--exhaustiveModeLimit         Upon reaching this number of steps, the " + lineSep + "\t\t\t       search switches to exhaustive mode from " + lineSep + "\t\t\t       fast mode. Setting to -1 means never." + lineSep + "\t\t\t       (Default -1)" + lineSep;
    public static final String absoluteStereoHelp = "--queryAbsoluteStereo:y/n     All chiral atoms are absolute(y, default) or" + lineSep + "                              consider chiral flag(n) in case of MDL mol files" + lineSep + "                              w/o enhanced stereo labels." + lineSep + "--targetAbsoluteStereo:y/n    All chiral atoms are absolute(y, default) or" + lineSep + "                              consider chiral flag(n) in case of MDL mol files" + lineSep + "                              w/o enhanced stereo labels.";
    public static final String absoluteStereoDBIncludedHelp = "--queryAbsoluteStereo:y/n     All chiral atoms are absolute(y, default) or" + lineSep + "                              consider chiral flag(n) in case of MDL mol files" + lineSep + "                              w/o enhanced stereo labels. Has no effect in" + lineSep + "                              database mode." + lineSep + "--targetAbsoluteStereo:y/n    All chiral atoms are absolute(y, default) or" + lineSep + "                              consider chiral flag(n) in case of MDL mol files" + lineSep + "                              w/o enhanced stereo labels. Has no effect in" + lineSep + "                              database mode." + lineSep + "--DBAbsoluteStereo:T/C/A      In database mode, sets the above two" + lineSep + "                              AbsoluteStereo flags." + lineSep + "                                T:(default) as set for table in database." + lineSep + "                                C: always check chiral flag(false)" + lineSep + "                                A: always absolute stereo(true)";
    protected Standardizer queryStandardizer = null;
    protected Standardizer targetStandardizer = null;
    protected boolean ignoreError = false;
    protected CLQ clq = null;
    protected ArrayList searchIntOptions = new ArrayList();
    protected int searchType = 2;
    protected static final int COUNTHITS = 100;
    protected float dissimilarityThreshold = 0.3f;
    protected boolean searchTypeSet = false;

    protected abstract MolSearchOptions getSearchOptions();

    public void setParameters(String[] args) throws Exception {
        MolSearchOptions mso = this.getSearchOptions();
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.startsWith("-t") || s.startsWith("--t:")) {
                this.handleSearchTypeOption(s, args, i, s.indexOf(116));
                this.searchTypeSet = true;
                continue;
            }
            if (s.startsWith("--")) {
                String[] nv = this.splitNV(s);
                try {
                    mso.setOption(nv[0], nv[1]);
                    args[i] = "";
                }
                catch (IllegalArgumentException e) {
                    argsList.add(s);
                }
                continue;
            }
            argsList.add(s);
        }
        args = new String[argsList.size()];
        argsList.toArray(args);
        this.clq = new CLQ(args, null);
        CLQ.Parameter p = this.clq.lookup("-S", "--standardize", "", 2, false, false);
        if (p != null) {
            String stconfig = p.getString();
            if (stconfig != null) {
                File file = new File(stconfig);
                if (file.exists()) {
                    this.queryStandardizer = new Standardizer(file);
                    this.targetStandardizer = new Standardizer(file);
                } else {
                    this.queryStandardizer = new Standardizer(stconfig);
                    this.targetStandardizer = new Standardizer(stconfig);
                }
                this.queryStandardizer.setActiveGroup("query");
                this.queryStandardizer.setInactiveTasks("removeexplicith");
                this.targetStandardizer.setActiveGroup("target");
            } else {
                throw new IllegalArgumentException("error: no standardizer configuration supplied after " + p.getString());
            }
        }
        this.ignoreError = this.clq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
    }

    protected void handleSearchTypeOption(String s, String[] args, int i, int j) {
        char c;
        MolSearchOptions mso = this.getSearchOptions();
        if (j < s.length() - 2 && ((c = s.charAt(j + 1)) == ':' || c == '=')) {
            String value = s.substring(j + 2);
            if ("c".equals(value)) {
                mso.setSearchType(2);
                this.searchType = 100;
            } else if (value.startsWith("i")) {
                this.searchType = 3;
                if (s.length() > j + 4) {
                    String num = s.substring(j + 4);
                    this.dissimilarityThreshold = new Float(num).floatValue();
                }
                mso.setSearchType(3);
            } else {
                mso.setOption("t", value);
                this.searchType = mso.getSearchType();
            }
        }
        args[i] = "";
    }

    private String[] splitNV(String s) {
        int ci = s.indexOf(58);
        String[] rsa = new String[2];
        if (ci == -1) {
            rsa[0] = s.substring(2);
            rsa[1] = "";
        } else {
            rsa[0] = s.substring(2, ci);
            rsa[1] = ci == s.length() ? "" : s.substring(ci + 1);
        }
        return rsa;
    }
}

