/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.LinkedBlockingQueue;

public class Unique {
    private static final String FORMAT_DEFAULT = "SMILES";
    private static final int DB_CHUNK_SIZE = 10000;
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helpText = "JChem Duplicate Filtering Utility " + VersionInfo.JCHEM_VERSION + ", (C) 2000-2012 ChemAxon Ltd." + lineSep + "Usage: jcunique [options] [input sources]" + lineSep + "Input source can be standard input specified by \"-\", files or " + lineSep + "database tables DB:[table name]. Utility can handle multiple input sources." + lineSep + "Options:" + lineSep + "-f format  output format (default: smiles)" + lineSep + "-o file    write output to file, if not specified standard output is used.";
    private ArrayList<Object> inputs = new ArrayList();
    private ArrayList<String> inputOptions = new ArrayList();
    private String outputFormat = null;
    private OutputStream output = null;
    private ConnectionHandler ch;
    private UpdateHandler uh;
    private String inputTableName;
    private static String tableName = "JC_UNIQUE_";
    private LinkedBlockingQueue<String> results = new LinkedBlockingQueue();
    private LinkedBlockingQueue<String> candidates = new LinkedBlockingQueue();
    private DuplicateFilteringThread dft;
    private ResultWriterThread rwt;
    private long time;

    private void setParameters(String[] args) {
        block9: for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String s = args[argIndex];
            if (s.equals("-")) {
                this.inputs.add(System.in);
                this.inputOptions.add("");
                continue;
            }
            if (s.startsWith("--")) continue;
            if (s.startsWith("-")) {
                char c = s.charAt(1);
                switch (c) {
                    case 'f': {
                        if (++argIndex == args.length) {
                            System.err.println("error: output format not specified");
                            this.exit(1);
                            break;
                        }
                        this.outputFormat = args[argIndex];
                        if (MFileFormatUtil.getFormat(this.outputFormat) != null) continue block9;
                        System.err.println("error: unrecognized output format");
                        this.exit(1);
                        break;
                    }
                    case 'o': {
                        ++argIndex;
                        if (this.output != null) {
                            System.err.println("error: more than one output file specified");
                            this.exit(1);
                            break;
                        }
                        if (argIndex == args.length) {
                            System.err.println("error: Please specify a file name for option \"-o\" using the following syntax: -o filename");
                            this.exit(1);
                            break;
                        }
                        s = args[argIndex];
                        try {
                            this.output = new FileOutputStream(s);
                        }
                        catch (Exception ex) {
                            System.err.println(s.concat(": cannotopen for writing"));
                            this.exit(1);
                        }
                        break;
                    }
                    default: {
                        System.err.println("Unknown option: -" + c);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                        break;
                    }
                }
                continue;
            }
            if (s.startsWith("DB")) {
                this.inputs.add(s);
                this.inputOptions.add("");
                continue;
            }
            String[] parts = MFileFormatUtil.splitFileAndOptions(s);
            this.inputs.add(parts[0]);
            this.inputOptions.add(parts[1] == null ? "" : parts[1]);
            try {
                FileInputStream is = new FileInputStream(s);
                ((InputStream)is).close();
                continue;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (IOException ex) {
                System.err.println(s.concat(": cannot open"));
                this.exit(1);
            }
        }
        if (this.inputs.size() == 0) {
            this.inputs.add(System.in);
        }
        if (this.output == null) {
            this.output = System.out;
        }
        if (this.outputFormat == null) {
            this.outputFormat = FORMAT_DEFAULT;
        }
    }

    private void init() {
        Random rnd = new Random();
        tableName = tableName + Math.abs(rnd.nextLong());
        StructureTableOptions opts = new StructureTableOptions();
        opts.name = tableName;
        opts.duplicateFiltering = true;
        this.uh = null;
        try {
            SettingsHandler settingsHandler = new SettingsHandler();
            Properties props = settingsHandler.getSettings();
            this.ch = new ConnectionHandler();
            this.ch.loadValuesFromProperties(props);
            this.ch.connectToDatabase();
            if (!DatabaseProperties.propertyTableExists(this.ch)) {
                DatabaseProperties.createPropertyTable(this.ch);
            }
            try {
                UpdateHandler.dropStructureTable(this.ch, tableName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            UpdateHandler.createStructureTable(this.ch, opts);
            this.uh = new UpdateHandler(this.ch, 1, tableName, null);
        }
        catch (Exception ex) {
            System.err.println("error: unable to connect to database: " + ex.getMessage());
            ex.printStackTrace();
            this.exit(1);
        }
    }

    private void run() {
        MolInputStream mis = null;
        this.dft = new DuplicateFilteringThread();
        this.dft.start();
        this.rwt = new ResultWriterThread();
        this.rwt.start();
        try {
            for (int inputIndex = 0; inputIndex < this.inputs.size(); ++inputIndex) {
                String s;
                block14: {
                    Object input = this.inputs.get(inputIndex);
                    String option = this.inputOptions.get(inputIndex);
                    try {
                        if (input instanceof InputStream) {
                            mis = input instanceof MolInputStream ? (MolInputStream)input : new MolInputStream((InputStream)input);
                            break block14;
                        }
                        if (input instanceof File) {
                            File f = (File)input;
                            if (option.equals("")) {
                                option = MFileFormatUtil.getUnguessableFormat(f.getName());
                            }
                            mis = new MolInputStream((InputStream)new FileInputStream(f), option, null, f.getPath());
                            break block14;
                        }
                        if (!(input instanceof String)) break block14;
                        s = (String)input;
                        if (s.startsWith("DB:")) {
                            this.inputTableName = s.substring(3, s.length());
                            if (this.ch == null) continue;
                            this.runDatabase();
                            continue;
                        }
                        if (!MFileFormatUtil.isURLOrFileName((String)input)) {
                            if (option.equals("")) {
                                option = "cxsmiles";
                            }
                            mis = new MolInputStream((InputStream)new ByteArrayInputStream(s.getBytes()), option, null, s);
                        } else {
                            if (option.equals("")) {
                                option = MFileFormatUtil.getUnguessableFormat(s);
                            }
                            mis = option == null || !option.equals("") ? new MolInputStream((InputStream)new FileInputStream(s), option, null, s) : new MolInputStream((InputStream)new FileInputStream(s), null, null, s);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(input + ": error reading input stream.");
                        continue;
                    }
                }
                MolImporter molImporter = new MolImporter(mis);
                while ((s = molImporter.readRecordAsText()) != null) {
                    this.candidates.put(s);
                }
            }
            this.dft.halt();
        }
        catch (Exception ex) {
            System.err.println("Error while reading input: " + ex.getMessage());
            ex.printStackTrace();
            this.exit(1);
        }
    }

    private void runDatabase() {
        JChemSearch searcher = new JChemSearch();
        searcher.setQueryStructure("");
        searcher.setConnectionHandler(this.ch);
        searcher.setStructureTable(this.inputTableName);
        JChemSearchOptions jcso = new JChemSearchOptions(2);
        searcher.setSearchOptions(jcso);
        try {
            searcher.run();
            int chunkCount = (searcher.getResultCount() - 1) / 10000 + 1;
            for (int chunkIndex = 0; chunkIndex < chunkCount; ++chunkIndex) {
                Molecule[] mols = searcher.getHitsAsMolecules(Arrays.copyOfRange(searcher.getResults(), chunkIndex * 10000, Math.min(searcher.getResults().length, (chunkIndex + 1) * 10000)), null, new ArrayList(), new ArrayList());
                for (int molIndex = 0; molIndex < mols.length; ++molIndex) {
                    this.candidates.put(mols[molIndex].toFormat("mrv"));
                }
            }
        }
        catch (NoSuchElementException ex) {
        }
        catch (Exception ex) {
            System.err.println(this.inputTableName + ": error while reading table.");
            this.exit(1);
        }
    }

    private void testDuplicates() {
        try {
            Scanner in = new Scanner(new FileInputStream("nci100000.smiles"));
            HashSet<String> set = new HashSet<String>();
            while (in.hasNext()) {
                String s = in.next();
                set.add(MolImporter.importMol(s).toFormat("smiles:u"));
                in.next();
            }
            System.out.println(set.size() + " distinct structures.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exit(int exitCode) {
        try {
            UpdateHandler.dropStructureTable(this.ch, tableName);
            this.ch.close();
        }
        catch (Exception ex) {
            System.err.println("Unexpected error: " + ex.getMessage());
            ex.printStackTrace();
        }
        System.exit(exitCode);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(helpText);
            return;
        }
        Unique uq = new Unique();
        try {
            uq.time = System.currentTimeMillis();
            uq.setParameters(args);
            uq.init();
            uq.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private final class ResultWriterThread
    extends Thread {
        private boolean canRun = true;

        private ResultWriterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MolExporter me = null;
            try {
                me = new MolExporter(Unique.this.output, Unique.this.outputFormat);
                while (this.canRun || !Unique.this.results.isEmpty()) {
                    if (Unique.this.results.size() <= 0) continue;
                    String s = (String)Unique.this.results.take();
                    me.write(MolImporter.importMol(s));
                    me.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Unexpected error during writing results.");
                Unique.this.exit(1);
            }
            finally {
                if (me != null) {
                    try {
                        me.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.err.println("Unexpected error during writing results.");
                        Unique.this.exit(1);
                    }
                }
            }
            Unique.this.exit(0);
        }

        public void halt() {
            this.canRun = false;
        }
    }

    private final class DuplicateFilteringThread
    extends Thread {
        private boolean canRun = true;

        private DuplicateFilteringThread() {
        }

        @Override
        public void run() {
            try {
                while (this.canRun || !Unique.this.candidates.isEmpty()) {
                    if (Unique.this.candidates.size() <= 0) continue;
                    String s = (String)Unique.this.candidates.take();
                    Unique.this.uh.setStructure(s);
                    if (Unique.this.uh.execute(true) < 0) continue;
                    Unique.this.results.add(s);
                }
                Unique.this.rwt.halt();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Unexpected error during duplicate filtering.");
                Unique.this.exit(1);
            }
        }

        public void halt() {
            this.canRun = false;
        }
    }
}

