/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JFunctions;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ColumnDescriptor {
    public String colName;
    public int colType = 1111;
    public int colSize = -1;
    public String dfltValue;
    public boolean notNull;

    public ColumnDescriptor(String name, int type, int size, String dfltValue, boolean notNull) {
        this.colName = name.toUpperCase();
        this.colType = type;
        this.colSize = size;
        this.dfltValue = dfltValue;
        this.notNull = notNull;
    }

    public ColumnDescriptor(String name, int type, int size) {
        this(name, type, size, null, false);
    }

    public ColumnDescriptor(String name, int type) {
        this(name, type, -1, null, false);
    }

    public ColumnDescriptor(ResultSet rs) throws SQLException {
        this.colName = rs.getString("COLUMN_NAME");
        String typeStr = rs.getString("DATA_TYPE");
        if (typeStr.equals("BLOB")) {
            this.colType = 2004;
        } else if (typeStr.equals("NUMBER")) {
            this.colType = 2;
            this.colSize = rs.getInt("DATA_PRECISION");
        } else if (typeStr.equals("VARCHAR2")) {
            this.colType = 12;
            this.colSize = rs.getInt("DATA_LENGTH");
        } else if (typeStr.equals("FLOAT")) {
            this.colType = 6;
        } else if (typeStr.equals("DATE")) {
            this.colType = 91;
        }
        byte[] dfltValueAsBytes = JFunctions.readBytes(rs, "DATA_DEFAULT");
        if (dfltValueAsBytes != null) {
            this.dfltValue = new String(dfltValueAsBytes);
        }
        this.notNull = rs.getString("NULLABLE").equals("N");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.colName == null ? 0 : this.colName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDescriptor other = (ColumnDescriptor)obj;
        return !(this.colName == null ? other.colName != null : !this.colName.equals(other.colName));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.colName).append(" ");
        switch (this.colType) {
            case 2004: {
                buffer.append("BLOB");
                break;
            }
            case 12: {
                buffer.append("VARCHAR2(").append(this.colSize).append(")");
                break;
            }
            case 2: {
                buffer.append("NUMBER(").append(this.colSize).append(",0)");
                break;
            }
            case 6: {
                buffer.append("FLOAT");
                break;
            }
            case -7: {
                buffer.append("NUMBER(1,0)");
                break;
            }
            case 91: {
                buffer.append("DATE");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected SQL type: " + this.colType);
            }
        }
        if (this.dfltValue != null) {
            buffer.append(" ").append(this.dfltValue);
        }
        if (this.notNull) {
            buffer.append(" NOT NULL");
        }
        return buffer.toString();
    }

    public boolean isSame(ColumnDescriptor obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDescriptor other = obj;
        if (this.colName == null ? other.colName != null : !this.colName.equals(other.colName)) {
            return false;
        }
        if (this.colSize != other.colSize) {
            return false;
        }
        if (this.colType != other.colType) {
            return false;
        }
        if (this.dfltValue == null ? other.dfltValue != null : !this.dfltValue.equals(other.dfltValue)) {
            return false;
        }
        return this.notNull == other.notNull;
    }
}

